% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-special.R
\name{search_envs}
\alias{search_envs}
\alias{search_env}
\alias{pkg_env}
\alias{pkg_env_name}
\alias{is_attached}
\alias{base_env}
\alias{global_env}
\title{Search path environments}
\usage{
search_envs()

search_env(name)

pkg_env(pkg)

pkg_env_name(pkg)

is_attached(x)

base_env()

global_env()
}
\arguments{
\item{name}{The name of an environment attached to the search
path. Call \code{\link[base:search]{base::search()}} to get the names of environments
currently attached to the search path. Note that the search name
of a package environment is prefixed with \code{"package:"}.}

\item{pkg}{The name of a package.}

\item{x}{An environment or a search name.}
}
\description{
The search path is a chain of environments containing exported
functions of attached packages.

The API includes:
\itemize{
\item \code{\link[base:search]{base::search()}} to get the names of environments attached to the
search path.
\item \code{search_envs()} returns the environments on the search path as a
list.
\item \code{pkg_env_name()} takes a bare package name and prefixes it with
\code{"package:"}. Attached package environments have search names of
the form \code{package:name}.
\item \code{pkg_env()} takes a bare package name and returns the scoped
environment of packages if they are attached to the search path,
and throws an error otherwise. It is a shortcut for
\code{search_env(pkg_env_name("pkgname"))}.
\item \code{global_env()} and \code{base_env()} (simple aliases for \code{\link[=globalenv]{globalenv()}}
and \code{\link[=baseenv]{baseenv()}}). These are respectively the first and last
environments of the search path.
\item \code{is_attached()} returns \code{TRUE} when its argument (a search name
or a package environment) is attached to the search path.
}
}
\section{The search path}{


This chain of environments determines what objects are visible from
the global workspace. It contains the following elements:
\itemize{
\item The chain always starts with \code{global_env()} and finishes with
\code{base_env()} which inherits from the terminal environment
\code{empty_env()}.
\item Each \code{\link[base:library]{base::library()}} call attaches a new package environment to
the search path. Attached packages are associated with a \link[=env_name]{search name}.
\item In addition, any list, data frame, or environment can be attached
to the search path with \code{\link[base:attach]{base::attach()}}.
}
}

\examples{
# List the search names of environments attached to the search path:
search()

# Get the corresponding environments:
search_envs()

# The global environment and the base package are always first and
# last in the chain, respectively:
envs <- search_envs()
envs[[1]]
envs[[length(envs)]]

# These two environments have their own shortcuts:
global_env()
base_env()

# Packages appear in the search path with a special name. Use
# pkg_env_name() to create that name:
pkg_env_name("rlang")
search_env(pkg_env_name("rlang"))

# Alternatively, get the scoped environment of a package with
# pkg_env():
pkg_env("utils")
}
\keyword{internal}
