% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXFooter.R, R/SDMXFooter-methods.R
\docType{class}
\name{SDMXFooter}
\alias{SDMXFooter}
\alias{SDMXFooter,SDMXFooter-method}
\alias{SDMXFooter-class}
\title{Class "SDMXFooter"}
\usage{
SDMXFooter(xmlObj)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}
}
\value{
an object of class "SDMXFooter"
}
\description{
A basic class to handle the footer of a SDMX-ML document
}
\section{Slots}{

\describe{
\item{\code{messages}}{Object of class "SDMXFooterMessage" giving the list of messages}
}}
\note{
This class is especially useful for SDMX 2.1 compliant documents. Footer
messages are not supported in SDMX 2.0standard format. In this case, the footer
will return an empty message list().

According to the SDMX 2.1 standard, the message severity takes one of the
following values: "Error", "Warning","Information". Given the possible typos
handled by data providers, rsdmx adopts a permissive strategy and does not
validate the object according to such controlled terms.
}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document.
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{readSDMX}
}

