/*
 * RED5 Open Source Flash Server - http://code.google.com/p/red5/
 * 
 * Copyright 2006-2012 by respective authors (see below). All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.red5.server.net.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory.RequestSpecificProcessorFactoryFactory;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.red5.server.api.IContext;
import org.red5.server.statistics.XmlRpcScopeStatistics;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * Servlet that processes the statistics XML-RPC requests.
 * 
 * @author The Red5 Project (red5@osflash.org)
 * @author Joachim Bauch (jojo@struktur.de)
 */
public class StatisticsServlet extends XmlRpcServlet {

	private static final long serialVersionUID = 5810139109603229027L;

	protected transient WebApplicationContext webAppCtx;

	protected transient IContext webContext;

	/** {@inheritDoc} */
	@Override
	public void init() throws ServletException {
		super.init();
		webAppCtx = WebApplicationContextUtils.getWebApplicationContext(getServletContext());
		if (webAppCtx == null) {
			webAppCtx = (WebApplicationContext) getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
		}
		if (webAppCtx == null) {
			throw new ServletException("No web application context found.");
		}

		webContext = (IContext) webAppCtx.getBean("web.context");
	}

	public IContext getContext() {
		return this.webContext;
	}

	protected PropertyHandlerMapping newPropertyHandlerMapping(URL url) throws IOException, XmlRpcException {
		PropertyHandlerMapping mapping = new PropertyHandlerMapping();

		mapping.addHandler("scopes", XmlRpcScopeStatistics.class);

		RequestProcessorFactoryFactory factory = new RequestSpecificProcessorFactoryFactory(){
			protected Object getRequestProcessor(Class pClass, XmlRpcRequest pRequest) throws XmlRpcException {
				XmlRpcScopeStatistics stats = (XmlRpcScopeStatistics) super.getRequestProcessor(pClass, pRequest);
				stats.setGlobalScope(StatisticsServlet.this.getContext().getGlobalScope());
				return stats;
			}
		};
		mapping.setRequestProcessorFactoryFactory(factory);
		mapping.load(Thread.currentThread().getContextClassLoader(), url);
		return mapping;
	}
}
