#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "p-laplacian-fixed-point.h"
#include "poisson-dirichlet.icc"
int main(int argc, char**argv) {
  geo omega_h (argv[1]);
  string approx = (argc > 2) ?      argv[2]  : "P1";
  Float  p      = (argc > 3) ? atof(argv[3]) : 2.5;
  cerr << "# P-Laplacian problem by fixed-point:" << endl
       << "# geo = " << omega_h.name() << endl
       << "# approx = " << approx << endl
       << "# p = " << p << endl;
  space Vh (omega_h, approx);
  Vh.block (omega_h["boundary"]);
  field uh (Vh);
  uh ["boundary"] = 0;
  field fh (Vh, 1);
  poisson_dirichlet (fh, uh);
  Float tol = 10*numeric_limits<Float>::epsilon();
  size_t max_iter = 500;
  int status = p_laplacian_fixed_point (p, fh, uh, tol, max_iter);
  cout << setprecision(numeric_limits<Float>::digits10)
       << catchmark("p") << p << endl
       << catchmark("u") << uh;
  return status;
}
