/* The following code was generated by JFlex 1.4.1 on 6/21/15 11:19 AM */

/*
 * 09/11/2008
 *
 * RubyTokenMaker.java - Scanner for Ruby
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Ruby.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>RubyTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class RubyTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int HEREDOC_EOF_SINGLE_QUOTED = 11;
  public static final int DOCCOMMENT = 14;
  public static final int HEREDOC_EOT_SINGLE_QUOTED = 13;
  public static final int HEREDOC_EOT_UNQUOTED = 12;
  public static final int STRING_Q_SLASH = 5;
  public static final int STRING_Q_BANG = 2;
  public static final int STRING_Q_LT = 7;
  public static final int STRING = 1;
  public static final int BACKTICKS = 9;
  public static final int YYINITIAL = 0;
  public static final int HEREDOC_EOF_UNQUOTED = 10;
  public static final int STRING_Q_CURLY_BRACE = 3;
  public static final int STRING_Q_PAREN = 4;
  public static final int HEREDOC_EOF_DOUBLE_QUOTED = 11;
  public static final int CHAR_LITERAL = 8;
  public static final int HEREDOC_EOT_DOUBLE_QUOTED = 13;
  public static final int STRING_Q_SQUARE_BRACKET = 6;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\24\1\23\1\0\1\24\1\7\22\0\1\24\1\44\1\106"+
    "\1\10\1\56\1\50\1\53\1\107\1\111\1\36\1\46\1\35\1\60"+
    "\1\43\1\40\1\47\1\3\1\4\6\6\2\2\1\37\1\60\1\51"+
    "\1\25\1\52\1\104\1\57\1\67\1\62\1\5\1\61\1\34\1\64"+
    "\1\63\1\1\1\65\2\1\1\1\1\1\1\66\1\70\1\1\1\110"+
    "\1\1\1\73\1\71\1\1\1\1\1\110\3\1\1\41\1\11\1\42"+
    "\1\55\1\12\1\113\1\20\1\26\1\76\1\32\1\16\1\17\1\27"+
    "\1\102\1\30\1\1\1\75\1\21\1\77\1\31\1\72\1\101\1\105"+
    "\1\14\1\22\1\13\1\15\1\74\1\103\1\33\1\100\1\1\1\112"+
    "\1\54\1\114\1\45\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\17\0\1\1\1\2\2\3\1\2\1\4\10\2\1\5"+
    "\1\6\1\7\6\2\1\7\1\10\1\2\10\7\2\1"+
    "\11\2\1\11\1\2\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\15\1\21\1\15\1\22\1\15\1\23"+
    "\1\15\1\24\1\15\1\25\1\15\1\26\1\15\1\27"+
    "\1\30\1\31\1\15\1\32\1\33\1\15\1\34\1\15"+
    "\1\35\1\36\1\15\1\37\1\15\1\40\1\15\1\1"+
    "\1\41\1\3\4\1\30\2\1\0\7\2\1\42\5\2"+
    "\1\43\1\7\1\0\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\2\7\3\52\1\0\1\1\4\2\1\7\12\2"+
    "\1\16\1\27\2\15\1\0\2\41\2\3\1\53\24\2"+
    "\1\42\7\2\1\11\6\2\1\0\10\2\1\42\5\0"+
    "\20\2\1\54\1\0\1\1\1\41\3\1\1\55\1\2"+
    "\1\11\16\2\1\11\5\2\1\0\3\2\4\0\11\2"+
    "\1\56\1\0\12\2\1\0\2\2\1\57\1\60\3\0"+
    "\2\2\1\11\5\2\1\61\1\2\6\0\4\2\1\62"+
    "\1\63\1\11\7\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\115\0\232\0\347\0\u0134\0\u0181\0\u01ce\0\u021b"+
    "\0\u0268\0\u02b5\0\u0302\0\u034f\0\u039c\0\u03e9\0\u0436\0\u0483"+
    "\0\u04d0\0\u051d\0\u056a\0\u05b7\0\u0604\0\u0651\0\u069e\0\u06eb"+
    "\0\u0738\0\u0785\0\u07d2\0\u081f\0\u086c\0\u05b7\0\u08b9\0\u0906"+
    "\0\u0953\0\u09a0\0\u09ed\0\u0a3a\0\u0a87\0\u0ad4\0\u0b21\0\u05b7"+
    "\0\u0b6e\0\u0bbb\0\u05b7\0\u0c08\0\u0c55\0\u0ca2\0\u0cef\0\u0d3c"+
    "\0\u0d89\0\u0dd6\0\u0e23\0\u0e70\0\u0ebd\0\u0f0a\0\u0f57\0\u0fa4"+
    "\0\u0ff1\0\u103e\0\u108b\0\u10d8\0\u1125\0\u1172\0\u05b7\0\u05b7"+
    "\0\u05b7\0\u11bf\0\u120c\0\u05b7\0\u05b7\0\u1259\0\u05b7\0\u12a6"+
    "\0\u05b7\0\u12f3\0\u05b7\0\u1340\0\u05b7\0\u138d\0\u05b7\0\u13da"+
    "\0\u05b7\0\u1427\0\u1474\0\u05b7\0\u05b7\0\u14c1\0\u05b7\0\u05b7"+
    "\0\u150e\0\u05b7\0\u155b\0\u05b7\0\u05b7\0\u15a8\0\u05b7\0\u15f5"+
    "\0\u05b7\0\u1642\0\u168f\0\u16dc\0\u1729\0\u1729\0\u1776\0\u17c3"+
    "\0\u1810\0\u185d\0\u18aa\0\u18f7\0\u1944\0\u1991\0\u19de\0\u1a2b"+
    "\0\u1a78\0\u1ac5\0\u1b12\0\u1b5f\0\u1bac\0\u1bf9\0\u1c46\0\u1c93"+
    "\0\u1ce0\0\u1d2d\0\u1d7a\0\u1dc7\0\u1e14\0\u1e61\0\u1eae\0\u1efb"+
    "\0\u1f48\0\u1f95\0\u1fe2\0\u202f\0\u207c\0\u20c9\0\u2116\0\u2163"+
    "\0\u21b0\0\u04d0\0\u21fd\0\u224a\0\u2297\0\u22e4\0\u2331\0\u237e"+
    "\0\u23cb\0\u2418\0\u05b7\0\u05b7\0\u05b7\0\u05b7\0\u05b7\0\u05b7"+
    "\0\u2465\0\u24b2\0\u24ff\0\u0483\0\u05b7\0\u254c\0\u2599\0\u25e6"+
    "\0\u2633\0\u2680\0\u26cd\0\u04d0\0\u271a\0\u2767\0\u27b4\0\u2801"+
    "\0\u284e\0\u289b\0\u28e8\0\u2935\0\u2982\0\u29cf\0\u05b7\0\u05b7"+
    "\0\u2a1c\0\u2a69\0\u2ab6\0\u2b03\0\u2b50\0\u2b9d\0\u2bea\0\u2c37"+
    "\0\u2c84\0\u2cd1\0\u2d1e\0\u2d6b\0\u2db8\0\u2e05\0\u2e52\0\u2e9f"+
    "\0\u2eec\0\u2f39\0\u2f86\0\u2fd3\0\u3020\0\u306d\0\u30ba\0\u3107"+
    "\0\u3154\0\u31a1\0\u31ee\0\u323b\0\u3288\0\u32d5\0\u3322\0\u336f"+
    "\0\u33bc\0\u3409\0\u3456\0\u34a3\0\u34f0\0\u353d\0\u358a\0\u35d7"+
    "\0\u3624\0\u3671\0\u36be\0\u370b\0\u3758\0\u37a5\0\u37f2\0\u383f"+
    "\0\u388c\0\u38d9\0\u3926\0\u3973\0\u39c0\0\u3a0d\0\u3a5a\0\u3aa7"+
    "\0\u3af4\0\u3b41\0\u3b8e\0\u3bdb\0\u3c28\0\u3c75\0\u3cc2\0\u3d0f"+
    "\0\u3d5c\0\u3da9\0\u3df6\0\u3e43\0\u3e90\0\u3edd\0\u3f2a\0\u3f77"+
    "\0\u3fc4\0\u4011\0\u150e\0\u405e\0\u2b03\0\u40ab\0\u2b9d\0\u2bea"+
    "\0\u2c37\0\u04d0\0\u40f8\0\u04d0\0\u4145\0\u4192\0\u41df\0\u422c"+
    "\0\u4279\0\u42c6\0\u4313\0\u4360\0\u43ad\0\u43fa\0\u4447\0\u4494"+
    "\0\u44e1\0\u452e\0\u05b7\0\u457b\0\u45c8\0\u4615\0\u4662\0\u46af"+
    "\0\u46fc\0\u4749\0\u4796\0\u47e3\0\u4830\0\u487d\0\u48ca\0\u4917"+
    "\0\u4964\0\u49b1\0\u49fe\0\u4a4b\0\u4a98\0\u4ae5\0\u4b32\0\u4b7f"+
    "\0\u4bcc\0\u05b7\0\u40ab\0\u4c19\0\u4c66\0\u4cb3\0\u4d00\0\u4d4d"+
    "\0\u4d9a\0\u4de7\0\u4e34\0\u4e81\0\u4ece\0\u4f1b\0\u4f68\0\u4fb5"+
    "\0\u05b7\0\u05b7\0\u5002\0\u504f\0\u509c\0\u50e9\0\u5136\0\u5183"+
    "\0\u51d0\0\u521d\0\u526a\0\u52b7\0\u5183\0\u05b7\0\u5304\0\u5351"+
    "\0\u539e\0\u53eb\0\u5438\0\u5485\0\u54d2\0\u551f\0\u556c\0\u55b9"+
    "\0\u5606\0\u05b7\0\u05b7\0\u383f\0\u5653\0\u56a0\0\u56ed\0\u573a"+
    "\0\u5787\0\u57d4\0\u5821";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\20\1\21\1\22\1\23\1\22\1\21\1\22\1\24"+
    "\1\25\1\20\1\21\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\21\1\46\1\47\1\50\1\51"+
    "\1\52\2\53\1\47\1\54\1\53\2\47\1\55\1\56"+
    "\1\57\1\60\1\61\1\53\1\62\1\63\1\24\1\21"+
    "\1\64\1\21\1\65\1\66\1\21\1\67\2\21\1\70"+
    "\1\71\2\21\1\72\1\73\1\74\1\75\1\21\1\76"+
    "\1\24\1\21\1\77\1\100\1\21\2\50\1\101\1\50"+
    "\11\102\1\103\11\102\1\104\62\102\1\105\6\102\11\106"+
    "\1\103\11\106\1\107\20\106\1\105\50\106\11\110\1\103"+
    "\11\110\1\111\70\110\1\105\11\112\1\103\11\112\1\113"+
    "\12\112\1\105\56\112\11\114\1\103\11\114\1\115\23\114"+
    "\1\105\45\114\11\116\1\103\11\116\1\117\16\116\1\105"+
    "\52\116\11\120\1\103\11\120\1\121\26\120\1\105\42\120"+
    "\11\122\1\123\11\122\1\124\63\122\1\125\5\122\11\126"+
    "\1\103\11\126\1\127\67\126\1\130\1\126\11\131\1\103"+
    "\11\131\1\132\10\131\1\133\71\131\1\103\11\131\1\134"+
    "\10\131\1\133\71\131\1\103\11\131\1\135\10\131\1\136"+
    "\71\131\1\103\11\131\1\137\10\131\1\136\60\131\23\140"+
    "\1\141\1\140\1\142\67\140\7\20\1\0\13\20\3\0"+
    "\7\20\21\0\2\20\1\0\23\20\1\0\1\20\2\0"+
    "\1\20\4\0\1\20\6\21\1\0\2\20\11\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\2\20\3\22\1\20\1\22\1\0\2\20"+
    "\1\143\3\20\1\144\4\20\3\0\6\20\1\144\21\0"+
    "\2\20\1\0\23\20\1\0\1\20\2\0\1\20\4\0"+
    "\3\20\2\145\1\20\1\145\1\0\2\20\1\146\10\20"+
    "\3\0\1\147\3\20\1\150\1\151\1\20\21\0\2\20"+
    "\1\0\23\20\1\0\1\20\2\0\1\20\121\0\23\25"+
    "\1\0\71\25\1\20\6\21\1\0\2\20\2\21\1\152"+
    "\1\21\1\153\4\21\3\0\7\21\21\0\2\20\1\0"+
    "\21\21\1\154\1\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\155\1\21\1\156"+
    "\2\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\3\21\1\157\3\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\7\21\1\160\1\21\3\0\3\21\1\161"+
    "\1\21\1\162\1\21\21\0\2\20\1\0\13\21\1\163"+
    "\7\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\6\21\1\164\2\21\3\0\7\21\21\0"+
    "\2\20\1\0\11\21\1\165\11\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\1\21\1\166"+
    "\1\21\1\167\3\21\1\170\1\21\3\0\3\21\1\171"+
    "\3\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\6\21\1\172"+
    "\2\21\3\0\7\21\21\0\2\20\1\0\11\21\1\173"+
    "\11\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\2\21\1\174\1\175\1\176\2\21\1\177"+
    "\1\21\3\0\7\21\21\0\2\20\1\0\17\21\1\200"+
    "\1\201\2\21\1\0\1\21\2\0\1\21\30\0\1\37"+
    "\115\0\1\47\1\202\16\0\1\53\47\0\1\20\6\21"+
    "\1\0\2\20\2\21\1\203\1\21\1\204\4\21\3\0"+
    "\2\21\1\205\4\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\4\21\1\206\2\21\1\207\1\210\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\1\21\1\211\3\21\1\212"+
    "\3\21\3\0\3\21\1\212\3\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\4\21\1\213\4\21\3\0\2\21\1\214"+
    "\4\21\21\0\2\20\1\0\11\21\1\215\11\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\4\21\1\216\4\21\3\0\7\21\21\0\2\20\1\0"+
    "\11\21\1\212\11\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\7\21\21\0"+
    "\2\20\1\0\5\21\1\217\15\21\1\0\1\21\2\0"+
    "\1\21\31\0\1\53\70\0\1\220\3\0\1\220\4\0"+
    "\11\220\3\0\7\220\2\0\1\53\21\0\23\220\1\0"+
    "\1\220\2\0\1\220\44\0\1\221\101\0\1\53\17\0"+
    "\1\53\74\0\1\53\5\0\1\222\5\0\1\223\2\0"+
    "\1\224\2\0\1\225\1\0\1\226\31\0\1\222\1\0"+
    "\1\222\2\0\1\222\1\227\1\230\27\0\1\231\23\0"+
    "\1\232\70\0\1\53\24\0\1\53\115\0\1\53\115\0"+
    "\1\53\40\0\1\20\1\233\3\234\1\233\1\234\1\0"+
    "\2\20\11\233\2\0\1\235\7\233\1\235\1\0\2\235"+
    "\2\0\1\236\4\235\1\0\3\235\2\0\2\234\1\235"+
    "\23\233\1\235\1\233\2\235\1\233\2\0\1\235\1\0"+
    "\1\20\1\233\3\20\1\233\1\20\1\0\2\20\11\233"+
    "\3\0\7\233\21\0\1\20\1\237\1\0\23\233\1\0"+
    "\1\233\2\0\1\233\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\6\21\1\240\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\7\21\1\241\1\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\3\21\1\242\3\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\2\21\1\243\6\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\2\21"+
    "\1\244\6\21\3\0\7\21\21\0\2\20\1\0\20\21"+
    "\1\245\2\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\1\21\1\246\7\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\6\21\1\247\1\250"+
    "\1\21\3\0\7\21\21\0\2\20\1\0\21\21\1\251"+
    "\1\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\7\21\21\0\2\20\1\0"+
    "\11\21\1\252\11\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\2\21\1\253"+
    "\4\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\2\21\1\254"+
    "\1\255\5\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\21\21"+
    "\1\256\1\21\1\0\1\21\2\0\1\21\4\0\11\102"+
    "\1\0\11\102\1\0\62\102\1\0\6\102\23\257\1\0"+
    "\71\257\11\106\1\0\11\106\1\0\20\106\1\0\50\106"+
    "\11\110\1\0\11\110\1\0\70\110\1\0\11\112\1\0"+
    "\11\112\1\0\12\112\1\0\56\112\11\114\1\0\11\114"+
    "\1\0\23\114\1\0\45\114\11\116\1\0\11\116\1\0"+
    "\16\116\1\0\52\116\11\120\1\0\11\120\1\0\26\120"+
    "\1\0\42\120\11\122\1\0\11\122\1\0\63\122\1\0"+
    "\5\122\23\260\1\0\71\260\11\126\1\0\11\126\1\0"+
    "\67\126\1\0\1\126\11\131\1\0\11\131\1\0\102\131"+
    "\1\0\11\131\1\0\44\131\1\261\35\131\1\0\11\131"+
    "\1\0\44\131\1\262\24\131\23\140\1\0\1\140\1\0"+
    "\67\140\16\0\1\263\76\0\2\20\3\22\1\20\1\22"+
    "\1\0\2\20\1\143\10\20\3\0\7\20\21\0\2\20"+
    "\1\0\23\20\1\0\1\20\2\0\1\20\4\0\2\20"+
    "\3\264\1\20\1\264\1\0\13\20\3\0\7\20\1\265"+
    "\5\0\1\265\12\0\2\20\1\0\23\20\1\0\1\20"+
    "\2\0\1\20\4\0\3\20\2\145\1\20\1\145\1\0"+
    "\2\20\1\146\10\20\3\0\7\20\21\0\2\20\1\0"+
    "\23\20\1\0\1\20\2\0\1\20\4\0\3\20\2\266"+
    "\2\20\1\0\13\20\3\0\7\20\21\0\2\20\1\0"+
    "\23\20\1\0\1\20\2\0\1\20\4\0\2\20\3\267"+
    "\1\20\1\267\1\0\13\20\3\0\7\20\21\0\2\20"+
    "\1\0\23\20\1\0\1\20\2\0\1\20\4\0\2\20"+
    "\5\270\1\0\6\20\3\270\2\20\3\0\1\270\3\20"+
    "\1\270\1\20\1\270\21\0\2\20\1\0\2\270\1\20"+
    "\1\270\2\20\1\270\6\20\1\270\5\20\1\0\1\20"+
    "\2\0\1\20\4\0\1\20\6\21\1\0\2\20\3\21"+
    "\1\271\2\21\1\272\2\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\10\21\1\273\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\274\4\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\1\21\1\275"+
    "\4\21\1\276\1\21\1\277\3\0\4\21\1\300\2\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\301\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\2\21"+
    "\1\302\1\303\3\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\1\21\1\304\5\21\1\305\1\21\3\0\4\21\1\306"+
    "\2\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\10\21\1\307"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\10\21"+
    "\1\310\3\0\4\21\1\212\2\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\4\21\1\311\4\21\3\0\2\21\1\312"+
    "\4\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\6\21\1\313"+
    "\2\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\7\21\1\314\1\21\3\0\2\21\1\313\4\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\2\21\1\315\6\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\1\316\10\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\317\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\2\21\1\320\4\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\4\21\1\244\2\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\16\21\1\321\4\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\6\21"+
    "\1\303\2\21\3\0\7\21\21\0\2\20\1\0\11\21"+
    "\1\322\3\21\1\323\5\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\6\21\1\324\2\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\1\325\6\21\21\0\2\20\1\0\20\21\1\326"+
    "\2\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\7\21\1\327\1\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\330\4\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\10\21\1\331"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\2\21"+
    "\1\332\4\21\1\333\1\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\22\0\1\334"+
    "\76\0\1\20\6\21\1\0\2\20\4\21\1\335\4\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\1\21\1\336\5\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\3\21\1\337\3\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\1\21\1\340\7\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\11\21\1\341\11\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\3\21"+
    "\1\342\5\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\343\4\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\5\21\1\344\1\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\7\21\1\212\1\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\244\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\5\21\1\345\3\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\7\21\21\0\2\20"+
    "\1\0\1\212\22\21\1\0\1\21\2\0\1\21\5\0"+
    "\6\220\3\0\11\220\3\0\7\220\24\0\23\220\1\0"+
    "\1\220\2\0\1\220\44\0\1\53\115\0\1\223\2\0"+
    "\1\224\2\0\1\225\1\0\1\226\37\0\1\227\1\230"+
    "\54\0\1\53\66\0\1\346\7\0\1\347\51\0\1\350"+
    "\1\351\3\0\1\352\1\0\1\20\6\233\1\0\2\20"+
    "\11\233\3\0\7\233\21\0\2\20\1\0\23\233\1\0"+
    "\1\233\2\0\1\233\7\0\1\235\14\0\2\235\6\0"+
    "\1\235\1\0\1\235\31\0\2\235\6\0\1\235\4\0"+
    "\1\235\1\0\1\235\11\0\1\20\1\233\3\20\1\233"+
    "\1\20\1\0\2\20\11\233\3\0\7\233\21\0\2\20"+
    "\1\0\23\233\1\0\1\233\2\0\1\233\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\7\21\21\0\2\20"+
    "\1\0\2\21\1\353\20\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\11\21\1\354\11\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\355\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\2\21\1\356\6\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\4\21\1\357\4\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\2\21\1\360\6\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\361\5\21\1\362\1\363\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\6\21\1\364\2\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\11\21\1\365\11\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\4\21\1\366\2\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\367\4\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\2\21\1\370\4\21"+
    "\21\0\2\20\1\0\11\21\1\311\11\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\371\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\274\4\21\3\0\2\21\1\372\4\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\11\131\1\0\11\131\1\0\40\131\1\373\41\131"+
    "\1\0\11\131\1\0\45\131\1\373\23\131\31\0\1\374"+
    "\63\0\2\20\3\264\1\20\1\264\1\0\2\20\1\375"+
    "\10\20\3\0\7\20\21\0\2\20\1\0\23\20\1\0"+
    "\1\20\2\0\1\20\6\0\3\376\1\0\1\376\106\0"+
    "\3\20\2\266\2\20\1\0\2\20\1\377\10\20\3\0"+
    "\7\20\21\0\2\20\1\0\23\20\1\0\1\20\2\0"+
    "\1\20\4\0\2\20\3\267\1\20\1\267\1\0\2\20"+
    "\1\u0100\10\20\3\0\7\20\21\0\2\20\1\0\23\20"+
    "\1\0\1\20\2\0\1\20\4\0\1\20\1\u0101\5\270"+
    "\1\0\2\20\4\u0101\3\270\2\u0101\3\0\1\270\3\u0101"+
    "\1\270\1\u0101\1\270\21\0\2\20\1\0\2\270\1\u0101"+
    "\1\270\2\u0101\1\270\6\u0101\1\270\5\u0101\1\0\1\u0101"+
    "\2\0\1\u0101\4\0\1\20\6\21\1\0\2\20\4\21"+
    "\1\u0102\4\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\15\21"+
    "\1\u0103\2\21\1\u0104\2\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\1\21\1\u0104\7\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\3\21\1\212\3\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\2\21\1\u0105\1\u0106\5\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\4\21\1\u0107"+
    "\2\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\11\21\3\0"+
    "\7\21\21\0\2\20\1\0\15\21\1\u0108\5\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\7\21\21\0\2\20\1\0\11\21\1\212"+
    "\11\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\3\21\1\u0109\5\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\10\21\1\u010a\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\4\21"+
    "\1\u0104\2\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\2\21"+
    "\1\u010b\6\21\3\0\2\21\1\214\4\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\4\21\1\364\4\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\4\21\1\u010c\4\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\4\21"+
    "\1\212\4\21\3\0\2\21\1\u010c\4\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\3\21\1\u010d\5\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\15\21\1\u0104\5\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\325\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\7\21\1\u0104\1\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\10\21\1\271\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\7\21\21\0"+
    "\2\20\1\0\14\21\1\u0104\1\21\1\354\4\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\4\21\1\u010e\4\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\7\21\21\0\2\20\1\0"+
    "\11\21\1\u010f\11\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\6\21\1\u0110\2\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\11\21\3\0"+
    "\1\u0111\6\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\7\21\21\0\2\20\1\0\20\21\1\u0104\2\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\6\21\1\u0112\2\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\3\21\1\303\3\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\7\0\1\u0113\11\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\4\21"+
    "\1\u0114\4\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\u0115\1\212\3\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\322\4\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\1\21\1\u0116"+
    "\7\21\3\0\7\21\21\0\2\20\1\0\15\21\1\u0117"+
    "\5\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\2\21\1\u0118\4\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\2\21\1\273"+
    "\4\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\33\0\1\u0119\65\0\1\20\6\21\1\0\2\20"+
    "\6\21\1\u011a\2\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\2\21\1\274\4\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\4\21\1\360"+
    "\2\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\10\21\1\u0104"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\1\323\6\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\1\325\6\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\2\21\1\u011b\6\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\1\21\1\212\7\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\2\21"+
    "\1\u011c\4\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\30\0\1\346\61\0\1\350\1\351\3\0"+
    "\1\352\71\0\1\u011d\60\0\1\u011e\114\0\1\u011f\114\0"+
    "\1\u0120\60\0\1\20\6\21\1\0\2\20\11\21\3\0"+
    "\7\21\21\0\2\20\1\0\4\21\1\u0121\16\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\6\21\1\273\2\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\4\21\1\u0122\4\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\6\21\1\u0123\2\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\11\21\3\0"+
    "\3\21\1\u0104\3\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\2\21\1\u0124\4\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\7\21\21\0\2\20\1\0"+
    "\15\21\1\u0125\5\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\7\21\1\u0126\1\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\4\21\1\212"+
    "\4\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\10\21\1\u0110\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\16\21"+
    "\1\u0127\1\21\1\325\2\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\3\21\1\372\5\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\7\21"+
    "\1\u0128\1\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\3\21\1\u0129\3\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\10\21\1\u0104\3\0\7\21\21\0"+
    "\2\20\1\0\15\21\1\u0104\5\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\7\21\1\363"+
    "\1\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\36\0\1\u012a\64\0\3\376\1\0"+
    "\1\376\3\0\1\u012b\102\0\1\20\6\21\1\0\2\20"+
    "\4\21\1\u012c\4\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\7\21\21\0\2\20\1\0"+
    "\17\21\1\212\3\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\2\21\1\274\6\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\7\21\1\u012d"+
    "\1\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\3\21\1\363\5\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\2\21\1\u012e\4\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\u0104\4\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\6\21\1\u012f"+
    "\2\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\5\21\1\212\3\21\3\0\7\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\2\21\1\363\6\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\5\21\1\333"+
    "\1\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\7\21\1\u0130"+
    "\1\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\10\21\1\212\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\4\21\1\u0131\2\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\7\21\1\u0132\1\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\2\21\1\212\6\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\7\21\21\0\2\20\1\0\15\21\1\273\5\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\u0133\4\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\6\21\1\u0134\2\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\3\21"+
    "\1\u0135\3\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\34\0\1\u0136\64\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\14\21"+
    "\1\212\6\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\6\21\1\u0137\2\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\3\21"+
    "\1\u0138\3\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\70\0\1\u0139\4\0\1\u013a\113\0\1\u013b"+
    "\114\0\1\u013c\114\0\1\u013d\24\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\5\21"+
    "\1\212\15\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\1\21\1\u0126\5\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\17\21\1\u0104\3\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\3\21\1\u013e\3\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\7\21\21\0\2\20\1\0\21\21"+
    "\1\u0104\1\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\4\21\1\u013f\4\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\20\21\1\325\2\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\4\21\1\212\2\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\1\21\1\u0140\7\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\1\u0141\10\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\11\21\3\0\2\21\1\u0142"+
    "\4\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\2\21\1\u010a"+
    "\6\21\3\0\7\21\21\0\2\20\1\0\23\21\1\0"+
    "\1\21\2\0\1\21\4\0\1\20\6\21\1\0\2\20"+
    "\11\21\3\0\7\21\21\0\2\20\1\0\15\21\1\u0103"+
    "\5\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\11\21\3\0\7\21\21\0\2\20\1\0"+
    "\11\21\1\u0143\11\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\6\21\1\u0104\2\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0\1\20\6\21\1\0\2\20\1\u0144\10\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\7\21\21\0\2\20\1\0\16\21\1\u0104\4\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\7\21\1\313\1\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\1\21\1\u0145\7\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\35\0\1\u0146\63\0\1\20\6\21\1\0\2\20\1\21"+
    "\1\u0147\7\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\4\21\1\u0128\4\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\70\0\1\u0148"+
    "\4\0\1\u0149\107\0\1\u014a\4\0\1\u014b\107\0\1\u014c"+
    "\4\0\1\u014d\23\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\1\21\1\u0104\5\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\2\21\1\u0104\6\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\5\21\1\u0104\3\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\13\21\1\u014e\7\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\11\21"+
    "\3\0\3\21\1\u014f\3\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\6\21\1\303\2\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\11\21\3\0\7\21\21\0\2\20"+
    "\1\0\13\21\1\u0150\7\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\11\21\1\u0151\11\21\1\0\1\21"+
    "\2\0\1\21\112\0\1\u0139\114\0\1\u013a\115\0\1\u0152"+
    "\114\0\1\u0153\120\0\1\u0139\114\0\1\u013a\1\0\1\20"+
    "\6\21\1\0\2\20\6\21\1\u013f\2\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\4\21\1\u0154\4\21"+
    "\3\0\7\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\6\21"+
    "\1\u0155\2\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\2\21\1\u0156\6\21\3\0\7\21\21\0\2\20"+
    "\1\0\23\21\1\0\1\21\2\0\1\21\4\0\1\20"+
    "\6\21\1\0\2\20\2\21\1\u0157\6\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\0\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\7\21"+
    "\21\0\2\20\1\0\23\21\1\u0113\1\21\2\0\1\21"+
    "\4\0\1\20\6\21\1\0\2\20\11\21\3\0\2\21"+
    "\1\u0158\4\21\21\0\2\20\1\0\23\21\1\0\1\21"+
    "\2\0\1\21\4\0\1\20\6\21\1\0\2\20\6\21"+
    "\1\u0159\2\21\3\0\7\21\21\0\2\20\1\0\23\21"+
    "\1\0\1\21\2\0\1\21\4\0\1\20\6\21\1\0"+
    "\2\20\11\21\3\0\1\u015a\6\21\21\0\2\20\1\0"+
    "\23\21\1\0\1\21\2\0\1\21\4\0\1\20\6\21"+
    "\1\0\2\20\7\21\1\u015b\1\21\3\0\7\21\21\0"+
    "\2\20\1\0\23\21\1\0\1\21\2\0\1\21\4\0"+
    "\1\20\6\21\1\0\2\20\4\21\1\340\4\21\3\0"+
    "\7\21\21\0\2\20\1\0\23\21\1\0\1\21\2\0"+
    "\1\21\4\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[22638];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\17\0\4\1\1\11\11\1\1\11\11\1\1\11\2\1"+
    "\1\11\23\1\3\11\2\1\2\11\1\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\2\1\2\11\1\1\2\11\1\1\1\11\1\1"+
    "\2\11\1\1\1\11\1\1\1\11\40\1\1\0\17\1"+
    "\1\0\6\11\4\1\1\11\1\0\20\1\2\11\2\1"+
    "\1\0\50\1\1\0\11\1\5\0\21\1\1\0\26\1"+
    "\1\11\5\1\1\0\3\1\4\0\11\1\1\11\1\0"+
    "\12\1\1\0\2\1\2\11\3\0\10\1\1\11\1\1"+
    "\6\0\4\1\2\11\10\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_UNQUOTED			= -1;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an single quoted EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_SINGLE_QUOTED		= -2;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an double quoted EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_DOUBLE_QUOTED		= -3;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_UNQUOTED			= -4;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an single quoted EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_SINGLE_QUOTED		= -5;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an double quoted EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_DOUBLE_QUOTED		= -6;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q!...! style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_BANG				= -7;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q{...} style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_CURLY_BRACE		= -8;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q&lt;...&gt; style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_LT					= -9;


	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q(...) style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_PAREN					= -10;


	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q/.../ style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_SLASH				= -11;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q[...] style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_SQUARE_BRACKET		= -12;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public RubyTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "#", null };
	}


	/**
	 * Returns whether tokens of the specified type should have "mark
	 * occurrences" enabled for the current programming language.
	 *
	 * @param type The token type.
	 * @return Whether tokens of this type should have "mark occurrences"
	 *         enabled.
	 */
	@Override
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==Token.IDENTIFIER || type==Token.VARIABLE;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.COMMENT_DOCUMENTATION:
				state = DOCCOMMENT;
				start = text.offset;
				break;
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR_LITERAL;
				start = text.offset;
				break;
			case Token.LITERAL_BACKQUOTE:
				state = BACKTICKS;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_UNQUOTED:
				state = HEREDOC_EOF_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_SINGLE_QUOTED:
				state = HEREDOC_EOF_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_DOUBLE_QUOTED:
				state = HEREDOC_EOF_DOUBLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_UNQUOTED:
				state = HEREDOC_EOT_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_SINGLE_QUOTED:
				state = HEREDOC_EOT_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_DOUBLE_QUOTED:
				state = HEREDOC_EOT_DOUBLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_BANG:
				state = STRING_Q_BANG;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_CURLY_BRACE:
				state = STRING_Q_CURLY_BRACE;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_LT:
				state = STRING_Q_LT;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_PAREN:
				state = STRING_Q_PAREN;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_SLASH:
				state = STRING_Q_SLASH;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_SQUARE_BRACKET:
				state = STRING_Q_SQUARE_BRACKET;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public RubyTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public RubyTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 188) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 39: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_LT);
          }
        case 52: break;
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 53: break;
        case 45: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 54: break;
        case 32: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); return firstToken;
          }
        case 55: break;
        case 19: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_PAREN); return firstToken;
          }
        case 56: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_CURLY_BRACE); return firstToken;
          }
        case 57: break;
        case 20: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SLASH); return firstToken;
          }
        case 58: break;
        case 46: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+3, Token.COMMENT_DOCUMENTATION);
          }
        case 59: break;
        case 10: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 60: break;
        case 44: 
          { if (start==zzStartRead) { addToken(Token.PREPROCESSOR); addNullToken(); return firstToken; }
          }
        case 61: break;
        case 9: 
          { addToken(Token.FUNCTION);
          }
        case 62: break;
        case 22: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_LT); return firstToken;
          }
        case 63: break;
        case 42: 
          { addToken(Token.VARIABLE);
          }
        case 64: break;
        case 1: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 65: break;
        case 31: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
          }
        case 66: break;
        case 4: 
          { addToken(Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 67: break;
        case 41: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_CURLY_BRACE);
          }
        case 68: break;
        case 50: 
          { start = zzStartRead; yybegin(HEREDOC_EOF_SINGLE_QUOTED);
          }
        case 69: break;
        case 51: 
          { start = zzStartRead; yybegin(HEREDOC_EOT_SINGLE_QUOTED);
          }
        case 70: break;
        case 47: 
          { start = zzStartRead; yybegin(HEREDOC_EOF_UNQUOTED);
          }
        case 71: break;
        case 14: 
          { /* Skip escaped chars. */
          }
        case 72: break;
        case 25: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 73: break;
        case 43: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 74: break;
        case 28: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
          }
        case 75: break;
        case 6: 
          { addToken(Token.WHITESPACE);
          }
        case 76: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_BANG); return firstToken;
          }
        case 77: break;
        case 35: 
          { addToken(Token.PREPROCESSOR);
          }
        case 78: break;
        case 11: 
          { start = zzMarkedPos-1; yybegin(CHAR_LITERAL);
          }
        case 79: break;
        case 3: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 80: break;
        case 38: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_SLASH);
          }
        case 81: break;
        case 27: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_BACKQUOTE);
          }
        case 82: break;
        case 16: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 83: break;
        case 37: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_BANG);
          }
        case 84: break;
        case 23: 
          { /* Skip escaped single quotes only, but this should still work. */
          }
        case 85: break;
        case 30: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
          }
        case 86: break;
        case 49: 
          { start = zzMarkedPos-6; yybegin(DOCCOMMENT);
          }
        case 87: break;
        case 34: 
          { addToken(Token.RESERVED_WORD);
          }
        case 88: break;
        case 26: 
          { addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
          }
        case 89: break;
        case 36: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_SQUARE_BRACKET);
          }
        case 90: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 91: break;
        case 5: 
          { addNullToken(); return firstToken;
          }
        case 92: break;
        case 21: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SQUARE_BRACKET); return firstToken;
          }
        case 93: break;
        case 40: 
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_PAREN);
          }
        case 94: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 95: break;
        case 24: 
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 96: break;
        case 33: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 97: break;
        case 48: 
          { start = zzStartRead; yybegin(HEREDOC_EOT_UNQUOTED);
          }
        case 98: break;
        case 12: 
          { start = zzMarkedPos-1; yybegin(BACKTICKS);
          }
        case 99: break;
        case 13: 
          { 
          }
        case 100: break;
        case 15: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 101: break;
        case 29: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
          }
        case 102: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case HEREDOC_EOF_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
            }
            case 348: break;
            case DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, Token.COMMENT_DOCUMENTATION); return firstToken;
            }
            case 349: break;
            case HEREDOC_EOT_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
            }
            case 350: break;
            case HEREDOC_EOT_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
            }
            case 351: break;
            case STRING_Q_SLASH: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SLASH); return firstToken;
            }
            case 352: break;
            case STRING_Q_BANG: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_BANG); return firstToken;
            }
            case 353: break;
            case STRING_Q_LT: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_LT); return firstToken;
            }
            case 354: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 355: break;
            case BACKTICKS: {
              addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
            }
            case 356: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 357: break;
            case HEREDOC_EOF_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
            }
            case 358: break;
            case STRING_Q_CURLY_BRACE: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_CURLY_BRACE); return firstToken;
            }
            case 359: break;
            case STRING_Q_PAREN: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_PAREN); return firstToken;
            }
            case 360: break;
            case CHAR_LITERAL: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 361: break;
            case STRING_Q_SQUARE_BRACKET: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SQUARE_BRACKET); return firstToken;
            }
            case 362: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
