// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "ShumateFileCache")]
    pub struct FileCache(Object<ffi::ShumateFileCache, ffi::ShumateFileCacheClass>);

    match fn {
        type_ => || ffi::shumate_file_cache_get_type(),
    }
}

impl FileCache {
    #[doc(alias = "shumate_file_cache_new_full")]
    pub fn new_full(size_limit: u32, cache_key: &str, cache_dir: Option<&str>) -> FileCache {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::shumate_file_cache_new_full(
                size_limit,
                cache_key.to_glib_none().0,
                cache_dir.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FileCache`] objects.
    ///
    /// This method returns an instance of [`FileCacheBuilder`](crate::builders::FileCacheBuilder) which can be used to create [`FileCache`] objects.
    pub fn builder() -> FileCacheBuilder {
        FileCacheBuilder::new()
    }

    #[doc(alias = "shumate_file_cache_get_cache_dir")]
    #[doc(alias = "get_cache_dir")]
    pub fn cache_dir(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::shumate_file_cache_get_cache_dir(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_file_cache_get_cache_key")]
    #[doc(alias = "get_cache_key")]
    pub fn cache_key(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::shumate_file_cache_get_cache_key(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_file_cache_get_size_limit")]
    #[doc(alias = "get_size_limit")]
    pub fn size_limit(&self) -> u32 {
        unsafe { ffi::shumate_file_cache_get_size_limit(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_file_cache_get_tile_async")]
    #[doc(alias = "get_tile_async")]
    pub fn tile_async<
        P: FnOnce(
                Result<(glib::Bytes, Option<glib::GString>, Option<glib::DateTime>), glib::Error>,
            ) + 'static,
    >(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn tile_async_trampoline<
            P: FnOnce(
                    Result<
                        (glib::Bytes, Option<glib::GString>, Option<glib::DateTime>),
                        glib::Error,
                    >,
                ) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let mut etag = std::ptr::null_mut();
            let mut modtime = std::ptr::null_mut();
            let ret = ffi::shumate_file_cache_get_tile_finish(
                _source_object as *mut _,
                &mut etag,
                &mut modtime,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((
                    from_glib_full(ret),
                    from_glib_full(etag),
                    from_glib_full(modtime),
                ))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = tile_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_get_tile_async(
                self.to_glib_none().0,
                x,
                y,
                zoom_level,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<
            dyn std::future::Future<
                    Output = Result<
                        (glib::Bytes, Option<glib::GString>, Option<glib::DateTime>),
                        glib::Error,
                    >,
                > + 'static,
        >,
    > {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.tile_async(x, y, zoom_level, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "shumate_file_cache_mark_up_to_date")]
    pub fn mark_up_to_date(&self, x: i32, y: i32, zoom_level: i32) {
        unsafe {
            ffi::shumate_file_cache_mark_up_to_date(self.to_glib_none().0, x, y, zoom_level);
        }
    }

    #[doc(alias = "shumate_file_cache_purge_cache_async")]
    pub fn purge_cache_async<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn purge_cache_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let _ = ffi::shumate_file_cache_purge_cache_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = purge_cache_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_purge_cache_async(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn purge_cache_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.purge_cache_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "shumate_file_cache_set_size_limit")]
    pub fn set_size_limit(&self, size_limit: u32) {
        unsafe {
            ffi::shumate_file_cache_set_size_limit(self.to_glib_none().0, size_limit);
        }
    }

    #[doc(alias = "shumate_file_cache_store_tile_async")]
    pub fn store_tile_async<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn store_tile_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let _ = ffi::shumate_file_cache_store_tile_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = store_tile_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_store_tile_async(
                self.to_glib_none().0,
                x,
                y,
                zoom_level,
                bytes.to_glib_none().0,
                etag.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn store_tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let bytes = bytes.clone();
        let etag = etag.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.store_tile_async(
                x,
                y,
                zoom_level,
                &bytes,
                etag.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "size-limit")]
    pub fn connect_size_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_limit_trampoline<F: Fn(&FileCache) + 'static>(
            this: *mut ffi::ShumateFileCache,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-limit\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_size_limit_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FileCache`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileCacheBuilder {
    builder: glib::object::ObjectBuilder<'static, FileCache>,
}

impl FileCacheBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn cache_dir(self, cache_dir: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("cache-dir", cache_dir.into()),
        }
    }

    pub fn cache_key(self, cache_key: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("cache-key", cache_key.into()),
        }
    }

    pub fn size_limit(self, size_limit: u32) -> Self {
        Self {
            builder: self.builder.property("size-limit", size_limit),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FileCache`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FileCache {
        self.builder.build()
    }
}
