#![allow(dead_code)]

// Test that even when `Self` is only used in contravariant position, it
// is treated as invariant.

// revisions: base nll
// ignore-compare-mode-nll
//[nll] compile-flags: -Z borrowck=mir

trait Get {
    fn get(&self);
}

fn get_min_from_max<'min, 'max, G>()
    where 'max : 'min, G : 'max, &'max G : Get
{
    impls_get::<&'min G>();
    //[base]~^ ERROR mismatched types
    //[nll]~^^ ERROR lifetime may not live long enough
}

fn get_max_from_min<'min, 'max, G>()
    where 'max : 'min, G : 'max, &'min G : Get
{
    // Previously OK, but now error because traits are invariant with
    // respect to all inputs.

    impls_get::<&'max G>();
    //[base]~^ ERROR mismatched types
    //[nll]~^^ ERROR lifetime may not live long enough
}

fn impls_get<G>() where G : Get { }

fn main() { }
