Found possibly newer version of crate `..` which `..` depends on.

Consider these erroneous files:

`a1.rs`
```ignore (needs-linkage-with-other-tests)
#![crate_name = "a"]

pub fn foo<T>() {}
```

`a2.rs`
```ignore (needs-linkage-with-other-tests)
#![crate_name = "a"]

pub fn foo<T>() {
    println!("foo<T>()");
}
```

`b.rs`
```ignore (needs-linkage-with-other-tests)
#![crate_name = "b"]

extern crate a; // linked with `a1.rs`

pub fn foo() {
    a::foo::<isize>();
}
```

`main.rs`
```ignore (needs-linkage-with-other-tests)
extern crate a; // linked with `a2.rs`
extern crate b; // error: found possibly newer version of crate `a` which `b`
                //        depends on

fn main() {}
```

The dependency graph of this program can be represented as follows:
```text
    crate `main`
         |
         +-------------+
         |             |
         |             v
depends: |         crate `b`
 `a` v1  |             |
         |             | depends:
         |             |  `a` v2
         v             |
      crate `a` <------+
```

Crate `main` depends on crate `a` (version 1) and crate `b` which in turn
depends on crate `a` (version 2); this discrepancy in versions cannot be
reconciled. This difference in versions typically occurs when one crate is
compiled and linked, then updated and linked to another crate. The crate
"version" is a SVH (Strict Version Hash) of the crate in an
implementation-specific way. Note that this error can *only* occur when
directly compiling and linking with `rustc`; [Cargo] automatically resolves
dependencies, without using the compiler's own dependency management that
causes this issue.

This error can be fixed by:
 * Using [Cargo], the Rust package manager, automatically fixing this issue.
 * Recompiling crate `a` so that both crate `b` and `main` have a uniform
   version to depend on.

[Cargo]: ../../../cargo/book/index.html
