Couldn't find crate `..` with expected target triple `..`.

Example of erroneous code:

`a.rs`
```ignore (cannot-link-with-other-tests)
#![crate_type = "lib"]

fn foo() {}
```

`main.rs`
```ignore (cannot-link-with-other-tests)
extern crate a;

fn main() {
    a::foo();
}
```

`a.rs` is then compiled with `--target powerpc-unknown-linux-gnu` and `b.rs`
with `--target x86_64-unknown-linux-gnu`. `a.rs` is compiled into a binary
format incompatible with `b.rs`; PowerPC and x86 are totally different
architectures. This issue also extends to any difference in target triples, as
`std` is operating-system specific.

This error can be fixed by:
 * Using [Cargo](../../../cargo/book/index.html), the Rust package manager, automatically
   fixing this issue.
 * Recompiling either crate so that they target a consistent target triple.
