Dependency compiled with different version of `rustc`.

Example of erroneous code:

`a.rs`
```ignore (cannot-link-with-other-tests)
// compiled with stable `rustc`

#[crate_type = "lib"]
```

`b.rs`
```ignore (cannot-link-with-other-tests)
// compiled with nightly `rustc`

#[crate_type = "lib"]

extern crate a; // error: found crate `a` compiled by an incompatible version
                //        of rustc
```

This error is caused when the version of `rustc` used to compile a crate, as
stored in the binary's metadata, differs from the version of one of its
dependencies. Many parts of Rust binaries are considered unstable. For
instance, the Rust ABI is not stable between compiler versions. This means that
the compiler cannot be sure about *how* to call a function between compiler
versions, and therefore this error occurs.

This error can be fixed by:
 * Using [Cargo](../../../cargo/book/index.html), the Rust package manager and
   [Rustup](https://rust-lang.github.io/rustup/), the Rust toolchain installer,
   automatically fixing this issue.
 * Recompiling the crates with a uniform `rustc` version.
