#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[link(name = "windows")]
extern "system" {}
pub const ADVANCED_DUP: u32 = 8192u32;
pub const ADVANCED_DUPLEX: u32 = 1024u32;
pub const ALL_PAGES: u32 = 0u32;
pub const AUTO_ADVANCE: u32 = 512u32;
pub const AUTO_SOURCE: u32 = 32768u32;
pub const BACK_FIRST: u32 = 16u32;
pub const BACK_ONLY: u32 = 64u32;
pub const BARCODE_READER: u32 = 262144u32;
pub const BARCODE_READER_READY: u32 = 16384u32;
pub const BASE_VAL_WIA_ERROR: u32 = 0u32;
pub const BASE_VAL_WIA_SUCCESS: u32 = 0u32;
pub const BOTTOM_JUSTIFIED: u32 = 2u32;
pub const BUS_TYPE_FIREWIRE: u32 = 203u32;
pub const BUS_TYPE_PARALLEL: u32 = 202u32;
pub const BUS_TYPE_SCSI: u32 = 200u32;
pub const BUS_TYPE_USB: u32 = 201u32;
pub const CAPTUREMODE_BURST: u32 = 2u32;
pub const CAPTUREMODE_NORMAL: u32 = 1u32;
pub const CAPTUREMODE_TIMELAPSE: u32 = 3u32;
pub const CENTERED: u32 = 1u32;
pub const CLSID_WiaDefaultSegFilter: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3572814603, data2: 2857, data3: 17672, data4: [137, 34, 12, 87, 151, 212, 39, 101] };
pub const CMD_GETADFAVAILABLE: u32 = 117u32;
pub const CMD_GETADFHASPAPER: u32 = 120u32;
pub const CMD_GETADFOPEN: u32 = 118u32;
pub const CMD_GETADFREADY: u32 = 119u32;
pub const CMD_GETADFSTATUS: u32 = 121u32;
pub const CMD_GETADFUNLOADREADY: u32 = 122u32;
pub const CMD_GETCAPABILITIES: u32 = 132u32;
pub const CMD_GETSUPPORTEDFILEFORMATS: u32 = 138u32;
pub const CMD_GETSUPPORTEDMEMORYFORMATS: u32 = 139u32;
pub const CMD_GETTPAAVAILABLE: u32 = 123u32;
pub const CMD_GETTPAOPENED: u32 = 124u32;
pub const CMD_GET_INTERRUPT_EVENT: u32 = 133u32;
pub const CMD_INITIALIZE: u32 = 100u32;
pub const CMD_LOAD_ADF: u32 = 115u32;
pub const CMD_RESETSCANNER: u32 = 131u32;
pub const CMD_SENDSCSICOMMAND: u32 = 127u32;
pub const CMD_SETCOLORDITHER: u32 = 111u32;
pub const CMD_SETCONTRAST: u32 = 104u32;
pub const CMD_SETDATATYPE: u32 = 106u32;
pub const CMD_SETDITHER: u32 = 107u32;
pub const CMD_SETFILTER: u32 = 114u32;
pub const CMD_SETFORMAT: u32 = 140u32;
pub const CMD_SETGSDNAME: u32 = 134u32;
pub const CMD_SETINTENSITY: u32 = 105u32;
pub const CMD_SETLAMP: u32 = 126u32;
pub const CMD_SETMATRIX: u32 = 112u32;
pub const CMD_SETMIRROR: u32 = 108u32;
pub const CMD_SETNEGATIVE: u32 = 109u32;
pub const CMD_SETSCANMODE: u32 = 135u32;
pub const CMD_SETSPEED: u32 = 113u32;
pub const CMD_SETSTIDEVICEHKEY: u32 = 136u32;
pub const CMD_SETTONEMAP: u32 = 110u32;
pub const CMD_SETXRESOLUTION: u32 = 102u32;
pub const CMD_SETYRESOLUTION: u32 = 103u32;
pub const CMD_STI_DEVICERESET: u32 = 128u32;
pub const CMD_STI_DIAGNOSTIC: u32 = 130u32;
pub const CMD_STI_GETSTATUS: u32 = 129u32;
pub const CMD_TPAREADY: u32 = 125u32;
pub const CMD_UNINITIALIZE: u32 = 101u32;
pub const CMD_UNLOAD_ADF: u32 = 116u32;
pub const COPY_PARENT_PROPERTY_VALUES: u32 = 1073741824u32;
pub const DETECT_DUP: u32 = 64u32;
pub const DETECT_DUP_AVAIL: u32 = 256u32;
pub const DETECT_FEED: u32 = 32u32;
pub const DETECT_FEED_AVAIL: u32 = 128u32;
pub const DETECT_FILM_TPA: u32 = 1024u32;
pub const DETECT_FLAT: u32 = 8u32;
pub const DETECT_SCAN: u32 = 16u32;
pub const DETECT_STOR: u32 = 4096u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEVICEDIALOGDATA {
    pub cbSize: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub pIWiaItemRoot: IWiaItem,
    pub dwFlags: u32,
    pub lIntent: i32,
    pub lItemCount: i32,
    pub ppWiaItems: *mut IWiaItem,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DEVICEDIALOGDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DEVICEDIALOGDATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEVICEDIALOGDATA2 {
    pub cbSize: u32,
    pub pIWiaItemRoot: IWiaItem2,
    pub dwFlags: u32,
    pub hwndParent: super::super::Foundation::HWND,
    pub bstrFolderName: super::super::Foundation::BSTR,
    pub bstrFilename: super::super::Foundation::BSTR,
    pub lNumFiles: i32,
    pub pbstrFilePaths: *mut super::super::Foundation::BSTR,
    pub pWiaItem: IWiaItem2,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DEVICEDIALOGDATA2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DEVICEDIALOGDATA2 {
    fn clone(&self) -> Self {
        *self
    }
}
pub const DEVICE_ATTENTION: u32 = 1024u32;
pub const DUP: u32 = 4u32;
pub const DUPLEX: u32 = 4u32;
pub const DUP_READY: u32 = 4u32;
#[cfg(feature = "Win32_Foundation")]
pub type DeviceDialogFunction = unsafe extern "system" fn(param0: *mut DEVICEDIALOGDATA) -> ::windows_sys::core::HRESULT;
pub const EFFECTMODE_BW: u32 = 2u32;
pub const EFFECTMODE_SEPIA: u32 = 3u32;
pub const EFFECTMODE_STANDARD: u32 = 1u32;
pub const ENDORSER: u32 = 131072u32;
pub const ENDORSER_READY: u32 = 8192u32;
pub const ESC_TWAIN_CAPABILITY: u32 = 2001u32;
pub const ESC_TWAIN_PRIVATE_SUPPORTED_CAPS: u32 = 2002u32;
pub const EXPOSUREMETERING_AVERAGE: u32 = 1u32;
pub const EXPOSUREMETERING_CENTERSPOT: u32 = 4u32;
pub const EXPOSUREMETERING_CENTERWEIGHT: u32 = 2u32;
pub const EXPOSUREMETERING_MULTISPOT: u32 = 3u32;
pub const EXPOSUREMODE_APERTURE_PRIORITY: u32 = 3u32;
pub const EXPOSUREMODE_AUTO: u32 = 2u32;
pub const EXPOSUREMODE_MANUAL: u32 = 1u32;
pub const EXPOSUREMODE_PORTRAIT: u32 = 7u32;
pub const EXPOSUREMODE_PROGRAM_ACTION: u32 = 6u32;
pub const EXPOSUREMODE_PROGRAM_CREATIVE: u32 = 5u32;
pub const EXPOSUREMODE_SHUTTER_PRIORITY: u32 = 4u32;
pub const FEED: u32 = 1u32;
pub const FEEDER: u32 = 1u32;
pub const FEED_READY: u32 = 1u32;
pub const FILM_TPA: u32 = 512u32;
pub const FILM_TPA_READY: u32 = 64u32;
pub const FLASHMODE_AUTO: u32 = 1u32;
pub const FLASHMODE_EXTERNALSYNC: u32 = 6u32;
pub const FLASHMODE_FILL: u32 = 3u32;
pub const FLASHMODE_OFF: u32 = 2u32;
pub const FLASHMODE_REDEYE_AUTO: u32 = 4u32;
pub const FLASHMODE_REDEYE_FILL: u32 = 5u32;
pub const FLAT: u32 = 2u32;
pub const FLATBED: u32 = 2u32;
pub const FLAT_COVER_UP: u32 = 8u32;
pub const FLAT_READY: u32 = 2u32;
pub const FOCUSMETERING_CENTERSPOT: u32 = 1u32;
pub const FOCUSMETERING_MULTISPOT: u32 = 2u32;
pub const FOCUSMODE_AUTO: u32 = 2u32;
pub const FOCUSMODE_MACROAUTO: u32 = 3u32;
pub const FOCUSMODE_MANUAL: u32 = 1u32;
pub const FRONT_FIRST: u32 = 8u32;
pub const FRONT_ONLY: u32 = 32u32;
pub const GUID_DEVINTERFACE_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1809653702, data2: 33039, data3: 4560, data4: [190, 199, 8, 0, 43, 226, 9, 47] };
pub type IEnumWIA_DEV_CAPS = *mut ::core::ffi::c_void;
pub type IEnumWIA_DEV_INFO = *mut ::core::ffi::c_void;
pub type IEnumWIA_FORMAT_INFO = *mut ::core::ffi::c_void;
pub type IEnumWiaItem = *mut ::core::ffi::c_void;
pub type IEnumWiaItem2 = *mut ::core::ffi::c_void;
pub const IMPRINTER: u32 = 65536u32;
pub const IMPRINTER_READY: u32 = 4096u32;
pub const IT_MSG_DATA: u32 = 2u32;
pub const IT_MSG_DATA_HEADER: u32 = 1u32;
pub const IT_MSG_FILE_PREVIEW_DATA: u32 = 6u32;
pub const IT_MSG_FILE_PREVIEW_DATA_HEADER: u32 = 7u32;
pub const IT_MSG_NEW_PAGE: u32 = 5u32;
pub const IT_MSG_STATUS: u32 = 3u32;
pub const IT_MSG_TERMINATION: u32 = 4u32;
pub const IT_STATUS_MASK: u32 = 7u32;
pub const IT_STATUS_PROCESSING_DATA: u32 = 2u32;
pub const IT_STATUS_TRANSFER_FROM_DEVICE: u32 = 1u32;
pub const IT_STATUS_TRANSFER_TO_CLIENT: u32 = 4u32;
pub type IWiaAppErrorHandler = *mut ::core::ffi::c_void;
pub type IWiaDataCallback = *mut ::core::ffi::c_void;
pub type IWiaDataTransfer = *mut ::core::ffi::c_void;
pub type IWiaDevMgr = *mut ::core::ffi::c_void;
pub type IWiaDevMgr2 = *mut ::core::ffi::c_void;
pub type IWiaDrvItem = *mut ::core::ffi::c_void;
pub type IWiaErrorHandler = *mut ::core::ffi::c_void;
pub type IWiaEventCallback = *mut ::core::ffi::c_void;
pub type IWiaImageFilter = *mut ::core::ffi::c_void;
pub type IWiaItem = *mut ::core::ffi::c_void;
pub type IWiaItem2 = *mut ::core::ffi::c_void;
pub type IWiaItemExtras = *mut ::core::ffi::c_void;
pub type IWiaLog = *mut ::core::ffi::c_void;
pub type IWiaLogEx = *mut ::core::ffi::c_void;
pub type IWiaMiniDrv = *mut ::core::ffi::c_void;
pub type IWiaMiniDrvCallBack = *mut ::core::ffi::c_void;
pub type IWiaMiniDrvTransferCallback = *mut ::core::ffi::c_void;
pub type IWiaNotifyDevMgr = *mut ::core::ffi::c_void;
pub type IWiaPreview = *mut ::core::ffi::c_void;
pub type IWiaPropertyStorage = *mut ::core::ffi::c_void;
pub type IWiaSegmentationFilter = *mut ::core::ffi::c_void;
pub type IWiaTransfer = *mut ::core::ffi::c_void;
pub type IWiaTransferCallback = *mut ::core::ffi::c_void;
pub type IWiaUIExtension = *mut ::core::ffi::c_void;
pub type IWiaUIExtension2 = *mut ::core::ffi::c_void;
pub type IWiaVideo = *mut ::core::ffi::c_void;
pub const LAMP_ERR: u32 = 2048u32;
pub const LANDSCAPE: u32 = 1u32;
pub const LANSCAPE: u32 = 1u32;
pub const LEFT_JUSTIFIED: u32 = 0u32;
pub const LIGHT_SOURCE_DETECT_READY: u32 = 4u32;
pub const LIGHT_SOURCE_NEGATIVE: u32 = 4u32;
pub const LIGHT_SOURCE_POSITIVE: u32 = 2u32;
pub const LIGHT_SOURCE_PRESENT: u32 = 2u32;
pub const LIGHT_SOURCE_PRESENT_DETECT: u32 = 1u32;
pub const LIGHT_SOURCE_READY: u32 = 8u32;
pub const LIGHT_SOURCE_SELECT: u32 = 1u32;
pub const MAX_ANSI_CHAR: u32 = 255u32;
pub const MAX_IO_HANDLES: u32 = 16u32;
pub const MAX_RESERVED: u32 = 4u32;
pub const MCRO_ERROR_GENERAL_ERROR: u32 = 0u32;
pub const MCRO_ERROR_OFFLINE: u32 = 5u32;
pub const MCRO_ERROR_PAPER_EMPTY: u32 = 4u32;
pub const MCRO_ERROR_PAPER_JAM: u32 = 2u32;
pub const MCRO_ERROR_PAPER_PROBLEM: u32 = 3u32;
pub const MCRO_ERROR_USER_INTERVENTION: u32 = 6u32;
pub const MCRO_STATUS_OK: u32 = 1u32;
pub const MICR_READER: u32 = 1048576u32;
pub const MICR_READER_READY: u32 = 65536u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MINIDRV_TRANSFER_CONTEXT {
    pub lSize: i32,
    pub lWidthInPixels: i32,
    pub lLines: i32,
    pub lDepth: i32,
    pub lXRes: i32,
    pub lYRes: i32,
    pub lCompression: i32,
    pub guidFormatID: ::windows_sys::core::GUID,
    pub tymed: i32,
    pub hFile: isize,
    pub cbOffset: i32,
    pub lBufferSize: i32,
    pub lActiveBuffer: i32,
    pub lNumBuffers: i32,
    pub pBaseBuffer: *mut u8,
    pub pTransferBuffer: *mut u8,
    pub bTransferDataCB: super::super::Foundation::BOOL,
    pub bClassDrvAllocBuf: super::super::Foundation::BOOL,
    pub lClientAddress: isize,
    pub pIWiaMiniDrvCallBack: IWiaMiniDrvCallBack,
    pub lImageSize: i32,
    pub lHeaderSize: i32,
    pub lItemSize: i32,
    pub cbWidthInBytes: i32,
    pub lPage: i32,
    pub lCurIfdOffset: i32,
    pub lPrevIfdOffset: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for MINIDRV_TRANSFER_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for MINIDRV_TRANSFER_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
pub const MIRRORED: u32 = 1u32;
pub const MULTIPLE_FEED: u32 = 512u32;
pub const NEXT_PAGE: u32 = 128u32;
pub const PAPER_JAM: u32 = 32u32;
pub const PATCH_CODE_READER: u32 = 524288u32;
pub const PATCH_CODE_READER_READY: u32 = 32768u32;
pub const PATH_COVER_UP: u32 = 16u32;
pub const PORTRAIT: u32 = 0u32;
pub const POWERMODE_BATTERY: u32 = 2u32;
pub const POWERMODE_LINE: u32 = 1u32;
pub const PREFEED: u32 = 256u32;
#[repr(C)]
pub struct RANGEVALUE {
    pub lMin: i32,
    pub lMax: i32,
    pub lStep: i32,
}
impl ::core::marker::Copy for RANGEVALUE {}
impl ::core::clone::Clone for RANGEVALUE {
    fn clone(&self) -> Self {
        *self
    }
}
pub const RIGHT_JUSTIFIED: u32 = 2u32;
pub const ROT180: u32 = 2u32;
pub const ROT270: u32 = 3u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct SCANINFO {
    pub ADF: i32,
    pub TPA: i32,
    pub Endorser: i32,
    pub OpticalXResolution: i32,
    pub OpticalYResolution: i32,
    pub BedWidth: i32,
    pub BedHeight: i32,
    pub IntensityRange: RANGEVALUE,
    pub ContrastRange: RANGEVALUE,
    pub SupportedCompressionType: i32,
    pub SupportedDataTypes: i32,
    pub WidthPixels: i32,
    pub WidthBytes: i32,
    pub Lines: i32,
    pub DataType: i32,
    pub PixelBits: i32,
    pub Intensity: i32,
    pub Contrast: i32,
    pub Xresolution: i32,
    pub Yresolution: i32,
    pub Window: SCANWINDOW,
    pub DitherPattern: i32,
    pub Negative: i32,
    pub Mirror: i32,
    pub AutoBack: i32,
    pub ColorDitherPattern: i32,
    pub ToneMap: i32,
    pub Compression: i32,
    pub RawDataFormat: i32,
    pub RawPixelOrder: i32,
    pub bNeedDataAlignment: i32,
    pub DelayBetweenRead: i32,
    pub MaxBufferSize: i32,
    pub DeviceIOHandles: [super::super::Foundation::HANDLE; 16],
    pub lReserved: [i32; 4],
    pub pMicroDriverContext: *mut ::core::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for SCANINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for SCANINFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const SCANMODE_FINALSCAN: u32 = 0u32;
pub const SCANMODE_PREVIEWSCAN: u32 = 1u32;
#[repr(C)]
pub struct SCANWINDOW {
    pub xPos: i32,
    pub yPos: i32,
    pub xExtent: i32,
    pub yExtent: i32,
}
impl ::core::marker::Copy for SCANWINDOW {}
impl ::core::clone::Clone for SCANWINDOW {
    fn clone(&self) -> Self {
        *self
    }
}
pub const SCAN_FINISHED: u32 = 30u32;
pub const SCAN_FIRST: u32 = 10u32;
pub const SCAN_NEXT: u32 = 20u32;
pub const STOR: u32 = 2048u32;
pub const STORAGE_FULL: u32 = 256u32;
pub const STORAGE_READY: u32 = 128u32;
pub const SUPPORT_BW: u32 = 2u32;
pub const SUPPORT_COLOR: u32 = 1u32;
pub const SUPPORT_GRAYSCALE: u32 = 4u32;
pub const TOP_JUSTIFIED: u32 = 0u32;
pub const TRANSPARENCY_DYNAMIC_FRAME_SUPPORT: u32 = 1u32;
pub const TRANSPARENCY_STATIC_FRAME_SUPPORT: u32 = 2u32;
#[repr(C)]
pub struct TWAIN_CAPABILITY {
    pub lSize: i32,
    pub lMSG: i32,
    pub lCapID: i32,
    pub lConType: i32,
    pub lRC: i32,
    pub lCC: i32,
    pub lDataSize: i32,
    pub Data: [u8; 1],
}
impl ::core::marker::Copy for TWAIN_CAPABILITY {}
impl ::core::clone::Clone for TWAIN_CAPABILITY {
    fn clone(&self) -> Self {
        *self
    }
}
pub const TYMED_CALLBACK: u32 = 128u32;
pub const TYMED_MULTIPAGE_CALLBACK: u32 = 512u32;
pub const TYMED_MULTIPAGE_FILE: u32 = 256u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct VAL {
    pub lVal: i32,
    pub dblVal: f64,
    pub pGuid: *mut ::windows_sys::core::GUID,
    pub pScanInfo: *mut SCANINFO,
    pub handle: isize,
    pub ppButtonNames: *mut *mut u16,
    pub pHandle: *mut super::super::Foundation::HANDLE,
    pub lReserved: i32,
    pub szVal: [super::super::Foundation::CHAR; 255],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for VAL {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for VAL {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WHITEBALANCE_AUTO: u32 = 2u32;
pub const WHITEBALANCE_DAYLIGHT: u32 = 4u32;
pub const WHITEBALANCE_FLASH: u32 = 7u32;
pub const WHITEBALANCE_FLORESCENT: u32 = 5u32;
pub const WHITEBALANCE_MANUAL: u32 = 1u32;
pub const WHITEBALANCE_ONEPUSH_AUTO: u32 = 3u32;
pub const WHITEBALANCE_TUNGSTEN: u32 = 6u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIAS_CHANGED_VALUE_INFO {
    pub bChanged: super::super::Foundation::BOOL,
    pub vt: i32,
    pub Old: WIAS_CHANGED_VALUE_INFO_1,
    pub Current: WIAS_CHANGED_VALUE_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIAS_CHANGED_VALUE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIAS_CHANGED_VALUE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WIAS_CHANGED_VALUE_INFO_0 {
    pub lVal: i32,
    pub fltVal: f32,
    pub bstrVal: super::super::Foundation::BSTR,
    pub guidVal: ::windows_sys::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIAS_CHANGED_VALUE_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIAS_CHANGED_VALUE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WIAS_CHANGED_VALUE_INFO_1 {
    pub lVal: i32,
    pub fltVal: f32,
    pub bstrVal: super::super::Foundation::BSTR,
    pub guidVal: ::windows_sys::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIAS_CHANGED_VALUE_INFO_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIAS_CHANGED_VALUE_INFO_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
pub struct WIAS_DOWN_SAMPLE_INFO {
    pub ulOriginalWidth: u32,
    pub ulOriginalHeight: u32,
    pub ulBitsPerPixel: u32,
    pub ulXRes: u32,
    pub ulYRes: u32,
    pub ulDownSampledWidth: u32,
    pub ulDownSampledHeight: u32,
    pub ulActualSize: u32,
    pub ulDestBufSize: u32,
    pub ulSrcBufSize: u32,
    pub pSrcBuffer: *mut u8,
    pub pDestBuffer: *mut u8,
}
impl ::core::marker::Copy for WIAS_DOWN_SAMPLE_INFO {}
impl ::core::clone::Clone for WIAS_DOWN_SAMPLE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIAS_ENDORSER_INFO {
    pub ulPageCount: u32,
    pub ulNumEndorserValues: u32,
    pub pEndorserValues: *mut WIAS_ENDORSER_VALUE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIAS_ENDORSER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIAS_ENDORSER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIAS_ENDORSER_VALUE {
    pub wszTokenName: super::super::Foundation::PWSTR,
    pub wszValue: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIAS_ENDORSER_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIAS_ENDORSER_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
pub type WIAVIDEO_STATE = i32;
pub const WIAVIDEO_NO_VIDEO: WIAVIDEO_STATE = 1i32;
pub const WIAVIDEO_CREATING_VIDEO: WIAVIDEO_STATE = 2i32;
pub const WIAVIDEO_VIDEO_CREATED: WIAVIDEO_STATE = 3i32;
pub const WIAVIDEO_VIDEO_PLAYING: WIAVIDEO_STATE = 4i32;
pub const WIAVIDEO_VIDEO_PAUSED: WIAVIDEO_STATE = 5i32;
pub const WIAVIDEO_DESTROYING_VIDEO: WIAVIDEO_STATE = 6i32;
pub const WIA_ACTION_EVENT: u32 = 2u32;
pub const WIA_ADVANCED_PREVIEW: u32 = 0u32;
pub const WIA_ALARM_BEEP1: u32 = 1u32;
pub const WIA_ALARM_BEEP10: u32 = 10u32;
pub const WIA_ALARM_BEEP2: u32 = 2u32;
pub const WIA_ALARM_BEEP3: u32 = 3u32;
pub const WIA_ALARM_BEEP4: u32 = 4u32;
pub const WIA_ALARM_BEEP5: u32 = 5u32;
pub const WIA_ALARM_BEEP6: u32 = 6u32;
pub const WIA_ALARM_BEEP7: u32 = 7u32;
pub const WIA_ALARM_BEEP8: u32 = 8u32;
pub const WIA_ALARM_BEEP9: u32 = 9u32;
pub const WIA_ALARM_NONE: u32 = 0u32;
pub const WIA_AUTO_CROP_DISABLED: u32 = 0u32;
pub const WIA_AUTO_CROP_MULTI: u32 = 2u32;
pub const WIA_AUTO_CROP_SINGLE: u32 = 1u32;
pub const WIA_AUTO_DESKEW_OFF: u32 = 1u32;
pub const WIA_AUTO_DESKEW_ON: u32 = 0u32;
#[repr(C)]
pub struct WIA_BARCODES {
    pub Tag: u32,
    pub Version: u32,
    pub Size: u32,
    pub Count: u32,
    pub Barcodes: [WIA_BARCODE_INFO; 1],
}
impl ::core::marker::Copy for WIA_BARCODES {}
impl ::core::clone::Clone for WIA_BARCODES {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_BARCODE_AUTO_SEARCH: u32 = 4u32;
pub const WIA_BARCODE_AZTEC: u32 = 36u32;
pub const WIA_BARCODE_CODABAR: u32 = 2u32;
pub const WIA_BARCODE_CODE128: u32 = 9u32;
pub const WIA_BARCODE_CODE128A: u32 = 10u32;
pub const WIA_BARCODE_CODE128B: u32 = 11u32;
pub const WIA_BARCODE_CODE128C: u32 = 12u32;
pub const WIA_BARCODE_CODE39: u32 = 5u32;
pub const WIA_BARCODE_CODE39_FULLASCII: u32 = 7u32;
pub const WIA_BARCODE_CODE39_MOD43: u32 = 6u32;
pub const WIA_BARCODE_CODE93: u32 = 8u32;
pub const WIA_BARCODE_CPCBINARY: u32 = 29u32;
pub const WIA_BARCODE_CUSTOMBASE: u32 = 32768u32;
pub const WIA_BARCODE_DATAMATRIX: u32 = 38u32;
pub const WIA_BARCODE_DATASTRIP: u32 = 39u32;
pub const WIA_BARCODE_EAN13: u32 = 17u32;
pub const WIA_BARCODE_EAN8: u32 = 16u32;
pub const WIA_BARCODE_EZCODE: u32 = 40u32;
pub const WIA_BARCODE_FIM: u32 = 30u32;
pub const WIA_BARCODE_GS1128: u32 = 13u32;
pub const WIA_BARCODE_GS1DATABAR: u32 = 14u32;
pub const WIA_BARCODE_HIGH_CAPACITY_COLOR: u32 = 26u32;
pub const WIA_BARCODE_HORIZONTAL_SEARCH: u32 = 0u32;
pub const WIA_BARCODE_HORIZONTAL_VERTICAL_SEARCH: u32 = 2u32;
#[repr(C)]
pub struct WIA_BARCODE_INFO {
    pub Size: u32,
    pub Type: u32,
    pub Page: u32,
    pub Confidence: u32,
    pub XOffset: u32,
    pub YOffset: u32,
    pub Rotation: u32,
    pub Length: u32,
    pub Text: [u16; 1],
}
impl ::core::marker::Copy for WIA_BARCODE_INFO {}
impl ::core::clone::Clone for WIA_BARCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_BARCODE_INTELLIGENT_MAIL: u32 = 23u32;
pub const WIA_BARCODE_INTERLEAVED_2OF5: u32 = 4u32;
pub const WIA_BARCODE_ITF14: u32 = 15u32;
pub const WIA_BARCODE_JAN: u32 = 34u32;
pub const WIA_BARCODE_MAXICODE: u32 = 27u32;
pub const WIA_BARCODE_MSI: u32 = 33u32;
pub const WIA_BARCODE_NONINTERLEAVED_2OF5: u32 = 3u32;
pub const WIA_BARCODE_PDF417: u32 = 28u32;
pub const WIA_BARCODE_PHARMACODE: u32 = 31u32;
pub const WIA_BARCODE_PLANET: u32 = 22u32;
pub const WIA_BARCODE_PLESSEY: u32 = 32u32;
pub const WIA_BARCODE_POSTBAR: u32 = 24u32;
pub const WIA_BARCODE_POSTNETA: u32 = 18u32;
pub const WIA_BARCODE_POSTNETB: u32 = 19u32;
pub const WIA_BARCODE_POSTNETC: u32 = 20u32;
pub const WIA_BARCODE_POSTNET_DPBC: u32 = 21u32;
pub const WIA_BARCODE_QRCODE: u32 = 41u32;
pub const WIA_BARCODE_READER_AUTO: u32 = 1u32;
pub const WIA_BARCODE_READER_DISABLED: u32 = 0u32;
pub const WIA_BARCODE_READER_FEEDER_BACK: u32 = 4u32;
pub const WIA_BARCODE_READER_FEEDER_DUPLEX: u32 = 5u32;
pub const WIA_BARCODE_READER_FEEDER_FRONT: u32 = 3u32;
pub const WIA_BARCODE_READER_FLATBED: u32 = 2u32;
pub const WIA_BARCODE_RM4SCC: u32 = 25u32;
pub const WIA_BARCODE_SHOTCODE: u32 = 42u32;
pub const WIA_BARCODE_SMALLAZTEC: u32 = 37u32;
pub const WIA_BARCODE_SPARQCODE: u32 = 43u32;
pub const WIA_BARCODE_TELEPEN: u32 = 35u32;
pub const WIA_BARCODE_UPCA: u32 = 0u32;
pub const WIA_BARCODE_UPCE: u32 = 1u32;
pub const WIA_BARCODE_VERTICAL_HORIZONTAL_SEARCH: u32 = 3u32;
pub const WIA_BARCODE_VERTICAL_SEARCH: u32 = 1u32;
pub const WIA_BASIC_PREVIEW: u32 = 1u32;
pub const WIA_BLANK_PAGE_DETECTION_DISABLED: u32 = 0u32;
pub const WIA_BLANK_PAGE_DISCARD: u32 = 1u32;
pub const WIA_BLANK_PAGE_JOB_SEPARATOR: u32 = 2u32;
pub const WIA_CATEGORY_AUTO: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3741212632, data2: 27799, data3: 19934, data4: [177, 30, 203, 80, 155, 39, 14, 17] };
pub const WIA_CATEGORY_BARCODE_READER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 920746144,
    data2: 18239,
    data3: 18763,
    data4: [175, 143, 108, 63, 109, 116, 134, 252],
};
pub const WIA_CATEGORY_ENDORSER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1192242371,
    data2: 4735,
    data3: 18289,
    data4: [173, 252, 153, 26, 184, 238, 30, 151],
};
pub const WIA_CATEGORY_FEEDER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4262664500,
    data2: 63564,
    data3: 17069,
    data4: [141, 164, 97, 41, 205, 221, 114, 136],
};
pub const WIA_CATEGORY_FEEDER_BACK: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1640658132,
    data2: 14811,
    data3: 17066,
    data4: [137, 177, 140, 25, 201, 205, 76, 35],
};
pub const WIA_CATEGORY_FEEDER_FRONT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1210259292,
    data2: 15144,
    data3: 18555,
    data4: [167, 230, 238, 188, 23, 97, 79, 209],
};
pub const WIA_CATEGORY_FILM: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4244003815,
    data2: 15587,
    data3: 17523,
    data4: [175, 133, 245, 211, 125, 33, 182, 138],
};
pub const WIA_CATEGORY_FINISHED_FILE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 4281038794, data2: 53124, data3: 17195, data4: [167, 53, 58, 19, 13, 222, 42, 136] };
pub const WIA_CATEGORY_FLATBED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4217404191,
    data2: 17395,
    data3: 18571,
    data4: [133, 91, 251, 112, 62, 195, 66, 166],
};
pub const WIA_CATEGORY_FOLDER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3331499078,
    data2: 28506,
    data3: 18461,
    data4: [133, 187, 146, 226, 232, 111, 211, 10],
};
pub const WIA_CATEGORY_IMPRINTER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4234477933,
    data2: 37378,
    data3: 17373,
    data4: [145, 167, 100, 194, 149, 76, 251, 139],
};
pub const WIA_CATEGORY_MICR_READER: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 998687212, data2: 29116, data3: 17989, data4: [180, 213, 27, 25, 218, 43, 233, 120] };
pub const WIA_CATEGORY_PATCH_CODE_READER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2410289773,
    data2: 40074,
    data3: 17101,
    data4: [152, 179, 238, 151, 0, 203, 199, 79],
};
pub const WIA_CATEGORY_ROOT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4052963951,
    data2: 22968,
    data3: 18982,
    data4: [152, 136, 225, 110, 79, 151, 206, 16],
};
pub const WIA_CMD_BUILD_DEVICE_TREE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2629459168, data2: 56298, data3: 4562, data4: [132, 22, 0, 192, 79, 163, 97, 69] };
pub const WIA_CMD_CHANGE_DOCUMENT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 82257328, data2: 44206, data3: 4562, data4: [160, 147, 0, 192, 79, 114, 220, 60] };
pub const WIA_CMD_DELETE_ALL_ITEMS: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3792224624, data2: 44205, data3: 4562, data4: [160, 147, 0, 192, 79, 114, 220, 60] };
pub const WIA_CMD_DELETE_DEVICE_TREE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1937856834, data2: 56298, data3: 4562, data4: [132, 22, 0, 192, 79, 163, 97, 69] };
pub const WIA_CMD_DIAGNOSTIC: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 285168373, data2: 56836, data3: 19696, data4: [165, 173, 105, 31, 141, 206, 1, 65] };
pub const WIA_CMD_FORMAT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3282473898,
    data2: 63368,
    data3: 19764,
    data4: [165, 176, 190, 113, 144, 117, 154, 36],
};
pub const WIA_CMD_PAUSE_FEEDER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1352162893,
    data2: 42418,
    data3: 19313,
    data4: [156, 149, 109, 125, 124, 70, 154, 67],
};
pub const WIA_CMD_START_FEEDER: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1520301769, data2: 24365, data3: 19001, data4: [157, 108, 0, 69, 109, 4, 127, 0] };
pub const WIA_CMD_STOP_FEEDER: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3628576877,
    data2: 14597,
    data3: 17820,
    data4: [149, 9, 155, 41, 205, 182, 145, 231],
};
pub const WIA_CMD_SYNCHRONIZE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2603005874, data2: 44205, data3: 4562, data4: [160, 147, 0, 192, 79, 114, 220, 60] };
pub const WIA_CMD_TAKE_PICTURE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2945662124, data2: 44205, data3: 4562, data4: [160, 147, 0, 192, 79, 114, 220, 60] };
pub const WIA_CMD_UNLOAD_DOCUMENT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 523976078, data2: 44206, data3: 4562, data4: [160, 147, 0, 192, 79, 114, 220, 60] };
pub const WIA_COLOR_DROP_BLUE: u32 = 3u32;
pub const WIA_COLOR_DROP_DISABLED: u32 = 0u32;
pub const WIA_COLOR_DROP_GREEN: u32 = 2u32;
pub const WIA_COLOR_DROP_RED: u32 = 1u32;
pub const WIA_COLOR_DROP_RGB: u32 = 4u32;
pub const WIA_COMPRESSION_AUTO: u32 = 100u32;
pub const WIA_COMPRESSION_BI_RLE4: u32 = 1u32;
pub const WIA_COMPRESSION_BI_RLE8: u32 = 2u32;
pub const WIA_COMPRESSION_G3: u32 = 3u32;
pub const WIA_COMPRESSION_G4: u32 = 4u32;
pub const WIA_COMPRESSION_JBIG: u32 = 6u32;
pub const WIA_COMPRESSION_JPEG: u32 = 5u32;
pub const WIA_COMPRESSION_JPEG2K: u32 = 7u32;
pub const WIA_COMPRESSION_NONE: u32 = 0u32;
pub const WIA_COMPRESSION_PNG: u32 = 8u32;
pub const WIA_DATA_AUTO: u32 = 100u32;
#[repr(C)]
pub struct WIA_DATA_CALLBACK_HEADER {
    pub lSize: i32,
    pub guidFormatID: ::windows_sys::core::GUID,
    pub lBufferSize: i32,
    pub lPageCount: i32,
}
impl ::core::marker::Copy for WIA_DATA_CALLBACK_HEADER {}
impl ::core::clone::Clone for WIA_DATA_CALLBACK_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_DATA_COLOR: u32 = 3u32;
pub const WIA_DATA_COLOR_DITHER: u32 = 5u32;
pub const WIA_DATA_COLOR_THRESHOLD: u32 = 4u32;
pub const WIA_DATA_DITHER: u32 = 1u32;
pub const WIA_DATA_GRAYSCALE: u32 = 2u32;
pub const WIA_DATA_RAW_BGR: u32 = 7u32;
pub const WIA_DATA_RAW_CMY: u32 = 10u32;
pub const WIA_DATA_RAW_CMYK: u32 = 11u32;
pub const WIA_DATA_RAW_RGB: u32 = 6u32;
pub const WIA_DATA_RAW_YUV: u32 = 8u32;
pub const WIA_DATA_RAW_YUVK: u32 = 9u32;
pub const WIA_DATA_THRESHOLD: u32 = 0u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_DATA_TRANSFER_INFO {
    pub ulSize: u32,
    pub ulSection: u32,
    pub ulBufferSize: u32,
    pub bDoubleBuffer: super::super::Foundation::BOOL,
    pub ulReserved1: u32,
    pub ulReserved2: u32,
    pub ulReserved3: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_DATA_TRANSFER_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_DATA_TRANSFER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_DEPTH_AUTO: u32 = 0u32;
pub const WIA_DEVICE_COMMANDS: u32 = 1u32;
pub const WIA_DEVICE_CONNECTED: u32 = 1u32;
pub const WIA_DEVICE_DIALOG_SINGLE_IMAGE: u32 = 2u32;
pub const WIA_DEVICE_DIALOG_USE_COMMON_UI: u32 = 4u32;
pub const WIA_DEVICE_EVENTS: u32 = 2u32;
pub const WIA_DEVICE_NOT_CONNECTED: u32 = 0u32;
pub const WIA_DEVINFO_ENUM_ALL: u32 = 15u32;
pub const WIA_DEVINFO_ENUM_LOCAL: u32 = 16u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_DEV_CAP {
    pub guid: ::windows_sys::core::GUID,
    pub ulFlags: u32,
    pub bstrName: super::super::Foundation::BSTR,
    pub bstrDescription: super::super::Foundation::BSTR,
    pub bstrIcon: super::super::Foundation::BSTR,
    pub bstrCommandline: super::super::Foundation::BSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_DEV_CAP {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_DEV_CAP {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_DEV_CAP_DRV {
    pub guid: *mut ::windows_sys::core::GUID,
    pub ulFlags: u32,
    pub wszName: super::super::Foundation::PWSTR,
    pub wszDescription: super::super::Foundation::PWSTR,
    pub wszIcon: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_DEV_CAP_DRV {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_DEV_CAP_DRV {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_DIP_BAUDRATE: u32 = 12u32;
pub const WIA_DIP_DEV_DESC: u32 = 4u32;
pub const WIA_DIP_DEV_ID: u32 = 2u32;
pub const WIA_DIP_DEV_NAME: u32 = 7u32;
pub const WIA_DIP_DEV_TYPE: u32 = 5u32;
pub const WIA_DIP_DRIVER_VERSION: u32 = 15u32;
pub const WIA_DIP_FIRST: u32 = 2u32;
pub const WIA_DIP_HW_CONFIG: u32 = 11u32;
pub const WIA_DIP_PNP_ID: u32 = 16u32;
pub const WIA_DIP_PORT_NAME: u32 = 6u32;
pub const WIA_DIP_REMOTE_DEV_ID: u32 = 9u32;
pub const WIA_DIP_SERVER_NAME: u32 = 8u32;
pub const WIA_DIP_STI_DRIVER_VERSION: u32 = 17u32;
pub const WIA_DIP_STI_GEN_CAPABILITIES: u32 = 13u32;
pub const WIA_DIP_UI_CLSID: u32 = 10u32;
pub const WIA_DIP_VEND_DESC: u32 = 3u32;
pub const WIA_DIP_WIA_VERSION: u32 = 14u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_DITHER_PATTERN_DATA {
    pub lSize: i32,
    pub bstrPatternName: super::super::Foundation::BSTR,
    pub lPatternWidth: i32,
    pub lPatternLength: i32,
    pub cbPattern: i32,
    pub pbPattern: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_DITHER_PATTERN_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_DITHER_PATTERN_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_DONT_SHOW_PREVIEW_CONTROL: u32 = 1u32;
pub const WIA_DONT_USE_SEGMENTATION_FILTER: u32 = 1u32;
pub const WIA_DPA_CONNECT_STATUS: u32 = 1027u32;
pub const WIA_DPA_DEVICE_TIME: u32 = 1028u32;
pub const WIA_DPA_FIRMWARE_VERSION: u32 = 1026u32;
pub const WIA_DPC_ARTIST: u32 = 2091u32;
pub const WIA_DPC_BATTERY_STATUS: u32 = 2065u32;
pub const WIA_DPC_BURST_INTERVAL: u32 = 2075u32;
pub const WIA_DPC_BURST_NUMBER: u32 = 2076u32;
pub const WIA_DPC_CAPTURE_DELAY: u32 = 2082u32;
pub const WIA_DPC_CAPTURE_MODE: u32 = 2081u32;
pub const WIA_DPC_COMPRESSION_SETTING: u32 = 2071u32;
pub const WIA_DPC_CONTRAST: u32 = 2080u32;
pub const WIA_DPC_COPYRIGHT_INFO: u32 = 2092u32;
pub const WIA_DPC_DIGITAL_ZOOM: u32 = 2078u32;
pub const WIA_DPC_DIMENSION: u32 = 2070u32;
pub const WIA_DPC_EFFECT_MODE: u32 = 2077u32;
pub const WIA_DPC_EXPOSURE_COMP: u32 = 2053u32;
pub const WIA_DPC_EXPOSURE_INDEX: u32 = 2083u32;
pub const WIA_DPC_EXPOSURE_METERING_MODE: u32 = 2084u32;
pub const WIA_DPC_EXPOSURE_MODE: u32 = 2052u32;
pub const WIA_DPC_EXPOSURE_TIME: u32 = 2054u32;
pub const WIA_DPC_FLASH_MODE: u32 = 2056u32;
pub const WIA_DPC_FNUMBER: u32 = 2055u32;
pub const WIA_DPC_FOCAL_LENGTH: u32 = 2087u32;
pub const WIA_DPC_FOCUS_DISTANCE: u32 = 2086u32;
pub const WIA_DPC_FOCUS_MANUAL_DIST: u32 = 2058u32;
pub const WIA_DPC_FOCUS_METERING: u32 = 2072u32;
pub const WIA_DPC_FOCUS_METERING_MODE: u32 = 2085u32;
pub const WIA_DPC_FOCUS_MODE: u32 = 2057u32;
pub const WIA_DPC_PAN_POSITION: u32 = 2060u32;
pub const WIA_DPC_PICTURES_REMAINING: u32 = 2051u32;
pub const WIA_DPC_PICTURES_TAKEN: u32 = 2050u32;
pub const WIA_DPC_PICT_HEIGHT: u32 = 2069u32;
pub const WIA_DPC_PICT_WIDTH: u32 = 2068u32;
pub const WIA_DPC_POWER_MODE: u32 = 2064u32;
pub const WIA_DPC_RGB_GAIN: u32 = 2088u32;
pub const WIA_DPC_SHARPNESS: u32 = 2079u32;
pub const WIA_DPC_THUMB_HEIGHT: u32 = 2067u32;
pub const WIA_DPC_THUMB_WIDTH: u32 = 2066u32;
pub const WIA_DPC_TILT_POSITION: u32 = 2061u32;
pub const WIA_DPC_TIMELAPSE_INTERVAL: u32 = 2073u32;
pub const WIA_DPC_TIMELAPSE_NUMBER: u32 = 2074u32;
pub const WIA_DPC_TIMER_MODE: u32 = 2062u32;
pub const WIA_DPC_TIMER_VALUE: u32 = 2063u32;
pub const WIA_DPC_UPLOAD_URL: u32 = 2090u32;
pub const WIA_DPC_WHITE_BALANCE: u32 = 2089u32;
pub const WIA_DPC_ZOOM_POSITION: u32 = 2059u32;
pub const WIA_DPF_FIRST: u32 = 3330u32;
pub const WIA_DPF_MOUNT_POINT: u32 = 3330u32;
pub const WIA_DPS_DEVICE_ID: u32 = 3114u32;
pub const WIA_DPS_DITHER_PATTERN_DATA: u32 = 3085u32;
pub const WIA_DPS_DITHER_SELECT: u32 = 3084u32;
pub const WIA_DPS_DOCUMENT_HANDLING_CAPABILITIES: u32 = 3086u32;
pub const WIA_DPS_DOCUMENT_HANDLING_CAPACITY: u32 = 3089u32;
pub const WIA_DPS_DOCUMENT_HANDLING_SELECT: u32 = 3088u32;
pub const WIA_DPS_DOCUMENT_HANDLING_STATUS: u32 = 3087u32;
pub const WIA_DPS_ENDORSER_CHARACTERS: u32 = 3092u32;
pub const WIA_DPS_ENDORSER_STRING: u32 = 3093u32;
pub const WIA_DPS_FILTER_SELECT: u32 = 3083u32;
pub const WIA_DPS_FIRST: u32 = 3074u32;
pub const WIA_DPS_GLOBAL_IDENTITY: u32 = 3115u32;
pub const WIA_DPS_HORIZONTAL_BED_REGISTRATION: u32 = 3079u32;
pub const WIA_DPS_HORIZONTAL_BED_SIZE: u32 = 3074u32;
pub const WIA_DPS_HORIZONTAL_SHEET_FEED_SIZE: u32 = 3076u32;
pub const WIA_DPS_MAX_SCAN_TIME: u32 = 3095u32;
pub const WIA_DPS_MIN_HORIZONTAL_SHEET_FEED_SIZE: u32 = 3104u32;
pub const WIA_DPS_MIN_VERTICAL_SHEET_FEED_SIZE: u32 = 3105u32;
pub const WIA_DPS_OPTICAL_XRES: u32 = 3090u32;
pub const WIA_DPS_OPTICAL_YRES: u32 = 3091u32;
pub const WIA_DPS_PAD_COLOR: u32 = 3082u32;
pub const WIA_DPS_PAGES: u32 = 3096u32;
pub const WIA_DPS_PAGE_HEIGHT: u32 = 3099u32;
pub const WIA_DPS_PAGE_SIZE: u32 = 3097u32;
pub const WIA_DPS_PAGE_WIDTH: u32 = 3098u32;
pub const WIA_DPS_PLATEN_COLOR: u32 = 3081u32;
pub const WIA_DPS_PREVIEW: u32 = 3100u32;
pub const WIA_DPS_SCAN_AHEAD_PAGES: u32 = 3094u32;
pub const WIA_DPS_SCAN_AVAILABLE_ITEM: u32 = 3116u32;
pub const WIA_DPS_SERVICE_ID: u32 = 3113u32;
pub const WIA_DPS_SHEET_FEEDER_REGISTRATION: u32 = 3078u32;
pub const WIA_DPS_SHOW_PREVIEW_CONTROL: u32 = 3103u32;
pub const WIA_DPS_TRANSPARENCY: u32 = 3101u32;
pub const WIA_DPS_TRANSPARENCY_CAPABILITIES: u32 = 3106u32;
pub const WIA_DPS_TRANSPARENCY_SELECT: u32 = 3102u32;
pub const WIA_DPS_TRANSPARENCY_STATUS: u32 = 3107u32;
pub const WIA_DPS_USER_NAME: u32 = 3112u32;
pub const WIA_DPS_VERTICAL_BED_REGISTRATION: u32 = 3080u32;
pub const WIA_DPS_VERTICAL_BED_SIZE: u32 = 3075u32;
pub const WIA_DPS_VERTICAL_SHEET_FEED_SIZE: u32 = 3077u32;
pub const WIA_DPV_DSHOW_DEVICE_PATH: u32 = 3588u32;
pub const WIA_DPV_IMAGES_DIRECTORY: u32 = 3587u32;
pub const WIA_DPV_LAST_PICTURE_TAKEN: u32 = 3586u32;
pub const WIA_ERROR_BUSY: ::windows_sys::core::HRESULT = -2145320954i32;
pub const WIA_ERROR_COVER_OPEN: ::windows_sys::core::HRESULT = -2145320944i32;
pub const WIA_ERROR_DESTINATION: ::windows_sys::core::HRESULT = -2145320942i32;
pub const WIA_ERROR_DEVICE_COMMUNICATION: ::windows_sys::core::HRESULT = -2145320950i32;
pub const WIA_ERROR_DEVICE_LOCKED: ::windows_sys::core::HRESULT = -2145320947i32;
pub const WIA_ERROR_EXCEPTION_IN_DRIVER: ::windows_sys::core::HRESULT = -2145320946i32;
pub const WIA_ERROR_GENERAL_ERROR: ::windows_sys::core::HRESULT = -2145320959i32;
pub const WIA_ERROR_INCORRECT_HARDWARE_SETTING: ::windows_sys::core::HRESULT = -2145320948i32;
pub const WIA_ERROR_INVALID_COMMAND: ::windows_sys::core::HRESULT = -2145320949i32;
pub const WIA_ERROR_INVALID_DRIVER_RESPONSE: ::windows_sys::core::HRESULT = -2145320945i32;
pub const WIA_ERROR_ITEM_DELETED: ::windows_sys::core::HRESULT = -2145320951i32;
pub const WIA_ERROR_LAMP_OFF: ::windows_sys::core::HRESULT = -2145320943i32;
pub const WIA_ERROR_MAXIMUM_PRINTER_ENDORSER_COUNTER: ::windows_sys::core::HRESULT = -2145320939i32;
pub const WIA_ERROR_MULTI_FEED: ::windows_sys::core::HRESULT = -2145320940i32;
pub const WIA_ERROR_NETWORK_RESERVATION_FAILED: ::windows_sys::core::HRESULT = -2145320941i32;
pub const WIA_ERROR_OFFLINE: ::windows_sys::core::HRESULT = -2145320955i32;
pub const WIA_ERROR_PAPER_EMPTY: ::windows_sys::core::HRESULT = -2145320957i32;
pub const WIA_ERROR_PAPER_JAM: ::windows_sys::core::HRESULT = -2145320958i32;
pub const WIA_ERROR_PAPER_PROBLEM: ::windows_sys::core::HRESULT = -2145320956i32;
pub const WIA_ERROR_USER_INTERVENTION: ::windows_sys::core::HRESULT = -2145320952i32;
pub const WIA_ERROR_WARMING_UP: ::windows_sys::core::HRESULT = -2145320953i32;
pub const WIA_EVENT_CANCEL_IO: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3361798072,
    data2: 40141,
    data3: 16874,
    data4: [187, 191, 77, 208, 156, 91, 23, 149],
};
pub const WIA_EVENT_COVER_CLOSED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1729405414,
    data2: 57989,
    data3: 18060,
    data4: [155, 140, 218, 125, 196, 203, 170, 5],
};
pub const WIA_EVENT_COVER_OPEN: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 429990198, data2: 64028, data3: 20326, data4: [144, 15, 143, 145, 78, 199, 78, 201] };
pub const WIA_EVENT_DEVICE_CONNECTED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2727066334, data2: 25782, data3: 4562, data4: [162, 49, 0, 192, 79, 163, 24, 9] };
pub const WIA_EVENT_DEVICE_DISCONNECTED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 339627651, data2: 25751, data3: 4562, data4: [162, 49, 0, 192, 79, 163, 24, 9] };
pub const WIA_EVENT_DEVICE_NOT_READY: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3633720702,
    data2: 58588,
    data3: 19277,
    data4: [186, 41, 102, 138, 135, 244, 46, 111],
};
pub const WIA_EVENT_DEVICE_READY: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1965288556, data2: 39051, data3: 16798, data4: [154, 10, 66, 90, 195, 27, 55, 220] };
pub const WIA_EVENT_FEEDER_EMPTIED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3876277122,
    data2: 28122,
    data3: 18107,
    data4: [143, 249, 83, 206, 177, 160, 62, 53],
};
pub const WIA_EVENT_FEEDER_LOADED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3431821342,
    data2: 39610,
    data3: 18461,
    data4: [191, 116, 120, 247, 99, 220, 52, 42],
};
pub const WIA_EVENT_FLATBED_LID_CLOSED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 4168724239, data2: 39721, data3: 17027, data4: [173, 149, 212, 18, 22, 77, 57, 169] };
pub const WIA_EVENT_FLATBED_LID_OPEN: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3121219107,
    data2: 17277,
    data3: 20227,
    data4: [169, 125, 119, 147, 177, 35, 17, 60],
};
pub const WIA_EVENT_HANDLER_NO_ACTION: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3761711997,
    data2: 57621,
    data3: 17701,
    data4: [188, 85, 182, 41, 230, 140, 116, 90],
};
pub const WIA_EVENT_HANDLER_PROMPT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1598794448, data2: 19801, data3: 20429, data4: [178, 19, 120, 60, 231, 169, 47, 34] };
pub const WIA_EVENT_ITEM_CREATED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1284460277, data2: 57679, data3: 4562, data4: [179, 38, 0, 192, 79, 104, 206, 97] };
pub const WIA_EVENT_ITEM_DELETED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 488809817, data2: 57679, data3: 4562, data4: [179, 38, 0, 192, 79, 104, 206, 97] };
pub const WIA_EVENT_POWER_RESUME: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1636767038, data2: 63110, data3: 17232, data4: [150, 52, 65, 21, 163, 4, 131, 12] };
pub const WIA_EVENT_POWER_SUSPEND: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2693935097,
    data2: 50100,
    data3: 16668,
    data4: [158, 41, 3, 166, 105, 147, 210, 190],
};
pub const WIA_EVENT_SCAN_EMAIL_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3330727150,
    data2: 21746,
    data3: 16798,
    data4: [154, 39, 47, 199, 242, 233, 143, 158],
};
pub const WIA_EVENT_SCAN_FAX_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3222189971, data2: 35950, data3: 4562, data4: [151, 122, 0, 0, 248, 122, 146, 111] };
pub const WIA_EVENT_SCAN_FILM_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2603312684,
    data2: 24965,
    data3: 17292,
    data4: [182, 139, 227, 158, 226, 94, 113, 203],
};
pub const WIA_EVENT_SCAN_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2797971221, data2: 35950, data3: 4562, data4: [151, 122, 0, 0, 248, 122, 146, 111] };
pub const WIA_EVENT_SCAN_IMAGE2: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4232538049,
    data2: 51379,
    data3: 18594,
    data4: [156, 250, 46, 144, 203, 61, 53, 144],
};
pub const WIA_EVENT_SCAN_IMAGE3: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 357443518,
    data2: 46615,
    data3: 18003,
    data4: [172, 197, 15, 215, 189, 76, 101, 206],
};
pub const WIA_EVENT_SCAN_IMAGE4: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2791010378,
    data2: 32572,
    data3: 17479,
    data4: [167, 93, 138, 38, 223, 202, 31, 223],
};
pub const WIA_EVENT_SCAN_OCR_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2634636169,
    data2: 14294,
    data3: 18551,
    data4: [175, 237, 98, 162, 151, 220, 109, 190],
};
pub const WIA_EVENT_SCAN_PRINT_IMAGE: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3024221221, data2: 35950, data3: 4562, data4: [151, 122, 0, 0, 248, 122, 146, 111] };
pub const WIA_EVENT_STI_PROXY: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3608279071,
    data2: 7949,
    data3: 16941,
    data4: [134, 65, 146, 125, 27, 147, 229, 229],
};
pub const WIA_EVENT_STORAGE_CREATED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 892537010, data2: 65139, data3: 18120, data4: [137, 94, 250, 69, 81, 204, 200, 90] };
pub const WIA_EVENT_STORAGE_DELETED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1581377374,
    data2: 37776,
    data3: 17605,
    data4: [154, 81, 228, 112, 25, 227, 144, 207],
};
pub const WIA_EVENT_TREE_UPDATED: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3380976529,
    data2: 19122,
    data3: 19670,
    data4: [161, 252, 88, 46, 236, 85, 229, 133],
};
pub const WIA_EVENT_VOLUME_INSERT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2520300541, data2: 53693, data3: 4562, data4: [179, 31, 0, 192, 79, 104, 206, 97] };
#[repr(C)]
pub struct WIA_EXTENDED_TRANSFER_INFO {
    pub ulSize: u32,
    pub ulMinBufferSize: u32,
    pub ulOptimalBufferSize: u32,
    pub ulMaxBufferSize: u32,
    pub ulNumBuffers: u32,
}
impl ::core::marker::Copy for WIA_EXTENDED_TRANSFER_INFO {}
impl ::core::clone::Clone for WIA_EXTENDED_TRANSFER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_FEEDER_CONTROL_AUTO: u32 = 0u32;
pub const WIA_FEEDER_CONTROL_MANUAL: u32 = 1u32;
pub const WIA_FILM_BW_NEGATIVE: u32 = 2u32;
pub const WIA_FILM_COLOR_NEGATIVE: u32 = 1u32;
pub const WIA_FILM_COLOR_SLIDE: u32 = 0u32;
pub const WIA_FINAL_SCAN: u32 = 0u32;
pub const WIA_FLAG_NOM: u32 = 0u32;
pub const WIA_FLAG_NUM_ELEMS: u32 = 2u32;
pub const WIA_FLAG_VALUES: u32 = 1u32;
#[repr(C)]
pub struct WIA_FORMAT_INFO {
    pub guidFormatID: ::windows_sys::core::GUID,
    pub lTymed: i32,
}
impl ::core::marker::Copy for WIA_FORMAT_INFO {}
impl ::core::clone::Clone for WIA_FORMAT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_INTENT_BEST_PREVIEW: u32 = 262144u32;
pub const WIA_INTENT_IMAGE_TYPE_COLOR: u32 = 1u32;
pub const WIA_INTENT_IMAGE_TYPE_GRAYSCALE: u32 = 2u32;
pub const WIA_INTENT_IMAGE_TYPE_MASK: u32 = 15u32;
pub const WIA_INTENT_IMAGE_TYPE_TEXT: u32 = 4u32;
pub const WIA_INTENT_MAXIMIZE_QUALITY: u32 = 131072u32;
pub const WIA_INTENT_MINIMIZE_SIZE: u32 = 65536u32;
pub const WIA_INTENT_NONE: u32 = 0u32;
pub const WIA_INTENT_SIZE_MASK: u32 = 983040u32;
pub const WIA_IPA_ACCESS_RIGHTS: u32 = 4102u32;
pub const WIA_IPA_APP_COLOR_MAPPING: u32 = 4121u32;
pub const WIA_IPA_BITS_PER_CHANNEL: u32 = 4110u32;
pub const WIA_IPA_BUFFER_SIZE: u32 = 4118u32;
pub const WIA_IPA_BYTES_PER_LINE: u32 = 4113u32;
pub const WIA_IPA_CHANNELS_PER_PIXEL: u32 = 4109u32;
pub const WIA_IPA_COLOR_PROFILE: u32 = 4117u32;
pub const WIA_IPA_COMPRESSION: u32 = 4107u32;
pub const WIA_IPA_DATATYPE: u32 = 4103u32;
pub const WIA_IPA_DEPTH: u32 = 4104u32;
pub const WIA_IPA_FILENAME_EXTENSION: u32 = 4123u32;
pub const WIA_IPA_FIRST: u32 = 4098u32;
pub const WIA_IPA_FORMAT: u32 = 4106u32;
pub const WIA_IPA_FULL_ITEM_NAME: u32 = 4099u32;
pub const WIA_IPA_GAMMA_CURVES: u32 = 4115u32;
pub const WIA_IPA_ICM_PROFILE_NAME: u32 = 4120u32;
pub const WIA_IPA_ITEMS_STORED: u32 = 4127u32;
pub const WIA_IPA_ITEM_CATEGORY: u32 = 4125u32;
pub const WIA_IPA_ITEM_FLAGS: u32 = 4101u32;
pub const WIA_IPA_ITEM_NAME: u32 = 4098u32;
pub const WIA_IPA_ITEM_SIZE: u32 = 4116u32;
pub const WIA_IPA_ITEM_TIME: u32 = 4100u32;
pub const WIA_IPA_MIN_BUFFER_SIZE: u32 = 4118u32;
pub const WIA_IPA_NUMBER_OF_LINES: u32 = 4114u32;
pub const WIA_IPA_PIXELS_PER_LINE: u32 = 4112u32;
pub const WIA_IPA_PLANAR: u32 = 4111u32;
pub const WIA_IPA_PREFERRED_FORMAT: u32 = 4105u32;
pub const WIA_IPA_PROP_STREAM_COMPAT_ID: u32 = 4122u32;
pub const WIA_IPA_RAW_BITS_PER_CHANNEL: u32 = 4128u32;
pub const WIA_IPA_REGION_TYPE: u32 = 4119u32;
pub const WIA_IPA_SUPPRESS_PROPERTY_PAGE: u32 = 4124u32;
pub const WIA_IPA_TYMED: u32 = 4108u32;
pub const WIA_IPA_UPLOAD_ITEM_SIZE: u32 = 4126u32;
pub const WIA_IPC_AUDIO_AVAILABLE: u32 = 5125u32;
pub const WIA_IPC_AUDIO_DATA: u32 = 5127u32;
pub const WIA_IPC_AUDIO_DATA_FORMAT: u32 = 5126u32;
pub const WIA_IPC_FIRST: u32 = 5122u32;
pub const WIA_IPC_NUM_PICT_PER_ROW: u32 = 5128u32;
pub const WIA_IPC_SEQUENCE: u32 = 5129u32;
pub const WIA_IPC_THUMBNAIL: u32 = 5122u32;
pub const WIA_IPC_THUMB_HEIGHT: u32 = 5124u32;
pub const WIA_IPC_THUMB_WIDTH: u32 = 5123u32;
pub const WIA_IPC_TIMEDELAY: u32 = 5130u32;
pub const WIA_IPS_ALARM: u32 = 4185u32;
pub const WIA_IPS_AUTO_CROP: u32 = 4170u32;
pub const WIA_IPS_AUTO_DESKEW: u32 = 3107u32;
pub const WIA_IPS_BARCODE_READER: u32 = 4150u32;
pub const WIA_IPS_BARCODE_SEARCH_DIRECTION: u32 = 4152u32;
pub const WIA_IPS_BARCODE_SEARCH_TIMEOUT: u32 = 4154u32;
pub const WIA_IPS_BLANK_PAGES: u32 = 4167u32;
pub const WIA_IPS_BLANK_PAGES_SENSITIVITY: u32 = 4192u32;
pub const WIA_IPS_BRIGHTNESS: u32 = 6154u32;
pub const WIA_IPS_COLOR_DROP: u32 = 4176u32;
pub const WIA_IPS_COLOR_DROP_BLUE: u32 = 4179u32;
pub const WIA_IPS_COLOR_DROP_GREEN: u32 = 4178u32;
pub const WIA_IPS_COLOR_DROP_MULTI: u32 = 4191u32;
pub const WIA_IPS_COLOR_DROP_RED: u32 = 4177u32;
pub const WIA_IPS_CONTRAST: u32 = 6155u32;
pub const WIA_IPS_CUR_INTENT: u32 = 6146u32;
pub const WIA_IPS_DESKEW_X: u32 = 6162u32;
pub const WIA_IPS_DESKEW_Y: u32 = 6163u32;
pub const WIA_IPS_DOCUMENT_HANDLING_SELECT: u32 = 3088u32;
pub const WIA_IPS_ENABLED_BARCODE_TYPES: u32 = 4156u32;
pub const WIA_IPS_ENABLED_PATCH_CODE_TYPES: u32 = 4163u32;
pub const WIA_IPS_FEEDER_CONTROL: u32 = 4182u32;
pub const WIA_IPS_FILM_NODE_NAME: u32 = 4129u32;
pub const WIA_IPS_FILM_SCAN_MODE: u32 = 3104u32;
pub const WIA_IPS_FIRST: u32 = 6146u32;
pub const WIA_IPS_INVERT: u32 = 6160u32;
pub const WIA_IPS_JOB_SEPARATORS: u32 = 4165u32;
pub const WIA_IPS_LAMP: u32 = 3105u32;
pub const WIA_IPS_LAMP_AUTO_OFF: u32 = 3106u32;
pub const WIA_IPS_LONG_DOCUMENT: u32 = 4166u32;
pub const WIA_IPS_MAXIMUM_BARCODES_PER_PAGE: u32 = 4151u32;
pub const WIA_IPS_MAXIMUM_BARCODE_SEARCH_RETRIES: u32 = 4153u32;
pub const WIA_IPS_MAX_HORIZONTAL_SIZE: u32 = 6165u32;
pub const WIA_IPS_MAX_VERTICAL_SIZE: u32 = 6166u32;
pub const WIA_IPS_MICR_READER: u32 = 4164u32;
pub const WIA_IPS_MIN_HORIZONTAL_SIZE: u32 = 6167u32;
pub const WIA_IPS_MIN_VERTICAL_SIZE: u32 = 6168u32;
pub const WIA_IPS_MIRROR: u32 = 6158u32;
pub const WIA_IPS_MULTI_FEED: u32 = 4168u32;
pub const WIA_IPS_MULTI_FEED_DETECT_METHOD: u32 = 4193u32;
pub const WIA_IPS_MULTI_FEED_SENSITIVITY: u32 = 4169u32;
pub const WIA_IPS_OPTICAL_XRES: u32 = 3090u32;
pub const WIA_IPS_OPTICAL_YRES: u32 = 3091u32;
pub const WIA_IPS_ORIENTATION: u32 = 6156u32;
pub const WIA_IPS_OVER_SCAN: u32 = 4171u32;
pub const WIA_IPS_OVER_SCAN_BOTTOM: u32 = 4175u32;
pub const WIA_IPS_OVER_SCAN_LEFT: u32 = 4172u32;
pub const WIA_IPS_OVER_SCAN_RIGHT: u32 = 4173u32;
pub const WIA_IPS_OVER_SCAN_TOP: u32 = 4174u32;
pub const WIA_IPS_PAGES: u32 = 3096u32;
pub const WIA_IPS_PAGE_HEIGHT: u32 = 3099u32;
pub const WIA_IPS_PAGE_SIZE: u32 = 3097u32;
pub const WIA_IPS_PAGE_WIDTH: u32 = 3098u32;
pub const WIA_IPS_PATCH_CODE_READER: u32 = 4157u32;
pub const WIA_IPS_PHOTOMETRIC_INTERP: u32 = 6153u32;
pub const WIA_IPS_PREVIEW: u32 = 3100u32;
pub const WIA_IPS_PREVIEW_TYPE: u32 = 3111u32;
pub const WIA_IPS_PRINTER_ENDORSER: u32 = 4130u32;
pub const WIA_IPS_PRINTER_ENDORSER_CHARACTER_ROTATION: u32 = 4187u32;
pub const WIA_IPS_PRINTER_ENDORSER_COUNTER: u32 = 4132u32;
pub const WIA_IPS_PRINTER_ENDORSER_COUNTER_DIGITS: u32 = 4190u32;
pub const WIA_IPS_PRINTER_ENDORSER_FONT_TYPE: u32 = 4184u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS: u32 = 4142u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_DOWNLOAD: u32 = 4149u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_MAX_HEIGHT: u32 = 4147u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_MAX_WIDTH: u32 = 4145u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_MIN_HEIGHT: u32 = 4146u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_MIN_WIDTH: u32 = 4144u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_POSITION: u32 = 4143u32;
pub const WIA_IPS_PRINTER_ENDORSER_GRAPHICS_UPLOAD: u32 = 4148u32;
pub const WIA_IPS_PRINTER_ENDORSER_INK: u32 = 4186u32;
pub const WIA_IPS_PRINTER_ENDORSER_MAX_CHARACTERS: u32 = 4188u32;
pub const WIA_IPS_PRINTER_ENDORSER_MAX_GRAPHICS: u32 = 4189u32;
pub const WIA_IPS_PRINTER_ENDORSER_NUM_LINES: u32 = 4136u32;
pub const WIA_IPS_PRINTER_ENDORSER_ORDER: u32 = 4131u32;
pub const WIA_IPS_PRINTER_ENDORSER_PADDING: u32 = 4183u32;
pub const WIA_IPS_PRINTER_ENDORSER_STEP: u32 = 4133u32;
pub const WIA_IPS_PRINTER_ENDORSER_STRING: u32 = 4137u32;
pub const WIA_IPS_PRINTER_ENDORSER_TEXT_DOWNLOAD: u32 = 4141u32;
pub const WIA_IPS_PRINTER_ENDORSER_TEXT_UPLOAD: u32 = 4140u32;
pub const WIA_IPS_PRINTER_ENDORSER_VALID_CHARACTERS: u32 = 4138u32;
pub const WIA_IPS_PRINTER_ENDORSER_VALID_FORMAT_SPECIFIERS: u32 = 4139u32;
pub const WIA_IPS_PRINTER_ENDORSER_XOFFSET: u32 = 4134u32;
pub const WIA_IPS_PRINTER_ENDORSER_YOFFSET: u32 = 4135u32;
pub const WIA_IPS_ROTATION: u32 = 6157u32;
pub const WIA_IPS_SCAN_AHEAD: u32 = 4180u32;
pub const WIA_IPS_SCAN_AHEAD_CAPACITY: u32 = 4181u32;
pub const WIA_IPS_SEGMENTATION: u32 = 6164u32;
pub const WIA_IPS_SHEET_FEEDER_REGISTRATION: u32 = 3078u32;
pub const WIA_IPS_SHOW_PREVIEW_CONTROL: u32 = 3103u32;
pub const WIA_IPS_SUPPORTED_BARCODE_TYPES: u32 = 4155u32;
pub const WIA_IPS_SUPPORTED_PATCH_CODE_TYPES: u32 = 4162u32;
pub const WIA_IPS_SUPPORTS_CHILD_ITEM_CREATION: u32 = 3108u32;
pub const WIA_IPS_THRESHOLD: u32 = 6159u32;
pub const WIA_IPS_TRANSFER_CAPABILITIES: u32 = 6169u32;
pub const WIA_IPS_WARM_UP_TIME: u32 = 6161u32;
pub const WIA_IPS_XEXTENT: u32 = 6151u32;
pub const WIA_IPS_XPOS: u32 = 6149u32;
pub const WIA_IPS_XRES: u32 = 6147u32;
pub const WIA_IPS_XSCALING: u32 = 3109u32;
pub const WIA_IPS_YEXTENT: u32 = 6152u32;
pub const WIA_IPS_YPOS: u32 = 6150u32;
pub const WIA_IPS_YRES: u32 = 6148u32;
pub const WIA_IPS_YSCALING: u32 = 3110u32;
pub const WIA_IS_DEFAULT_HANDLER: u32 = 1u32;
pub const WIA_ITEM_CAN_BE_DELETED: u32 = 128u32;
pub const WIA_ITEM_READ: u32 = 1u32;
pub const WIA_ITEM_WRITE: u32 = 2u32;
pub const WIA_LAMP_OFF: u32 = 1u32;
pub const WIA_LAMP_ON: u32 = 0u32;
pub const WIA_LINE_ORDER_BOTTOM_TO_TOP: u32 = 2u32;
pub const WIA_LINE_ORDER_TOP_TO_BOTTOM: u32 = 1u32;
pub const WIA_LIST_COUNT: u32 = 0u32;
pub const WIA_LIST_NOM: u32 = 1u32;
pub const WIA_LIST_NUM_ELEMS: u32 = 2u32;
pub const WIA_LIST_VALUES: u32 = 2u32;
pub const WIA_LONG_DOCUMENT_DISABLED: u32 = 0u32;
pub const WIA_LONG_DOCUMENT_ENABLED: u32 = 1u32;
pub const WIA_LONG_DOCUMENT_SPLIT: u32 = 2u32;
pub const WIA_MAJOR_EVENT_DEVICE_CONNECT: u32 = 1u32;
pub const WIA_MAJOR_EVENT_DEVICE_DISCONNECT: u32 = 2u32;
pub const WIA_MAJOR_EVENT_PICTURE_DELETED: u32 = 4u32;
pub const WIA_MAJOR_EVENT_PICTURE_TAKEN: u32 = 3u32;
pub const WIA_MAX_CTX_SIZE: u32 = 16777216u32;
#[repr(C)]
pub struct WIA_MICR {
    pub Tag: u32,
    pub Version: u32,
    pub Size: u32,
    pub Placeholder: u16,
    pub Reserved: u16,
    pub Count: u32,
    pub Micr: [WIA_MICR_INFO; 1],
}
impl ::core::marker::Copy for WIA_MICR {}
impl ::core::clone::Clone for WIA_MICR {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
pub struct WIA_MICR_INFO {
    pub Size: u32,
    pub Page: u32,
    pub Length: u32,
    pub Text: [u16; 1],
}
impl ::core::marker::Copy for WIA_MICR_INFO {}
impl ::core::clone::Clone for WIA_MICR_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_MICR_READER_AUTO: u32 = 1u32;
pub const WIA_MICR_READER_DISABLED: u32 = 0u32;
pub const WIA_MICR_READER_FEEDER_BACK: u32 = 4u32;
pub const WIA_MICR_READER_FEEDER_DUPLEX: u32 = 5u32;
pub const WIA_MICR_READER_FEEDER_FRONT: u32 = 3u32;
pub const WIA_MICR_READER_FLATBED: u32 = 2u32;
pub const WIA_MULTI_FEED_DETECT_CONTINUE: u32 = 3u32;
pub const WIA_MULTI_FEED_DETECT_DISABLED: u32 = 0u32;
pub const WIA_MULTI_FEED_DETECT_METHOD_LENGTH: u32 = 0u32;
pub const WIA_MULTI_FEED_DETECT_METHOD_OVERLAP: u32 = 1u32;
pub const WIA_MULTI_FEED_DETECT_STOP_ERROR: u32 = 1u32;
pub const WIA_MULTI_FEED_DETECT_STOP_SUCCESS: u32 = 2u32;
pub const WIA_NOTIFICATION_EVENT: u32 = 1u32;
pub const WIA_NUM_DIP: u32 = 16u32;
pub const WIA_NUM_IPC: u32 = 9u32;
pub const WIA_ORDER_BGR: u32 = 1u32;
pub const WIA_ORDER_RGB: u32 = 0u32;
pub const WIA_OVER_SCAN_ALL: u32 = 3u32;
pub const WIA_OVER_SCAN_DISABLED: u32 = 0u32;
pub const WIA_OVER_SCAN_LEFT_RIGHT: u32 = 2u32;
pub const WIA_OVER_SCAN_TOP_BOTTOM: u32 = 1u32;
pub const WIA_PACKED_PIXEL: u32 = 0u32;
pub const WIA_PAGE_A4: u32 = 0u32;
pub const WIA_PAGE_AUTO: u32 = 100u32;
pub const WIA_PAGE_BUSINESSCARD: u32 = 6u32;
pub const WIA_PAGE_CUSTOM: u32 = 2u32;
pub const WIA_PAGE_CUSTOM_BASE: u32 = 32768u32;
pub const WIA_PAGE_DIN_2B: u32 = 52u32;
pub const WIA_PAGE_DIN_4B: u32 = 53u32;
pub const WIA_PAGE_ISO_A0: u32 = 7u32;
pub const WIA_PAGE_ISO_A1: u32 = 8u32;
pub const WIA_PAGE_ISO_A10: u32 = 16u32;
pub const WIA_PAGE_ISO_A2: u32 = 9u32;
pub const WIA_PAGE_ISO_A3: u32 = 10u32;
pub const WIA_PAGE_ISO_A4: u32 = 0u32;
pub const WIA_PAGE_ISO_A5: u32 = 11u32;
pub const WIA_PAGE_ISO_A6: u32 = 12u32;
pub const WIA_PAGE_ISO_A7: u32 = 13u32;
pub const WIA_PAGE_ISO_A8: u32 = 14u32;
pub const WIA_PAGE_ISO_A9: u32 = 15u32;
pub const WIA_PAGE_ISO_B0: u32 = 17u32;
pub const WIA_PAGE_ISO_B1: u32 = 18u32;
pub const WIA_PAGE_ISO_B10: u32 = 27u32;
pub const WIA_PAGE_ISO_B2: u32 = 19u32;
pub const WIA_PAGE_ISO_B3: u32 = 20u32;
pub const WIA_PAGE_ISO_B4: u32 = 21u32;
pub const WIA_PAGE_ISO_B5: u32 = 22u32;
pub const WIA_PAGE_ISO_B6: u32 = 23u32;
pub const WIA_PAGE_ISO_B7: u32 = 24u32;
pub const WIA_PAGE_ISO_B8: u32 = 25u32;
pub const WIA_PAGE_ISO_B9: u32 = 26u32;
pub const WIA_PAGE_ISO_C0: u32 = 28u32;
pub const WIA_PAGE_ISO_C1: u32 = 29u32;
pub const WIA_PAGE_ISO_C10: u32 = 38u32;
pub const WIA_PAGE_ISO_C2: u32 = 30u32;
pub const WIA_PAGE_ISO_C3: u32 = 31u32;
pub const WIA_PAGE_ISO_C4: u32 = 32u32;
pub const WIA_PAGE_ISO_C5: u32 = 33u32;
pub const WIA_PAGE_ISO_C6: u32 = 34u32;
pub const WIA_PAGE_ISO_C7: u32 = 35u32;
pub const WIA_PAGE_ISO_C8: u32 = 36u32;
pub const WIA_PAGE_ISO_C9: u32 = 37u32;
pub const WIA_PAGE_JIS_2A: u32 = 50u32;
pub const WIA_PAGE_JIS_4A: u32 = 51u32;
pub const WIA_PAGE_JIS_B0: u32 = 39u32;
pub const WIA_PAGE_JIS_B1: u32 = 40u32;
pub const WIA_PAGE_JIS_B10: u32 = 49u32;
pub const WIA_PAGE_JIS_B2: u32 = 41u32;
pub const WIA_PAGE_JIS_B3: u32 = 42u32;
pub const WIA_PAGE_JIS_B4: u32 = 43u32;
pub const WIA_PAGE_JIS_B5: u32 = 44u32;
pub const WIA_PAGE_JIS_B6: u32 = 45u32;
pub const WIA_PAGE_JIS_B7: u32 = 46u32;
pub const WIA_PAGE_JIS_B8: u32 = 47u32;
pub const WIA_PAGE_JIS_B9: u32 = 48u32;
pub const WIA_PAGE_LETTER: u32 = 1u32;
pub const WIA_PAGE_USLEDGER: u32 = 4u32;
pub const WIA_PAGE_USLEGAL: u32 = 3u32;
pub const WIA_PAGE_USLETTER: u32 = 1u32;
pub const WIA_PAGE_USSTATEMENT: u32 = 5u32;
#[repr(C)]
pub struct WIA_PATCH_CODES {
    pub Tag: u32,
    pub Version: u32,
    pub Size: u32,
    pub Count: u32,
    pub PatchCodes: [WIA_PATCH_CODE_INFO; 1],
}
impl ::core::marker::Copy for WIA_PATCH_CODES {}
impl ::core::clone::Clone for WIA_PATCH_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_PATCH_CODE_1: u32 = 1u32;
pub const WIA_PATCH_CODE_10: u32 = 10u32;
pub const WIA_PATCH_CODE_11: u32 = 11u32;
pub const WIA_PATCH_CODE_12: u32 = 12u32;
pub const WIA_PATCH_CODE_13: u32 = 13u32;
pub const WIA_PATCH_CODE_14: u32 = 14u32;
pub const WIA_PATCH_CODE_2: u32 = 2u32;
pub const WIA_PATCH_CODE_3: u32 = 3u32;
pub const WIA_PATCH_CODE_4: u32 = 4u32;
pub const WIA_PATCH_CODE_6: u32 = 6u32;
pub const WIA_PATCH_CODE_7: u32 = 7u32;
pub const WIA_PATCH_CODE_8: u32 = 8u32;
pub const WIA_PATCH_CODE_9: u32 = 9u32;
pub const WIA_PATCH_CODE_CUSTOM_BASE: u32 = 32768u32;
#[repr(C)]
pub struct WIA_PATCH_CODE_INFO {
    pub Type: u32,
}
impl ::core::marker::Copy for WIA_PATCH_CODE_INFO {}
impl ::core::clone::Clone for WIA_PATCH_CODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_PATCH_CODE_READER_AUTO: u32 = 1u32;
pub const WIA_PATCH_CODE_READER_DISABLED: u32 = 0u32;
pub const WIA_PATCH_CODE_READER_FEEDER_BACK: u32 = 4u32;
pub const WIA_PATCH_CODE_READER_FEEDER_DUPLEX: u32 = 5u32;
pub const WIA_PATCH_CODE_READER_FEEDER_FRONT: u32 = 3u32;
pub const WIA_PATCH_CODE_READER_FLATBED: u32 = 2u32;
pub const WIA_PATCH_CODE_T: u32 = 5u32;
pub const WIA_PATCH_CODE_UNKNOWN: u32 = 0u32;
pub const WIA_PHOTO_WHITE_0: u32 = 1u32;
pub const WIA_PHOTO_WHITE_1: u32 = 0u32;
pub const WIA_PLANAR: u32 = 1u32;
pub const WIA_PREVIEW_SCAN: u32 = 1u32;
pub const WIA_PRINTER_ENDORSER_AFTER_SCAN: u32 = 1u32;
pub const WIA_PRINTER_ENDORSER_AUTO: u32 = 1u32;
pub const WIA_PRINTER_ENDORSER_BEFORE_SCAN: u32 = 0u32;
pub const WIA_PRINTER_ENDORSER_DIGITAL: u32 = 6u32;
pub const WIA_PRINTER_ENDORSER_DISABLED: u32 = 0u32;
pub const WIA_PRINTER_ENDORSER_FEEDER_BACK: u32 = 4u32;
pub const WIA_PRINTER_ENDORSER_FEEDER_DUPLEX: u32 = 5u32;
pub const WIA_PRINTER_ENDORSER_FEEDER_FRONT: u32 = 3u32;
pub const WIA_PRINTER_ENDORSER_FLATBED: u32 = 2u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_BACKGROUND: u32 = 8u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_BOTTOM: u32 = 3u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_BOTTOM_LEFT: u32 = 6u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_BOTTOM_RIGHT: u32 = 7u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_DEVICE_DEFAULT: u32 = 9u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_LEFT: u32 = 0u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_RIGHT: u32 = 1u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_TOP: u32 = 2u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_TOP_LEFT: u32 = 4u32;
pub const WIA_PRINTER_ENDORSER_GRAPHICS_TOP_RIGHT: u32 = 5u32;
pub const WIA_PRINT_AM_PM: u32 = 9u32;
pub const WIA_PRINT_DATE: u32 = 0u32;
pub const WIA_PRINT_DAY: u32 = 3u32;
pub const WIA_PRINT_FONT_BOLD: u32 = 1u32;
pub const WIA_PRINT_FONT_EXTRA_BOLD: u32 = 2u32;
pub const WIA_PRINT_FONT_ITALIC: u32 = 5u32;
pub const WIA_PRINT_FONT_ITALIC_BOLD: u32 = 3u32;
pub const WIA_PRINT_FONT_ITALIC_EXTRA_BOLD: u32 = 4u32;
pub const WIA_PRINT_FONT_LARGE: u32 = 12u32;
pub const WIA_PRINT_FONT_LARGE_BOLD: u32 = 13u32;
pub const WIA_PRINT_FONT_LARGE_EXTRA_BOLD: u32 = 14u32;
pub const WIA_PRINT_FONT_LARGE_ITALIC: u32 = 17u32;
pub const WIA_PRINT_FONT_LARGE_ITALIC_BOLD: u32 = 15u32;
pub const WIA_PRINT_FONT_LARGE_ITALIC_EXTRA_BOLD: u32 = 16u32;
pub const WIA_PRINT_FONT_NORMAL: u32 = 0u32;
pub const WIA_PRINT_FONT_SMALL: u32 = 6u32;
pub const WIA_PRINT_FONT_SMALL_BOLD: u32 = 7u32;
pub const WIA_PRINT_FONT_SMALL_EXTRA_BOLD: u32 = 8u32;
pub const WIA_PRINT_FONT_SMALL_ITALIC: u32 = 11u32;
pub const WIA_PRINT_FONT_SMALL_ITALIC_BOLD: u32 = 9u32;
pub const WIA_PRINT_FONT_SMALL_ITALIC_EXTRA_BOLD: u32 = 10u32;
pub const WIA_PRINT_HOUR_12H: u32 = 8u32;
pub const WIA_PRINT_HOUR_24H: u32 = 7u32;
pub const WIA_PRINT_IMAGE: u32 = 13u32;
pub const WIA_PRINT_MILLISECOND: u32 = 14u32;
pub const WIA_PRINT_MINUTE: u32 = 10u32;
pub const WIA_PRINT_MONTH: u32 = 2u32;
pub const WIA_PRINT_MONTH_NAME: u32 = 15u32;
pub const WIA_PRINT_MONTH_SHORT: u32 = 16u32;
pub const WIA_PRINT_PADDING_BLANK: u32 = 2u32;
pub const WIA_PRINT_PADDING_NONE: u32 = 0u32;
pub const WIA_PRINT_PADDING_ZERO: u32 = 1u32;
pub const WIA_PRINT_PAGE_COUNT: u32 = 12u32;
pub const WIA_PRINT_SECOND: u32 = 11u32;
pub const WIA_PRINT_TIME_12H: u32 = 6u32;
pub const WIA_PRINT_TIME_24H: u32 = 5u32;
pub const WIA_PRINT_WEEK_DAY: u32 = 4u32;
pub const WIA_PRINT_WEEK_DAY_SHORT: u32 = 17u32;
pub const WIA_PRINT_YEAR: u32 = 1u32;
pub const WIA_PRIVATE_DEVPROP: u32 = 38914u32;
pub const WIA_PRIVATE_ITEMPROP: u32 = 71682u32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_CONTEXT {
    pub cProps: u32,
    pub pProps: *mut u32,
    pub pChanged: *mut super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO {
    pub lAccessFlags: u32,
    pub vt: u16,
    pub ValidVal: WIA_PROPERTY_INFO_0,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union WIA_PROPERTY_INFO_0 {
    pub Range: WIA_PROPERTY_INFO_0_7,
    pub RangeFloat: WIA_PROPERTY_INFO_0_6,
    pub List: WIA_PROPERTY_INFO_0_4,
    pub ListFloat: WIA_PROPERTY_INFO_0_2,
    pub ListGuid: WIA_PROPERTY_INFO_0_3,
    pub ListBStr: WIA_PROPERTY_INFO_0_1,
    pub Flag: WIA_PROPERTY_INFO_0_0,
    pub None: WIA_PROPERTY_INFO_0_5,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_0 {
    pub Nom: i32,
    pub ValidBits: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_1 {
    pub cNumList: i32,
    pub Nom: super::super::Foundation::BSTR,
    pub pList: *mut super::super::Foundation::BSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_2 {
    pub cNumList: i32,
    pub Nom: f64,
    pub pList: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_3 {
    pub cNumList: i32,
    pub Nom: ::windows_sys::core::GUID,
    pub pList: *mut ::windows_sys::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_3 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_3 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_4 {
    pub cNumList: i32,
    pub Nom: i32,
    pub pList: *mut u8,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_4 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_4 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_5 {
    pub Dummy: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_5 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_5 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_6 {
    pub Min: f64,
    pub Nom: f64,
    pub Max: f64,
    pub Inc: f64,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_6 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_6 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPERTY_INFO_0_7 {
    pub Min: i32,
    pub Nom: i32,
    pub Max: i32,
    pub Inc: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPERTY_INFO_0_7 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPERTY_INFO_0_7 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WIA_PROPID_TO_NAME {
    pub propid: u32,
    pub pszName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WIA_PROPID_TO_NAME {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WIA_PROPID_TO_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_PROPPAGE_CAMERA_ITEM_GENERAL: u32 = 2u32;
pub const WIA_PROPPAGE_DEVICE_GENERAL: u32 = 4u32;
pub const WIA_PROPPAGE_SCANNER_ITEM_GENERAL: u32 = 1u32;
pub const WIA_PROP_CACHEABLE: u32 = 65536u32;
pub const WIA_PROP_FLAG: u32 = 64u32;
pub const WIA_PROP_LIST: u32 = 32u32;
pub const WIA_PROP_NONE: u32 = 8u32;
pub const WIA_PROP_RANGE: u32 = 16u32;
pub const WIA_PROP_READ: u32 = 1u32;
pub const WIA_PROP_SYNC_REQUIRED: u32 = 4u32;
pub const WIA_PROP_WRITE: u32 = 2u32;
pub const WIA_RANGE_MAX: u32 = 2u32;
pub const WIA_RANGE_MIN: u32 = 0u32;
pub const WIA_RANGE_NOM: u32 = 1u32;
pub const WIA_RANGE_NUM_ELEMS: u32 = 4u32;
pub const WIA_RANGE_STEP: u32 = 3u32;
#[repr(C)]
pub struct WIA_RAW_HEADER {
    pub Tag: u32,
    pub Version: u32,
    pub HeaderSize: u32,
    pub XRes: u32,
    pub YRes: u32,
    pub XExtent: u32,
    pub YExtent: u32,
    pub BytesPerLine: u32,
    pub BitsPerPixel: u32,
    pub ChannelsPerPixel: u32,
    pub DataType: u32,
    pub BitsPerChannel: [u8; 8],
    pub Compression: u32,
    pub PhotometricInterp: u32,
    pub LineOrder: u32,
    pub RawDataOffset: u32,
    pub RawDataSize: u32,
    pub PaletteOffset: u32,
    pub PaletteSize: u32,
}
impl ::core::marker::Copy for WIA_RAW_HEADER {}
impl ::core::clone::Clone for WIA_RAW_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WIA_REGISTER_EVENT_CALLBACK: u32 = 1u32;
pub const WIA_RESERVED_FOR_NEW_PROPS: u32 = 1024u32;
pub const WIA_SCAN_AHEAD_ALL: u32 = 0u32;
pub const WIA_SCAN_AHEAD_DISABLED: u32 = 0u32;
pub const WIA_SCAN_AHEAD_ENABLED: u32 = 1u32;
pub const WIA_SELECT_DEVICE_NODEFAULT: u32 = 1u32;
pub const WIA_SEPARATOR_DETECT_NOSCAN_CONTINUE: u32 = 3u32;
pub const WIA_SEPARATOR_DETECT_NOSCAN_STOP: u32 = 4u32;
pub const WIA_SEPARATOR_DETECT_SCAN_CONTINUE: u32 = 1u32;
pub const WIA_SEPARATOR_DETECT_SCAN_STOP: u32 = 2u32;
pub const WIA_SEPARATOR_DISABLED: u32 = 0u32;
pub const WIA_SET_DEFAULT_HANDLER: u32 = 4u32;
pub const WIA_SHOW_PREVIEW_CONTROL: u32 = 0u32;
pub const WIA_STATUS_CALIBRATING: ::windows_sys::core::HRESULT = 2162691i32;
pub const WIA_STATUS_CLEAR: ::windows_sys::core::HRESULT = 2162696i32;
pub const WIA_STATUS_END_OF_MEDIA: ::windows_sys::core::HRESULT = 2162689i32;
pub const WIA_STATUS_NETWORK_DEVICE_RESERVED: ::windows_sys::core::HRESULT = 2162695i32;
pub const WIA_STATUS_NOT_HANDLED: ::windows_sys::core::HRESULT = 2162698i32;
pub const WIA_STATUS_RESERVING_NETWORK_DEVICE: ::windows_sys::core::HRESULT = 2162694i32;
pub const WIA_STATUS_SKIP_ITEM: ::windows_sys::core::HRESULT = 2162697i32;
pub const WIA_STATUS_WARMING_UP: ::windows_sys::core::HRESULT = 2162690i32;
pub const WIA_S_CHANGE_DEVICE: ::windows_sys::core::HRESULT = 2162699i32;
pub const WIA_S_NO_DEVICE_AVAILABLE: ::windows_sys::core::HRESULT = -2145320939i32;
pub const WIA_TRANSFER_ACQUIRE_CHILDREN: u32 = 1u32;
pub const WIA_TRANSFER_CHILDREN_SINGLE_SCAN: u32 = 1u32;
pub const WIA_TRANSFER_MSG_DEVICE_STATUS: u32 = 5u32;
pub const WIA_TRANSFER_MSG_END_OF_STREAM: u32 = 2u32;
pub const WIA_TRANSFER_MSG_END_OF_TRANSFER: u32 = 3u32;
pub const WIA_TRANSFER_MSG_NEW_PAGE: u32 = 6u32;
pub const WIA_TRANSFER_MSG_STATUS: u32 = 1u32;
pub const WIA_UNREGISTER_EVENT_CALLBACK: u32 = 2u32;
pub const WIA_USE_SEGMENTATION_FILTER: u32 = 0u32;
pub const WIA_WSD_FRIENDLY_NAME: u32 = 38920u32;
pub const WIA_WSD_MANUFACTURER: u32 = 38914u32;
pub const WIA_WSD_MANUFACTURER_URL: u32 = 38915u32;
pub const WIA_WSD_MODEL_NAME: u32 = 38916u32;
pub const WIA_WSD_MODEL_NUMBER: u32 = 38917u32;
pub const WIA_WSD_MODEL_URL: u32 = 38918u32;
pub const WIA_WSD_PRESENTATION_URL: u32 = 38919u32;
pub const WIA_WSD_SCAN_AVAILABLE_ITEM: u32 = 38922u32;
pub const WIA_WSD_SERIAL_NUMBER: u32 = 38921u32;
pub const WiaAudFmt_AIFF: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1726136143,
    data2: 46844,
    data3: 17471,
    data4: [148, 200, 47, 51, 200, 166, 90, 175],
};
pub const WiaAudFmt_MP3: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 264008187,
    data2: 17343,
    data3: 18930,
    data4: [145, 144, 230, 254, 207, 243, 126, 84],
};
pub const WiaAudFmt_WAV: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 4162380102, data2: 1967, data3: 16639, data4: [174, 85, 190, 143, 44, 6, 93, 190] };
pub const WiaAudFmt_WMA: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3592250387,
    data2: 35778,
    data3: 17295,
    data4: [147, 173, 33, 189, 72, 77, 182, 161],
};
pub const WiaDevMgr: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2717181734, data2: 36081, data3: 4561, data4: [191, 146, 0, 96, 8, 30, 216, 17] };
pub const WiaDevMgr2: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3066204860,
    data2: 31880,
    data3: 16878,
    data4: [139, 84, 142, 201, 38, 23, 229, 153],
};
pub const WiaImgFmt_ASF: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2375323369,
    data2: 53418,
    data3: 18962,
    data4: [157, 154, 156, 197, 222, 54, 25, 155],
};
pub const WiaImgFmt_AVI: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 855165460,
    data2: 2172,
    data3: 18696,
    data4: [183, 196, 103, 87, 254, 126, 144, 171],
};
pub const WiaImgFmt_BMP: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812843, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_CIFF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2552342699, data2: 14974, data3: 16917, data4: [148, 224, 210, 122, 70, 12, 3, 178] };
pub const WiaImgFmt_CSV: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 895212068,
    data2: 23199,
    data3: 17556,
    data4: [128, 220, 190, 117, 44, 236, 188, 140],
};
pub const WiaImgFmt_DPOF: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 916385451,
    data2: 41192,
    data3: 17866,
    data4: [134, 166, 168, 60, 229, 105, 126, 40],
};
pub const WiaImgFmt_EMF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812844, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_EXEC: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1214095511, data2: 5150, data3: 19109, data4: [187, 59, 165, 97, 141, 149, 208, 43] };
pub const WiaImgFmt_EXIF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812850, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_FLASHPIX: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812852, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_GIF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812848, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_HTML: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3382333026,
    data2: 39390,
    data3: 19092,
    data4: [172, 202, 113, 149, 106, 194, 151, 125],
};
pub const WiaImgFmt_ICO: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812853, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_JBIG: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1105780114, data2: 12042, data3: 17364, data4: [134, 54, 241, 97, 75, 161, 30, 70] };
pub const WiaImgFmt_JBIG2: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3146677863,
    data2: 10300,
    data3: 16949,
    data4: [158, 89, 11, 155, 249, 76, 166, 135],
};
pub const WiaImgFmt_JPEG: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812846, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_JPEG2K: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 877585074, data2: 14811, data3: 19934, data4: [129, 115, 196, 183, 95, 143, 30, 73] };
pub const WiaImgFmt_JPEG2KX: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1138837012, data2: 51210, data3: 18512, data4: [186, 243, 75, 21, 45, 200, 218, 39] };
pub const WiaImgFmt_MEMORYBMP: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812842, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_MPG: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3973535716,
    data2: 53996,
    data3: 20311,
    data4: [149, 93, 188, 248, 169, 124, 78, 82],
};
pub const WiaImgFmt_OXPS: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 746263104, data2: 49485, data3: 16649, data4: [151, 85, 4, 184, 144, 37, 21, 58] };
pub const WiaImgFmt_PDFA: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2575351131,
    data2: 13411,
    data3: 17351,
    data4: [189, 202, 60, 170, 20, 111, 34, 159],
};
pub const WiaImgFmt_PHOTOCD: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812851, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_PICT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2797372888,
    data2: 27454,
    data3: 16622,
    data4: [169, 92, 37, 212, 130, 228, 26, 220],
};
pub const WiaImgFmt_PNG: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812847, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_RAW: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1863452441,
    data2: 61864,
    data3: 19975,
    data4: [154, 222, 155, 100, 198, 58, 61, 204],
};
pub const WiaImgFmt_RAWBAR: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3663984691, data2: 53870, data3: 17694, data4: [144, 210, 234, 85, 161, 54, 93, 98] };
pub const WiaImgFmt_RAWMIC: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 583331928, data2: 3464, data3: 16540, data4: [172, 28, 238, 193, 43, 14, 166, 128] };
pub const WiaImgFmt_RAWPAT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 2002800764, data2: 20580, data3: 16396, data4: [154, 23, 87, 86, 36, 216, 130, 75] };
pub const WiaImgFmt_RAWRGB: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3164900181, data2: 62066, data3: 17265, data4: [176, 241, 74, 21, 13, 5, 123, 180] };
pub const WiaImgFmt_RTF: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1463670435,
    data2: 18484,
    data3: 17197,
    data4: [169, 181, 225, 152, 221, 158, 137, 13],
};
pub const WiaImgFmt_SCRIPT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4269632595,
    data2: 11692,
    data3: 17514,
    data4: [176, 189, 215, 62, 33, 233, 36, 201],
};
pub const WiaImgFmt_TIFF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812849, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_TXT: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 4210904450, data2: 29247, data3: 16927, data4: [147, 24, 48, 80, 26, 196, 75, 89] };
pub const WiaImgFmt_UNDEFINED: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812841, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_UNICODE16: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 460732854, data2: 25431, data3: 18385, data4: [154, 7, 18, 69, 45, 192, 115, 233] };
pub const WiaImgFmt_WMF: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 3110812845, data2: 1832, data3: 4563, data4: [157, 123, 0, 0, 248, 30, 243, 46] };
pub const WiaImgFmt_XML: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 3105297495,
    data2: 56008,
    data3: 18564,
    data4: [179, 147, 21, 180, 113, 213, 240, 126],
};
pub const WiaImgFmt_XMLBAR: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 1647669276,
    data2: 15000,
    data3: 18508,
    data4: [178, 168, 253, 255, 216, 126, 107, 22],
};
pub const WiaImgFmt_XMLMIC: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 756436065, data2: 47534, data3: 19235, data4: [137, 115, 199, 6, 126, 31, 189, 49] };
pub const WiaImgFmt_XMLPAT: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 4170739541,
    data2: 61522,
    data3: 17933,
    data4: [149, 35, 58, 125, 254, 219, 179, 60],
};
pub const WiaImgFmt_XPS: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 1879788047, data2: 8209, data3: 16668, data4: [180, 48, 209, 224, 178, 225, 11, 40] };
pub const WiaItemTypeAnalyze: u32 = 16u32;
pub const WiaItemTypeAudio: u32 = 32u32;
pub const WiaItemTypeBurst: u32 = 2048u32;
pub const WiaItemTypeDeleted: u32 = 128u32;
pub const WiaItemTypeDevice: u32 = 64u32;
pub const WiaItemTypeDisconnected: u32 = 256u32;
pub const WiaItemTypeDocument: u32 = 262144u32;
pub const WiaItemTypeFile: u32 = 2u32;
pub const WiaItemTypeFolder: u32 = 4u32;
pub const WiaItemTypeFree: u32 = 0u32;
pub const WiaItemTypeGenerated: u32 = 16384u32;
pub const WiaItemTypeHPanorama: u32 = 512u32;
pub const WiaItemTypeHasAttachments: u32 = 32768u32;
pub const WiaItemTypeImage: u32 = 1u32;
pub const WiaItemTypeMask: u32 = 2148532223u32;
pub const WiaItemTypeProgrammableDataSource: u32 = 524288u32;
pub const WiaItemTypeRemoved: u32 = 2147483648u32;
pub const WiaItemTypeRoot: u32 = 8u32;
pub const WiaItemTypeStorage: u32 = 4096u32;
pub const WiaItemTypeTransfer: u32 = 8192u32;
pub const WiaItemTypeTwainCapabilityPassThrough: u32 = 131072u32;
pub const WiaItemTypeVPanorama: u32 = 1024u32;
pub const WiaItemTypeVideo: u32 = 65536u32;
pub const WiaLog: ::windows_sys::core::GUID = ::windows_sys::core::GUID {
    data1: 2716291927,
    data2: 34842,
    data3: 16798,
    data4: [131, 226, 187, 22, 219, 25, 124, 104],
};
#[repr(C)]
pub struct WiaTransferParams {
    pub lMessage: i32,
    pub lPercentComplete: i32,
    pub ulTransferredBytes: u64,
    pub hrErrorStatus: ::windows_sys::core::HRESULT,
}
impl ::core::marker::Copy for WiaTransferParams {}
impl ::core::clone::Clone for WiaTransferParams {
    fn clone(&self) -> Self {
        *self
    }
}
pub const WiaVideo: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 956875725, data2: 17528, data3: 17718, data4: [175, 47, 16, 194, 93, 78, 248, 154] };
