/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDriversRoot.cxx
    \author Romain BONDUE
    \date 21/02/2006 */
#include "RTDriversRoot.h"
#include "RTSuWProtocolCodes.h"



nsWireless::CRT2400DriverRoot::CRT2400DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2400Driver (DeviceName), CSuWProtocol (RT2400Handler, DeviceName) {}


nsWireless::CRT2500DriverRoot::CRT2500DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2500Driver (DeviceName), CSuWProtocol (RT2500Handler, DeviceName) {}


nsWireless::CRT2570DriverRoot::CRT2570DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2570Driver (DeviceName), CSuWProtocol (RT2570Handler, DeviceName) {}


nsWireless::CRT61DriverRoot::CRT61DriverRoot (const std::string& DeviceName)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRT61Driver (DeviceName), CSuWProtocol (RT61Handler, DeviceName) {}


nsWireless::CRT73DriverRoot::CRT73DriverRoot (const std::string& DeviceName)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRT73Driver (DeviceName), CSuWProtocol (RT73Handler, DeviceName) {}


void nsWireless::CRT2500DriverRoot::SetWirelessMode (WirelessMode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (Mode, WModeC);
    SetFlag (IsB_Only, Mode == B_Only);

} // SetWirelessMode()


void nsWireless::CRT2500DriverRoot::SetTxBurst (bool TxBurstStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxBurstStatus, TxBurstC);
    SetFlag (TxBurst, TxBurstStatus);

} // SetTxBurst()


void nsWireless::CRT2500DriverRoot::SetBGProtection
                    (BGProtection_e BGProtection) throw (nsErrors::CSystemExc)
{
    SuDo (BGProtection, BGProtectionC);
    SetBGProtectionFlag (BGProtection);

} // SetBGProtection()


void nsWireless::CRT2500DriverRoot::SetTxPreamble (TxPreamble_e TxPreamble)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxPreamble, TxPreambleC);
    SetTxPreambleFlag (TxPreamble);

} // SetTxPreamble()


void nsWireless::CRT2500DriverRoot::SetTurboRate (bool TurboRateState)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TurboRateState, TurboRateC);
    SetFlag (TurboRate, TurboRateState);

} // SetTurboRate()


void nsWireless::CRT2500DriverRoot::SetAdHocOFDM (bool AdHocOFDMStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (AdHocOFDMStatus, AdHocOFDMC);
    SetFlag (AdHocOFDM, AdHocOFDMStatus);

} // SetAdHocOFDM()


void nsWireless::CRT2500DriverRoot::SetRfmontx (bool RfmonTxStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (RfmonTxStatus, RfmontxC);
    SetFlag (Rfmontx, RfmonTxStatus);

} // SetRfmontx()


void nsWireless::CRT61DriverRoot::SetWirelessMode (WirelessMode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (Mode, WModeC);
    SetFlag (IsB_Only, Mode == B_Only);

} // SetWirelessMode()


void nsWireless::CRT61DriverRoot::SetTxBurst (bool TxBurstStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxBurstStatus, TxBurstC);
    SetFlag (TxBurst, TxBurstStatus);

} // SetTxBurst()


void nsWireless::CRT61DriverRoot::SetBGProtection (BGProtection_e BGProtection)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (BGProtection, BGProtectionC);
    SetBGProtectionFlag (BGProtection);

} // SetBGProtection()


void nsWireless::CRT61DriverRoot::SetTxPreamble (TxPreamble_e TxPreamble)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxPreamble, TxPreambleC);
    SetTxPreambleFlag (TxPreamble);

} // SetTxPreamble()


void nsWireless::CRT61DriverRoot::SetTurboRate (bool TurboRateState)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TurboRateState, TurboRateC);
    SetFlag (TurboRate, TurboRateState);

} // SetTurboRate()


void nsWireless::CRT61DriverRoot::SetAdHocOFDM (bool AdHocOFDMState)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (AdHocOFDMState, AdHocOFDMC);
    SetFlag (AdHocOFDM, AdHocOFDMState);

} // SetAdHocOFDM()


void nsWireless::CRT61DriverRoot::SetRfmontx (bool RfmonTxStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (RfmonTxStatus, RfmontxC);
    SetFlag (Rfmontx, RfmonTxStatus);

} // SetRfmontx()


void nsWireless::CRT73DriverRoot::SetWirelessMode (WirelessMode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (Mode, WModeC);
    SetFlag (IsB_Only, Mode == B_Only);

} // SetWirelessMode()


void nsWireless::CRT73DriverRoot::SetTxBurst (bool TxBurstStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxBurstStatus, TxBurstC);
    SetFlag (TxBurst, TxBurstStatus);

} // SetTxBurst()


void nsWireless::CRT73DriverRoot::SetBGProtection (BGProtection_e BGProtection)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (BGProtection, BGProtectionC);
    SetBGProtectionFlag (BGProtection);

} // SetBGProtection()


void nsWireless::CRT73DriverRoot::SetTxPreamble (TxPreamble_e TxPreamble)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TxPreamble, TxPreambleC);
    SetTxPreambleFlag (TxPreamble);

} // SetTxPreamble()


void nsWireless::CRT73DriverRoot::SetTurboRate (bool TurboRateState)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (TurboRateState, TurboRateC);
    SetFlag (TurboRate, TurboRateState);

} // SetTurboRate()


void nsWireless::CRT73DriverRoot::SetAdHocOFDM (bool AdHocOFDMState)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (AdHocOFDMState, AdHocOFDMC);
    SetFlag (AdHocOFDM, AdHocOFDMState);

} // SetAdHocOFDM()


void nsWireless::CRT73DriverRoot::SetRfmontx (bool RfmonTxStatus)
                                                    throw (nsErrors::CSystemExc)
{
    SuDo (RfmonTxStatus, RfmontxC);
    SetFlag (Rfmontx, RfmonTxStatus);

} // SetRfmontx()
