/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * ShapeTools/shape program - strbuf.c
 *
 * by Steve Emerson (steve@unidata.ucar.edu)
 *
 * $Header: strbuf.h[8.0] Tue Mar  2 15:02:03 1993 shape@cs.tu-berlin.de frozen $
 */

#ifndef	STRING_BUFFER_HEADER_INCLUDED
#define	STRING_BUFFER_HEADER_INCLUDED

/*
 * String-buffer data-type.
 */
typedef struct str_buf	*sb_ptr;

/*
 * String-buffer interface:
 */

/* Instantiate a string-buffer.  Returns NULL on failure.  The specified,
 * initial, maximum string length doesn't count the terminating NUL. */
extern sb_ptr	sbnew	A((int max));

/* Initialize an existing string-buffer. */
extern sb_ptr	sbinit	A((sb_ptr sb, char *string, int len));

/* Free a string-buffer. */
extern void	sbfree	A((sb_ptr sb));

/* Copy a string to a string-buffer.  The string buffer will expand as
 * necessary to accomodate the input string.  On failure, it will return
 * NULL. */
extern sb_ptr	sbcpy	A((sb_ptr sb, char *string, int len));

/* Append a string to a string-buffer.  The string-buffer will expand as
 * necessary to accomodate the catenated string.  The function returns NULL
 * on failure. */
extern sb_ptr	sbcat	A((sb_ptr sb, char *string, int len));

/* Return a pointer to a string-buffer's string.  The string is guaranteed
 * to be NUL terminated. */
extern char	*sbstr	A((sb_ptr sb));

/* Return the length of a string-buffer's string.  Excludes the terminating
 * NUL. */
extern int	sblen	A((sb_ptr sb));

#endif	/* !STRING_BUFFER_HEADER_INCLUDED */
