/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>

#include "codeeditor.h"
#include "fcvsfo.h"
#include "shx_helper.h"
#include "window.h"
#include "dsrgui.h"
#include "deprecation.h"
#include "partcolor.h"
#include <QClipboard>

CodeEditor::CodeEditor(QWidget *parent) : QPlainTextEdit(parent), c(0){
  lineNumberArea = new LineNumberArea(this);
  lineNumberArea->setObjectName("lineNumberArea");
  lineNumberArea->setMouseTracking(true);
  afixHighlightArea = new AfixHighlightArea(this);
  afixHighlightArea->setObjectName("afixHighlightArea");
  afixHighlightArea->setMouseTracking(true);
  startMouseMoveCursor1=false;
  setMouseTracking(true);
  m_cursorVisible = false;
  midCursorpos=0;
  dark=false;
  QString theIconPath;
  if (!QString(PROGRAM_NAME).compare("shelXle")){
      theIconPath=QString(":/xle-icons/");
  }else{
      theIconPath=QString(":/bicons/");
  }
  //setTabChangesFocus(true);
  highlighter = new Highlighter(document());
//  updateLineNumberAreaWidth(0);
  //highlightCurrentLine();

  updateAfix();

    suchbox =  new QGroupBox("Search and Replace",this);
    searchLE = new QLineEdit(suchbox);
    searchLE->setMinimumSize(QSize(150, 0));
    suchbox->setFlat(true);
    slt=new QGridLayout(suchbox);
    hidesearch = new QToolButton(suchbox);
    hidesearch->setIcon(QIcon(theIconPath+"cancel.svg"));
    hidesearch->setAutoRaise(true);
    prev = new QToolButton(suchbox);
    prev->setIcon(QIcon(theIconPath+"moveleft.svg"));
    prev->setText("Previous");
    prev->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    prev->setAutoRaise(true);
    next = new QToolButton(suchbox);
    next->setIcon(QIcon(theIconPath+"moveright.svg"));
    next->setText("Next");
    next->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    next->setAutoRaise(true);
    wholeLine = new QCheckBox("Select whole lines",suchbox);
    wholeLine->setChecked(false);

    slt->setSpacing(5);
    //slt->setMargin(0);
    slt->addWidget(hidesearch,0,0);
    slt->addWidget(searchLE,0,1);
    slt->addWidget(prev,0,2);
    slt->addWidget(next,0,3);
    slt->setVerticalSpacing (0);
    slt->addWidget(wholeLine,0,4);
   // slt->setColumnStretch(6,10);
    replace = new QLineEdit(suchbox);
    replace->setMinimumSize(QSize(150, 0));

    replaceButton = new QToolButton(suchbox);
    replaceButton->setIcon(QIcon(theIconPath+"moveright.svg"));
    replaceButton->setText("Replace");
    replaceButton->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    replaceButton->setAutoRaise(true);

    replacePButton = new QToolButton(suchbox);
    replacePButton->setIcon(QIcon(theIconPath+"moveleft.svg"));
    replacePButton->setText("Replace");
    replacePButton->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    replacePButton->setAutoRaise(true);
    replaceAButton= new QToolButton(suchbox);
    //ediVis=oupVis=false;
    replaceAButton->setIcon(QIcon(theIconPath+"all.svg"));
//

    replaceAButton->setText("Replace All!");
    replaceAButton->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    replaceAButton->setAutoRaise(true);
    slt->addWidget(replace,1,1);
    slt->addWidget(replacePButton,1,2);
    slt->addWidget(replaceButton,1,3);
    slt->addWidget(replaceAButton,1,4);
    suchbox->setLayout(slt);
    suchbox->hide();
    connect(searchLE, SIGNAL(textChanged(const QString&)),this,SLOT(findText()));
    connect(searchLE, SIGNAL(textChanged(const QString&)),highlighter,SLOT(highlightSearch(const QString &)));
    connect(next, SIGNAL(clicked() ), this, SLOT(findNext()));
    connect(prev, SIGNAL(clicked() ), this, SLOT(findPrev()));
    connect(searchLE, SIGNAL(returnPressed()), this, SLOT(findNext()));
    connect(replaceButton, SIGNAL(clicked() ), this, SLOT(replaceNext()));
    connect(replacePButton, SIGNAL(clicked() ), this, SLOT(replacePrev()));
    connect(replaceAButton, SIGNAL(clicked() ), this, SLOT(replaceAll()));
    connect(hidesearch, SIGNAL(clicked() ), this, SLOT(hideSearch()));

  //
    resiFinder = new QComboBox();
    resiFinder->setSizeAdjustPolicy(QComboBox::AdjustToContents);
    connect(resiFinder, SIGNAL(activated(int)), this, SLOT(findResi(int)));
    connect(resiFinder, SIGNAL(destroyed(QObject*)), this, SLOT(resiFinderDestroyed()));
    //m_cursors = MultiTextCursor(textCursor());
    connect(this, SIGNAL(cursorPositionChanged()),this, SLOT(slotCursorPositionChanged()));
    connect(this, SIGNAL(cursorPositionChanged()),this, SLOT(updateCursorPosition()));


    connect(this, SIGNAL(blockCountChanged(int)), this, SLOT(updateLineNumberAreaWidth(int)));
    connect(this, SIGNAL(updateRequest(QRect,int)), this, SLOT(updateLineNumberArea(QRect,int)));
    connect(this, SIGNAL(textChanged()),this,SLOT(updateAfix()));
    connect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(testCpd()));

}

CodeEditor::~CodeEditor(){
  //printf("CodeEditor will close%d\n",__LINE__);
  disconnect(this);
  //printf("ce%d\n",__LINE__);
  delete lineNumberArea;
  //printf("ce%d\n",__LINE__);
  delete afixHighlightArea;
  //printf("ce%d\n",__LINE__);
  delete highlighter;
  //printf("CodeEditor closed. %d %p\n",__LINE__,chgl);

}

int CodeEditor::lineNumberAreaWidth(){
  int digits = 4;//2;
  //int max = qMax(1, blockCount());
  //while (max >= 10) {
  //  max /= 10;
  //  ++digits;
  //}
#if (QT_VERSION>=0x050000)
  int space = 5 + fontMetrics().horizontalAdvance(QLatin1Char('9')) * digits;
#else
  int space = 5 + fontMetrics().width(QLatin1Char('9')) * digits;
#endif
  return space;
}

void CodeEditor::updateLineNumberAreaWidth(int /* newBlockCount */){ 
    setViewportMargins(lineNumberAreaWidth()+15, 0, 0, 0);
}

void CodeEditor::updateLineNumberArea(const QRect &rect, int dy){
  Q_UNUSED ( rect );
//  printf("updateLineNumberArea\n");
    if (dy){
        lineNumberArea->scroll(0, dy);
        afixHighlightArea->scroll(0,dy);
    }
   /*
    else{
      printf("Area->update1 %d %d\n",rect.x(),rect.y());
    //lineNumberArea->update(0, rect.y(), lineNumberArea->width(), rect.height());
      printf("Area->update2\n");
    //afixHighlightArea->update(0,rect.y(),10,rect.height());
      printf("Area->update3\n");
}*/
  if (rect.contains(viewport()->rect()))
    updateLineNumberAreaWidth(0);
    //*/
}

void CodeEditor::restoreMinimumWidth(){
    setMinimumWidth(150);
    //bool b=disconnect(SIGNAL(timeout()),this,SLOT(restoreMinimumWidth()));
    //printf("restoreMinimumWidth() %d\n",b);
}

void CodeEditor::fitWidth(){
    //we do not want horizontal scrollbars
#if (QT_VERSION>=0x050000)
    int w=75+
    fontMetrics().horizontalAdvance(
                "12345678901234567890123456789012345678901234567890123456789012345678901234567890123"
//               0        10        20        30        40        50        60        70        80        90
                );
				
#else
	int w=75+
    fontMetrics().width(
                "12345678901234567890123456789012345678901234567890123456789012345678901234567890123"
//               0        10        20        30        40        50        60        70        80        90
                );
#endif
    //printf("fitWidth %d\n",w);
    setMinimumWidth(w);
    update();
    // the timer is to allow the user make the editor wiget smaller but with scrollbars
    QTimer *sish =new QTimer(this);
    connect(sish,SIGNAL(timeout()),this,SLOT(restoreMinimumWidth()));
    sish->setSingleShot(true);
    sish->start(5000);
}

void CodeEditor::resizeEvent(QResizeEvent *e){
  QPlainTextEdit::resizeEvent(e);
  QRect cr = contentsRect();
  /*printf("CodeEditor::resizeEvent %d %d (%s) %d %d %d\n",cr.width(),cr.height(),this->objectName().toStdString().c_str(),
         e->size().width(),e->size().height(),
         fontMetrics().horizontalAdvance("123456789012345678901234567890123456789012345678901234567890123456789012345678901234")
         );*/
  lineNumberArea->setGeometry(QRect(cr.left(), cr.top(), lineNumberAreaWidth(), cr.height()));
  afixHighlightArea->setGeometry(QRect(
      cr.left()+lineNumberAreaWidth()+1,
      cr.top(),
      10,cr.height()
      ));
  e->accept();
}

void CodeEditor::expandGreaterThan(){//!< some SHELXL re- or constrainst use > to specify a range of atoms this is a problem for sorting atoms
    QTextDocument *document = this->document();
//    printf("expandGreaterThan\n");
    for (int i=0; i<blocks.size(); i++){
        if (blocks.at(i).startsWith("REM",Qt::CaseInsensitive)) continue;
        if (blocks.at(i).contains('>')){
            int comRN=-1,comPart=9999;
            QString comRL="";
            QString orig=blocks.at(i);
            QStringList tokens=orig.split(spaces);
            int da=tokens.indexOf(">");
            QRegularExpression toReplace = QRegularExpression(QString("%1\\s+>\\s+%2").arg(tokens.at(da-1),tokens.at(da+1)));
            QString with="";
            if (tokens.at(0).contains("_")){
                QString spec = tokens.at(0).section('_',1,1);
                if (spec.contains(onlydigits)) comRN=spec.toInt();
                else if (spec.contains(grossbuch)) comRL=spec;
                else if (spec.contains(onlysmall)) comPart=spec.toInt(0,36)-9;
            }
            bool on=false;
            //printf("%d %d \n",comRN,comPart);
            for (int j=0; j< chgl->mol->asymm.size(); j++){
                if (chgl->mol->asymm.at(j).an<1)continue;
                QString s=chgl->mol->asymm.at(j).Label.section(QString::fromUtf8("_"),0,0);
                if ((comRN>0)&&(chgl->mol->asymm.at(j).resiNr!=comRN))continue;
                if ((comPart!=9999)&&((chgl->mol->asymm.at(j).part!=comPart)||(chgl->mol->asymm.at(j).part!=(25-comPart)))) continue;
                if ((!comRL.isEmpty())&&(chgl->mol->asymm.at(j).ResiClass!=comRL))continue;
                if (s==tokens.at(da-1)) on=true;
                if (on) if (!with.contains(s+" ")){
                    with.append(QString("%1 ").arg(s));
                    if (with.section('=',-1,-1).length()>60) with.append(" = \n ");
                }
                if (s==tokens.at(da+1)) on=false;
            }
            //DSRGui::textWrap(buffer)
            //qDebug()<<orig<<toReplace.pattern()<<with;
            QTextCursor cursor = textCursor();
            cursor.movePosition(QTextCursor::Start);
            cursor = document->find(orig,cursor);
            cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
            cursor =document->find(toReplace);
            cursor.insertText(with);
        }
        if (blocks.at(i).contains('<')){
            int comRN=-1,comPart=9999;
            QString comRL="";
            QString orig=blocks.at(i);
            QStringList tokens=orig.split(spaces);
            int da=tokens.indexOf("<");
            QRegularExpression toReplace=QRegularExpression(QString("%1\\s+<\\s+%2").arg(tokens.at(da-1), tokens.at(da+1)));
            QString with="";
            if (tokens.at(0).contains("_")){
                QString spec = tokens.at(0).section('_',1,1);
                if (spec.contains(onlydigits)) comRN=spec.toInt();
                else if (spec.contains(grossbuch)) comRL=spec;
                else if (spec.contains(onlysmall)) comPart=spec.toInt(0,36)-9;
            }
            bool on=false;
            for (int j=chgl->mol->asymm.size()-1; j>=0; j--){
                if (chgl->mol->asymm.at(j).an<1)continue;
                QString s=chgl->mol->asymm.at(j).Label.section(QString::fromUtf8("_"),0,0);
                if ((comRN>0)&&(chgl->mol->asymm.at(j).resiNr!=comRN))continue;
                if ((comPart!=9999)&&((chgl->mol->asymm.at(j).part!=comPart)||(chgl->mol->asymm.at(j).part!=(25-comPart)))) continue;
                if ((!comRL.isEmpty())&&(chgl->mol->asymm.at(j).ResiClass!=comRL))continue;
                if (s==tokens.at(da-1)) on=true;
                if (on) if (!with.contains(s+" ")) {
                    with.append(QString("%1 ").arg(s));
                    if (with.section('=',-1,-1).length()>60) with.append(" = \n ");
                }
                if (s==tokens.at(da+1)) on=false;
            }
            //DSRGui::textWrap(buffer)
            //qDebug()<<orig<<toReplace.pattern()<<with;
            QTextCursor cursor = textCursor();
            cursor.movePosition(QTextCursor::Start);
            cursor = document->find(orig,cursor);
            cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
            cursor =document->find(toReplace);
            cursor.insertText(with);
        }
    }
}

QString CodeEditor::selectedRestraintsAtoms(QString buffer, QList<MyAtom> selected, QString resiSpec, bool exclude_H){
  //! Assembles the selected atom names to parameters for the specific restraint.
  for (QList<MyAtom>::iterator atom = selected.begin(); atom != selected.end(); atom++) {
    if((atom->an==0) && (exclude_H)) {//Hydrogen have an == 0 !
      // excludes hydrogen atoms
      continue;
    }
    if (atom->an < 0) {//non atoms have an < 0 
      // excludes q-peaks, even if exclude_H is false
      continue;
    }
    // Do not add atoms outside of the asymmetric unit to the restraints:
    if (atom->symmGroup!=0) {
      continue;
    }
    if ((resiSpec.isEmpty()) && (atom->resiNr > 0)) {//I think 'and' is confusing and I prefere &&
      buffer += (atom->Label.section("_", 0, 0) + QString("_%1").arg(atom->resiNr) + " ");
    } else {
      buffer += (atom->Label.section("_", 0, 0) + " ");
    }
  }
  return buffer + "\n";
}

void CodeEditor::updateWght(){
  if (chgl->mol->asymm.isEmpty()) return;
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.beginEditBlock ();
  cursor.movePosition(QTextCursor::End);
  cursor = document->find("WGHT",cursor,QTextDocument::FindBackward);
  if (cursor.isNull()) {
    cursor = textCursor();
    cursor.endEditBlock ();
    return;
  } 
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
  QString newWeight= cursor.selectedText();
  cursor.clearSelection();

  cursor.movePosition(QTextCursor::Up);

  cursor = document->find("WGHT",cursor,QTextDocument::FindBackward);

  cursor.movePosition(QTextCursor::StartOfLine);
  cursor.clearSelection();
  cursor.insertText(" ");
  cursor.movePosition(QTextCursor::Down);
  cursor.insertText(newWeight);
  cursor.insertText("\n");

  cursor.endEditBlock ();
  setTextCursor(cursor);
  centerCursor () ;
  cursor.clearSelection ();
  setFocus () ;
  update();
}

void CodeEditor::insertList4(){
    //we have a active LIST already in the file let's replace it
    replace->setText("REM LIST ");
    searchLE->setText("^LIST ");
    replaceAll();
    replace->setText("");
    searchLE->setText("");
  if (!toPlainText().contains(listinst)){
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    cursor = document->find(unitinst,cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.insertText("LIST 4\n");
    emit saveMe(true,false);
  }

}

void CodeEditor::insertList6(){
  if (!toPlainText().contains(listinst)){
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    cursor = document->find(unitinst,cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.insertText("LIST 6 ! automatically inserted. Change 6 to 4 for CHECKCIF!!\n");
    emit saveMe(true,false);
  }
}

void CodeEditor::insertAnis(){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  cursor.insertText("ANIS ! automatically inserted\n");
}

void CodeEditor::insertActa(){
    insertList4();
  QTextDocument *document = this->document();
  QTextCursor cc,cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);

  cc = document->find(actainst,cursor);
  if (cc.isNull()) {
    cursor = textCursor();
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  }else return;
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  cursor.insertText("ACTA \n");
}

QString CodeEditor::dispFromWave(int an){
    if (chgl->mol->asymm.isEmpty()) return "";
    QFile kis(":kisselwave");
    kis.open(QIODevice::ReadOnly|QIODevice::Text);
    QByteArray ba=kis.readAll();
    QStringList all= QString(ba).split('\n');
    kis.close();
    QStringList nn,ann;
    QString disp;
      double aw=0,w;
      w=aw;

      int x=all.indexOf(QString("#S %1 %2").arg(an+1,2,10,QChar('0')).arg(chgl->mol->pse(an)));
      int y=all.indexOf(QString("#S %1 %2").arg(an+2,2,10,QChar('0')).arg(chgl->mol->pse(an+1)));
      //printf("SFAC <<%d>> %s\n",x,QString("#S %1 %2").arg(sfac.at(i)+1,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i))).toStdString().c_str());
      //printf("SFAC <<%d>> %s\n",y,QString("#S %1 %2").arg(sfac.at(i)+2,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i)+1)).toStdString().c_str());
      for (int j=x+1; j<y; j++){
        ann=nn;
        nn=all.at(j).split(" ",skipEmptyParts);
        aw=w;
        w=nn.at(0).toDouble();
        if ((w!=aw)&&(chgl->mol->cell.wave>w)) {
          double f= (chgl->mol->cell.wave-aw)/(w-aw);
              //printf("DISP $%s %f %f\n",chgl->mol->pse(sfac.at(i)).toStdString().c_str(),f*nn.at(1).toDouble()+(1-f)*an.at(1).toDouble(),f*nn.at(2).toDouble()+(1-f)*an.at(2).toDouble());
              if (nn.size()>3){
                  disp=QString("%1 %2 %3\n")//REM %5\nREM %6\n")
                    .arg(f*nn.at(1).toDouble()+(1-f)*ann.at(1).toDouble(),8,'f',5)
                    .arg(f*nn.at(2).toDouble()+(1-f)*ann.at(2).toDouble(),8,'f',5)
                    .arg(f*nn.at(3).toDouble()+(1-f)*ann.at(3).toDouble(),8,'f',5)
                    ;}else{
                  disp=QString("%1 %2 0.0\n")//REM %5\nREM %6\n")
                    .arg(f*nn.at(1).toDouble()+(1-f)*ann.at(1).toDouble(),8,'f',5)
                    .arg(f*nn.at(2).toDouble()+(1-f)*ann.at(2).toDouble(),8,'f',5)
                    ;
              }
          j=5000+x;
        }
      }
    return disp;
}
void CodeEditor::dispFromWave(){
  if (chgl->mol->asymm.isEmpty()) return;
  QFile kis(":kisselwave");
  kis.open(QIODevice::ReadOnly|QIODevice::Text);
  QByteArray ba=kis.readAll();
  QStringList all= QString(ba).split('\n');
  kis.close();
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.beginEditBlock();
  replace->setText("REM DISP ");
  searchLE->setText("^DISP ");
  replaceAll();
  replace->setText("");
  searchLE->setText("");
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find("UNIT",cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  QStringList nn,an;
  QString disp;
  for (int i=0; i<sfac.size();i++){
    double aw=0,w;
    w=aw;

    int x=all.indexOf(QString("#S %1 %2").arg(sfac.at(i)+1,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i))));
    int y=all.indexOf(QString("#S %1 %2").arg(sfac.at(i)+2,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i)+1)));
    //printf("SFAC <<%d>> %s\n",x,QString("#S %1 %2").arg(sfac.at(i)+1,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i))).toStdString().c_str());
    //printf("SFAC <<%d>> %s\n",y,QString("#S %1 %2").arg(sfac.at(i)+2,2,10,QChar('0')).arg(chgl->mol->pse(sfac.at(i)+1)).toStdString().c_str());
    for (int j=x+1; j<y; j++){
      an=nn;
      nn=all.at(j).split(" ",skipEmptyParts);
      aw=w;
      w=nn.at(0).toDouble();
      if ((w!=aw)&&(chgl->mol->cell.wave>w)) {
        double f= (chgl->mol->cell.wave-aw)/(w-aw); 
            //printf("DISP $%s %f %f\n",chgl->mol->pse(sfac.at(i)).toStdString().c_str(),f*nn.at(1).toDouble()+(1-f)*an.at(1).toDouble(),f*nn.at(2).toDouble()+(1-f)*an.at(2).toDouble());
            if (nn.size()>3){
                disp=QString("DISP $%1 %2 %3 %4!source kissel\n")//REM %5\nREM %6\n")
                  .arg(sfacsmbl.at(i))
                  .arg(f*nn.at(1).toDouble()+(1-f)*an.at(1).toDouble(),8,'f',5)
                  .arg(f*nn.at(2).toDouble()+(1-f)*an.at(2).toDouble(),8,'f',5)
                  .arg(f*nn.at(3).toDouble()+(1-f)*an.at(3).toDouble(),8,'f',5)
                  ;}else{
                disp=QString("DISP $%1 %2 %3!source kissel\n")//REM %5\nREM %6\n")
                  .arg(sfacsmbl.at(i))
                  .arg(f*nn.at(1).toDouble()+(1-f)*an.at(1).toDouble(),8,'f',5)
                  .arg(f*nn.at(2).toDouble()+(1-f)*an.at(2).toDouble(),8,'f',5)
                  ;
            }
        cursor.insertText(disp);
        j=5000+x;
      }
    }

  }

  cursor.endEditBlock();
}

void CodeEditor::updateUnit(){
  if (chgl->mol->asymm.isEmpty()) return;
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.beginEditBlock ();
  cursor.movePosition(QTextCursor::Start);
  cursor = document->find(unitAlt,cursor);
  if (cursor.isNull()) {
    cursor = textCursor();
    cursor.endEditBlock ();
//    printf("can't find unit\n");
    update();
    return;
  }
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
  cursor.deleteChar();
  cursor.insertText(unitNeu);
  cursor.endEditBlock ();
  setTextCursor(cursor);
  centerCursor () ;
  cursor.clearSelection ();
  setTextCursor(cursor);
  setFocus () ;
  update();
}

void CodeEditor::weedEmptySfacs(){
  if (chgl->mol->asymm.isEmpty()) return;
  emit saveMe(true,true);
  if (1){//(maybeSave()){
    QMap<int,double> unit;
    for (int i=0; i<chgl->mol->asymm.size(); i++){
      if (chgl->mol->asymm.at(i).an>=0) unit[chgl->mol->asymm.at(i).an]+= chgl->mol->asymm.at(i).sof * chgl->mol->cell.symmops.size();
    }
    unitNeu="UNIT";
    for (int i = 0; i < sfac.size() ; i++){
      if (unit.value(sfac.at(i))) {
        if (unit.value(sfac.at(i))>9999)
          unitNeu.append(QString(" %1").arg((int)unit.value(sfac.at(i)))); else
            unitNeu.append(QString(" %1").arg(unit.value(sfac.at(i)),0,'g'));
      }
      if (unitNeu.split('\n').last().size()>76) unitNeu.append("=\n    ");
    }
    updateUnit();
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    QTextCursor c=cursor;
    cursor.movePosition(QTextCursor::Start);
    int apos=0,pos=0;
    QList<int> mussweg,newSfac=sfac;
    for (int i = 0; i < sfac.size() ; i++){
      if (unit.value(sfac.at(i))==0) {
        mussweg.append(i);
        newSfac.removeOne(sfac.at(i));
      }
    }
    if (mussweg.isEmpty()) return;
    cursor = document->find(sfacinst,cursor);
    if (cursor.isNull()){setTextCursor(c);return;}
    cursor.movePosition(QTextCursor::Start);
    while ((!cursor.isNull())&&(pos<sfac.size())){
      cursor = document->find(sfacinst,cursor);
      cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
      if (cursor.selectedText().contains(plusfloat)){
        bool hatgleich=cursor.selectedText().contains(linecontinue);
        cursor.clearSelection();
        cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
        if (mussweg.contains(pos)) {
          cursor.insertText("REM ");
          if (hatgleich) {
            cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
            cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
            cursor.insertText("REM ");
          }
        }else if (hatgleich) cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
        pos++;
      }
      else {
        pos+=cursor.selectedText().split(" ",skipEmptyParts).size()-1;
        cursor.deleteChar();
        QString ac;
        for (int i =apos; i<newSfac.size() && i<pos+apos;i++) ac.append(QString("%1 ").arg(chgl->mol->pse(newSfac.at(i))));
        apos=pos;
        cursor.insertText(QString("SFAC %1\n").arg(ac));
      }
    }
    for (int i=0; i<chgl->mol->asymm.size();i++){
      if ((sfac.indexOf(chgl->mol->asymm.at(i).an)>-1)&&
          (newSfac.indexOf(chgl->mol->asymm.at(i).an)>-1)&&
          (sfac.indexOf(chgl->mol->asymm.at(i).an)!=newSfac.indexOf(chgl->mol->asymm.at(i).an))){
        jumpToAtom(i);
        cursor = textCursor();
        cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
        QString repla=cursor.selectedText();
        cursor.deleteChar();
        repla.replace(QString(" %1 ").arg(1+sfac.indexOf(chgl->mol->asymm.at(i).an)), QString(" %1 ").arg(1+newSfac.indexOf(chgl->mol->asymm.at(i).an)));
        cursor.insertText(repla);
        chgl->mol->asymm[i].orginalLine=repla;
      }
    }    
    emit saveMe(true,true);
    document = this->document();
    if(document->toPlainText().contains("DISP"))
      dispFromWave(); 
  }
}

void CodeEditor::jumpToAtom(int index){    
//    printf("1===========Jump 2 Atom!\n");
  QString label = chgl->mol->showatoms.at(index).orginalLine.left(80).trimmed();
  //  qDebug()<<index<<chgl->mol->showatoms.at(index).Label<<label;
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start);
  cursor = document->find(label,cursor);
  if (cursor.isNull()){
    cursor = textCursor();    
    cursor.movePosition(QTextCursor::Start);
    label.chop(10);
    cursor = document->find(label,cursor);
    if (cursor.isNull()) cursor = textCursor();
    cursor.movePosition(QTextCursor::Start);
    label = chgl->mol->showatoms.at(index).orginalLine.left(80).simplified();
    cursor = document->find(label,cursor);
    if (cursor.isNull()) cursor = textCursor();
  }
  cursor.movePosition(QTextCursor::StartOfLine);
  setTextCursor(cursor);
  centerCursor();
  cursor.clearSelection();
  setTextCursor(cursor);  
//  printf("===========Jump 2 Atom!\n");
  doSetTextCursor(cursor,false);
  setFocus();
}

void CodeEditor::insertANIS(QList<MyAtom> selected){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer("ANIS ");
  buffer = selectedRestraintsAtoms(buffer, selected, "", true);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertDFIX(double value, double esd, QList<MyAtom> selected, QString resiSpec){

  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer = QString("DFIX%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(value).arg(esd);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertDANG(double value, double esd, QList<MyAtom> selected, QString resiSpec){

  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("DANG%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(value).arg(esd);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertFLAT(double esd, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("FLAT%1 %2 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(esd);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertEXYZ(QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("EXYZ%1 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::jumpToError(){
  QTextCursor c = textCursor();
  if (!errorInLine.isEmpty()){
    c.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    c.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor,errorInLine.first());
    setTextCursor(c);
    ensureCursorVisible ();
  }
}

void CodeEditor::findResi(int i){
  if (i!=-1) {
      QString index = resiFinder->itemText(i);
    QTextCursor c=this->document()->find(index);
    if (!c.isNull()) {
      c.movePosition(QTextCursor::StartOfLine);
      setTextCursor(c);
      centerCursor();
      c.clearSelection ();
      //QTextBlock b =c.block();
      QStringList tt=index.split(spaces,skipEmptyParts);

      int nr=0;
      if ((tt.size()>1)&&(tt.at(1).indexOf(onlydigits)!=-1))//QRegularExpression("^[0-9]+")
        nr=tt.at(1).toInt();
      else if (tt.size()>2) nr=tt.at(2).toInt();
      //QString tt = index.section(spaces,1,1).toInt();
      chgl->selectResiByNr(nr);
      setTextCursor(c);
      setFocus () ;
    }
  }
}

void CodeEditor::increaseEdtiorFont(){
  QFont f =font();
  f.setPointSize(qMin(f.pointSize()+1,24));
  printf("Font increased %s %d\n", f.family().toStdString().c_str(),f.pointSize());
  setFont(f);
  update();
}

void CodeEditor::decreaseEdtiorFont(){
  QFont f =font();
  f.setPointSize(qMax(f.pointSize()-1,6));
  printf("Font decreased %s %d\n", f.family().toStdString().c_str(),f.pointSize());
  setFont(f);
  update();
}

void CodeEditor::hideSearch(){
  searchLE->clear();
  suchbox->hide();
}

void CodeEditor::showSearch(){
  suchbox->show();
  if (isReadOnly()){
    replace->hide(); 
    replaceButton->hide(); 
    replacePButton->hide(); 
    replaceAButton->hide(); 
  }else{
    replace->show(); 
    replaceButton->show(); 
    replacePButton->show(); 
    replaceAButton->show(); 
  }
  suchbox->setTitle(QString("Search and Replace:")); 
  searchLE->setFocus();
}

void CodeEditor::findNext(){
  suchbox->show();
  if (isReadOnly()){
    replace->hide(); 
    replaceButton->hide(); 
    replacePButton->hide(); 
    replaceAButton->hide(); 
  }else{
    replace->show(); 
    replaceButton->show(); 
    replacePButton->show(); 
    replaceAButton->show(); 
  }
  suchbox->setTitle(QString("Search and Replace:")); 
  searchchanged(false,false);
}

void CodeEditor::findPrev(){
  suchbox->show();
  if (isReadOnly()){
    replace->hide(); 
    replaceButton->hide(); 
    replacePButton->hide(); 
    replaceAButton->hide(); 
  }else{
    replace->show(); 
    replaceButton->show(); 
    replacePButton->show(); 
    replaceAButton->show(); 
  }
  suchbox->setTitle(QString("Search and Replace:")); 
  searchchanged(false,true);
}

void CodeEditor::findText(){
  searchchanged(true,false);
}

void CodeEditor::searchchanged(bool current,bool back){
  QRegularExpression searchString = QRegularExpression(searchLE->text(),QRegularExpression::CaseInsensitiveOption);
  QPalette p = searchLE->palette();
  p.setBrush(QPalette::Active,QPalette::Base,Qt::white);
  QTextDocument *document;
  QTextCursor cursor;

  document = this->document();
  cursor = textCursor();

  if (searchString.isValid()){
    if (cursor.hasSelection())
      cursor.setPosition((current|back)?cursor.anchor():cursor.position(), QTextCursor::MoveAnchor);
    QTextDocument::FindFlags options;
    if (back) options|=QTextDocument::FindBackward;
    cursor=document->find(searchString,cursor,options);
    if (cursor.isNull()){
      QTextCursor ac(document);
      ac.movePosition(options & QTextDocument::FindBackward
          ? QTextCursor::End : QTextCursor::Start);
      cursor = document->find(searchString, ac,options);
      if (cursor.isNull()){
        p.setBrush(QPalette::Active,QPalette::Base,QColor(205,100,100));
        cursor = textCursor();
        cursor.movePosition(QTextCursor::Start);
      }
    }
    if ((!cursor.isNull())&&(wholeLine->isChecked())){
      cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
      cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);      
      while ((cursor.selectedText().endsWith("="))||(cursor.selectedText().endsWith("= "))){
          cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
          cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
      }
    }
  }
  else cursor.movePosition(QTextCursor::Start);

  setTextCursor(cursor);
  searchLE->setPalette(p);
}

void CodeEditor::replaceNext(){
  suchbox->setTitle(QString("Search and Replace:")); 
  QRegularExpression searchString = QRegularExpression(searchLE->text(),QRegularExpression::CaseInsensitiveOption);
  QPalette p = searchLE->palette();
  p.setBrush(QPalette::Active,QPalette::Base,Qt::white);
  QTextDocument *document;
  QTextCursor cursor;
  int lastpos=-1;

  document = this->document();
  cursor = textCursor();

  if (searchString.isValid()){
    if (cursor.hasSelection()){
      cursor.beginEditBlock();
      if (wholeLine->isChecked()){
        cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
        cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);        
        while ((cursor.selectedText().endsWith("="))||(cursor.selectedText().endsWith("= "))){
            cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
            cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
        }
      }
      cursor.deleteChar();
      if (replace->text().isEmpty())cursor.deleteChar();
      else cursor.insertText(replace->text());
      lastpos=cursor.position();
      cursor.endEditBlock();
      cursor.setPosition(cursor.position(), QTextCursor::MoveAnchor);
    }
    cursor=document->find(searchString,cursor);
    if (cursor.isNull()){
      QTextCursor ac(document);
      ac.movePosition(QTextCursor::Start);
      cursor = document->find(searchString, ac);
      if (cursor.isNull()){
        p.setBrush(QPalette::Active,QPalette::Base,QColor(205,100,100));
      }
    }
    if ((!cursor.isNull())&&(wholeLine->isChecked())){
      cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
      cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);      
      while ((cursor.selectedText().endsWith("="))||(cursor.selectedText().endsWith("= "))){
          cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
          cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
      }
    }
  }
  else cursor.movePosition(QTextCursor::Start);
  if (cursor.isNull()){
    QTextCursor ac(document);
    ac.setPosition(lastpos);
    cursor=ac;
  }
  doSetTextCursor(cursor,false);
  setTextCursor(cursor);
  searchLE->setPalette(p);
  centerCursor();
  return;
}

void CodeEditor::replaceAll(){
  suchbox->setTitle(QString("Search and Replace:")); 
  QRegularExpression searchString = QRegularExpression(searchLE->text(),QRegularExpression::CaseInsensitiveOption);
  QPalette p = searchLE->palette();
  p.setBrush(QPalette::Active,QPalette::Base,Qt::white);
  QTextDocument *document;
  QTextCursor cursor;

  document = this->document();
  cursor = textCursor();
  int occurrence=0;
  cursor.beginEditBlock();
  cursor.movePosition(QTextCursor::Start);
  if (searchString.isValid()){
    do {
      cursor=document->find(searchString,cursor);
      if (cursor.hasSelection()){
        cursor.beginEditBlock();
        if (wholeLine->isChecked()){
          cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
          cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);          
          while ((cursor.selectedText().endsWith("="))||(cursor.selectedText().endsWith("= "))){
              cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
              cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
          }
        }
        cursor.deleteChar();
        if (replace->text().isEmpty())cursor.deleteChar();
        else cursor.insertText(replace->text());
        cursor.endEditBlock();
        cursor.setPosition(cursor.position(), QTextCursor::MoveAnchor);
        occurrence++;
      }
    }
    while (!cursor.isNull());
  }

  cursor = textCursor();
  cursor.endEditBlock();
  setTextCursor(cursor);
  searchLE->setPalette(p);
  centerCursor();
  if (occurrence){
    suchbox->setTitle(QString("Search and Replace: Replaced %1 occurrencies of '%2' by '%3'.").arg(occurrence).arg(searchString.pattern()).arg(replace->text()));
  }  
  return;
}

void CodeEditor::replacePrev(){
  suchbox->setTitle(QString("Search and Replace:")); 
  QRegularExpression searchString = QRegularExpression(searchLE->text(),QRegularExpression::CaseInsensitiveOption);

  QPalette p = searchLE->palette();
  p.setBrush(QPalette::Active,QPalette::Base,Qt::white);
  QTextDocument *document;
  QTextCursor cursor;  
  int lastpos=-1;

  document = this->document();
  cursor = textCursor();

  if (searchString.isValid()){
    if (cursor.hasSelection()){
      cursor.beginEditBlock();
      if (wholeLine->isChecked()){
        cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
        cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
      }
      cursor.deleteChar();
      if (replace->text().isEmpty())cursor.deleteChar();
      else cursor.insertText(replace->text());
      lastpos=cursor.position();
      cursor.endEditBlock();
      cursor.setPosition(cursor.anchor(), QTextCursor::MoveAnchor);
    }
    cursor=document->find(searchString,cursor,QTextDocument::FindBackward);
    if (cursor.isNull()){
      QTextCursor ac(document);
      ac.movePosition(QTextCursor::End);
      cursor = document->find(searchString, ac,QTextDocument::FindBackward);
      if (cursor.isNull()){
        p.setBrush(QPalette::Active,QPalette::Base,QColor(205,100,100));
      }
    }
  }
  else cursor.movePosition(QTextCursor::Start);  
  if (cursor.isNull()){
    QTextCursor ac(document);
    ac.setPosition(lastpos);
    cursor=ac;
  }
  doSetTextCursor(cursor,false);
  setTextCursor(cursor);
  searchLE->setPalette(p);
  centerCursor();
  searchchanged(false,true);
  return;
}

void CodeEditor::resiFinderDestroyed(){
  resiFinder = NULL;
}

void CodeEditor::changeSortierWeise(QAction* action){
  int index = action->data().toInt();
  sortierWeise = index;
  QSettings einstellung( QSettings::IniFormat, QSettings::UserScope ,PROGRAM_NAME,chgl->mol->mynewnameis );
  einstellung.beginGroup("Sorting");
  einstellung.setValue("SortingOption",sortierWeise);
  einstellung.endGroup();
}

QString CodeEditor::sortLabelList(CEnvironment &asymm, MyAtom &tatze){
    if (asymm.isEmpty()) return "HKLF";
    QMultiMap<long double,MyAtom> atomSortMap;
    long double lodo=0.0l;
    int amax = asymm.size();

    int t1=0,t2=0;
    for (int i=0; i < asymm.size(); i++){
      if (asymm.at(i).an<0) continue;
      t1++;
      QString s1 = asymm.at(i).Label.section('_',0,0);
      s1.remove(0,chgl->mol->pse(asymm.at(i).an).size());
      int n1 = s1.section(nodigits,0,0).toInt();
      int r1 = 0 ;
      char cc[10];
      strncpy(cc,s1.section(digits,1,-1).toStdString().c_str(),4);
      for (size_t k=0; k<strlen(cc);k++) {r1*=256;r1+=(size_t)cc[k];}
      switch (sortierWeise){
        case 1:
          lodo=asymm.at(i).resiNr*99*amax+
                  asymm.at(i).part*amax+
                  n1+
                  ((110-asymm.at(i).an)/220.0l)+
                  (r1 / 50000.0l);//46656
          //atomSortMap.insertMulti(lodo,asymm.at(i));
          atomSortMap.insert(lodo,asymm.at(i));
          break;
        case 2:
          lodo=asymm.at(i).resiNr*99*amax+
                  asymm.at(i).part*amax+
                  n1/999.0l+
                  ((110-asymm.at(i).an))+
                  (r1 / 50000.0l);//46656

          atomSortMap.insert(lodo,asymm.at(i));
          //printf("##= %Lf %d %d %d %d %d\n",lodo,asymm.at(i).resiNr,asymm.at(i).part,n1,(110-asymm.at(i).an),r1);
          break;
        case 3:
          lodo=  asymm.at(i).resiNr*99*amax+
                  asymm.at(i).part*amax+
                  n1/999.0l+
                  sfac.indexOf(asymm.at(i).an)*10+
                  (r1 / 50000.0l);//46656
          atomSortMap.insert(lodo,asymm.at(i));
          break;
        case 4:
          lodo=
          asymm.at(i).resiNr*99*amax+
          asymm.at(i).part*amax+
          n1/50000.0l+
          ((110-asymm.at(i).an)/220)+
          (r1 );//46656
          atomSortMap.insert(lodo,asymm.at(i));
          t2++;
          break;
        case 5:
          lodo=
          asymm.at(i).molindex*9999*amax+
          asymm.at(i).resiNr*99*amax+
          asymm.at(i).part*amax+
          n1/999.0l+
          ((110-asymm.at(i).an))+
          (r1 / 50000.0l);//46656
          atomSortMap.insert(lodo,asymm.at(i));
          /*printf("%s %g\n", asymm.at(i).Label.toStdString().c_str(),asymm.at(i).molindex*9999*amax+
              asymm.at(i).resiNr*99*amax+
              asymm.at(i).part*amax+
              n1/999.0+
              ((110-asymm.at(i).an))+
              (r1 / 50000.0));*/
          break;
        case 6:
            lodo=  asymm.at(i).resiNr*99*amax+
                    asymm.at(i).part*amax+
                    chgl->mol->ueq(asymm.at(i).uf);

        atomSortMap.insert(lodo,asymm.at(i));
        break;
        default:
          atomSortMap.insert(i, asymm.at(i));
          break;
      }
    }
    {
        QString s1 = tatze.Label.section('_',0,0);
        s1.remove(0,chgl->mol->pse(tatze.an).size());
        int n1 = s1.section(nodigits,0,0).toInt();
        int r1 = 0 ;
        char cc[10];
        strncpy(cc,s1.section(digits,1,-1).toStdString().c_str(),4);
        for (size_t k=0; k<strlen(cc);k++) {r1*=256;r1+=(size_t)cc[k];}
        //printf("VV= %Lf %d %d %d %d %d\n",lodo,tatze.resiNr,tatze.part,n1,(110-tatze.an),r1);
    switch (sortierWeise){
      case 1:
        lodo=tatze.resiNr*99*amax+
                tatze.part*amax+
                n1+
                ((110-tatze.an)/220.0l)+
                (r1 / 50000.0l);//46656
        break;
      case 2:
        lodo=tatze.resiNr*99*amax+
                tatze.part*amax+
                n1/999.0l+
                ((110-tatze.an))+
                (r1 / 50000.0l);//46656
        break;
      case 3:
        lodo=  tatze.resiNr*99*amax+
                tatze.part*amax+
                n1/999.0l+
                sfac.indexOf(tatze.an)*10+
                (r1 / 50000.0l);//46656
        break;
      case 4:
        lodo=
        tatze.resiNr*99*amax+
        tatze.part*amax+
        n1/50000.0l+
        ((110-tatze.an)/220)+
        (r1 );//46656
        break;
      case 5:
        lodo=
        tatze.molindex*9999*amax+
        tatze.resiNr*99*amax+
        tatze.part*amax+
        n1/999.0l+
        ((110-tatze.an))+
        (r1 / 50000.0l);//46656
        break;
    case 6:
        lodo=  tatze.resiNr*99*amax+
               tatze.part*amax+
               chgl->mol->ueq(tatze.uf);
        break;
    }
    }
    QList<long double> kys = atomSortMap.keys();
    long double fi = kys.first();//, la = kys.last();
    QString l="HKLF";
    //printf("value = %Lf first = %Lf last = %Lf\n", lodo, fi, la);
    if ((lodo>=fi)) {//
        CEnvironment asymm2    =  atomSortMap.values();
        int idx=0;
        for (; (idx<kys.size())&& (lodo>kys.at(idx)); idx++){}
        if (idx>0) idx--;
      //  printf("idx %d\n",idx);
        l = asymm2.at(idx).orginalLine.left(80).trimmed();
        asymm2.clear();
    }else{
        QTextDocument *doc = this->document();
        QTextCursor cursor = textCursor();
        cursor.movePosition(QTextCursor::Start);
        l=asymm.first().orginalLine.left(80).trimmed();
        cursor=doc->find(l, cursor);
        cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
        cursor.movePosition(QTextCursor::Up,QTextCursor::MoveAnchor);
        cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
        l=cursor.selectedText();
        cursor.clearSelection();
        cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    }
    kys.clear();
    atomSortMap.clear();
    return l;
}
void CodeEditor::sortAtoms(CEnvironment &as){
    if (as.isEmpty()) return;
    /*if (toPlainText().contains(QRegularExpression("[<>]"))){
      expandGreaterThan();
    }
    */
    QMap<long double,MyAtom> atomSortMap;

    int amax = as.size();
    int t1=0,t2=0;
    //printf("sortAtoms%d %lld\n",sortierWeise, as.size());
    for (int i=0; i < as.size(); i++){
      if (as.at(i).an<0) continue;
      t1++;
      QString s1 = as.at(i).Label;
      s1.remove(0,chgl->mol->pse(as.at(i).an).size());
      int n1 = s1.section(nodigits,0,0).toInt();
      int r1 = 0 ;
      char cc[10];
      strncpy(cc,s1.section(digits,1,-1).toStdString().c_str(),4);
      for (size_t k=0; k<strlen(cc);k++) {r1*=256;r1+=(size_t)cc[k];}
      switch (sortierWeise){
        case 1:
          atomSortMap.insert(
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1+
              ((110-as.at(i).an)/220.0)+
              (r1 / 50000.0)//46656
              ,as.at(i));
          break;
        case 2:
          atomSortMap.insert(
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1/999.0+
              ((110-as.at(i).an))+
              (r1 / 50000.0)//46656
              ,as.at(i));
          break;
        case 3:
          atomSortMap.insert(
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1/999.0+
              sfac.indexOf(as.at(i).an)*10+
              (r1 / 50000.0)//46656
              ,as.at(i));
          break;
        case 4:
          atomSortMap.insert(
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1/50000.0+
              ((110-as.at(i).an)/220)+
              (r1 )//46656
              ,as.at(i));
          t2++;
          break;
        case 5:
          atomSortMap.insert(
              as.at(i).molindex*9999*amax+
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1/999.0+
              ((110-as.at(i).an))+
              (r1 / 50000.0)//46656
              ,as.at(i));
/*          printf("%s %g\n", as.at(i).Label.toStdString().c_str(),as.at(i).molindex*9999*amax+
              as.at(i).resiNr*99*amax+
              as.at(i).part*amax+
              n1/999.0+
              ((110-as.at(i).an))+
              (r1 / 50000.0));*/
          break;

      case 6:{
          long double lodo=0.0l;
          lodo=  as.at(i).resiNr*99*amax+
                  as.at(i).part*amax+
                  chgl->mol->ueq(as.at(i).uf);
          atomSortMap.insert(lodo,as.at(i));
      }
      break;
        default:
          atomSortMap.insert(i
              ,as.at(i));
          break;
      }
    }
    as=  atomSortMap.values();
    //printf("done sorting.\n");
}

void CodeEditor::sortAtoms(){
  if (chgl->mol->asymm.isEmpty()) return;

  const QString sicher = toPlainText();
  //find atomranges
  if (sicher.contains(QRegularExpression("[<>]"))){
    //QStringList ranges;
    /*QStringList lines = sicher.split('\n');
    for (int i=0; (i<lines.size()); i++){
      if (lines.at(i).startsWith(' ')) continue;
      if (lines.at(i).startsWith("REM",QRegularExpression::CaseInsensitiveOption)) continue;
      if (lines.at(i).startsWith("HKLF",QRegularExpression::CaseInsensitiveOption)) break;
      if (lines.at(i).contains(QRegularExpression("[<>]"))) ranges.append(QString("LINE %1: %2")
          .arg(i+1)
          .arg(lines.at(i)));
    }*/
    expandGreaterThan();
    /*if (!ranges.isEmpty()){
      QMessageBox::information(0,"information",QString("<h3>Atom ranges detected! %1 "
            " can not sort here without destroying functionality of the file.</h3 <pre>%2 </pre>").arg(PROGRAM_NAME).arg(ranges.join("\n")));
      return;
    }*/
  }
  QMap<long double,MyAtom> atomSortMap;

  int amax = chgl->mol->asymm.size();
  printf("sortAtoms%d %d\n",sortierWeise, amax);
  int t1=0,t2=0;
  for (int i=0; i < chgl->mol->asymm.size(); i++){
    if (chgl->mol->asymm.at(i).an<0) continue;
    t1++;
    QString s1 = chgl->mol->asymm.at(i).Label;
    s1.remove(0,chgl->mol->pse(chgl->mol->asymm.at(i).an).size());
    int n1 = s1.section(nodigits,0,0).toInt();
    int r1 = 0 ;
    char cc[10];
    strncpy(cc,s1.section(digits,1,-1).toStdString().c_str(),4);
    for (size_t k=0; k<strlen(cc);k++) {r1*=256;r1+=(size_t)cc[k];}
    switch (sortierWeise){
      case 1:
        atomSortMap.insert(
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1+
            ((110-chgl->mol->asymm.at(i).an)/220.0)+
            (r1 / 50000.0)//46656
            ,chgl->mol->asymm.at(i));
        break;
      case 2:
        atomSortMap.insert(
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1/999.0+
            ((110-chgl->mol->asymm.at(i).an))+
            (r1 / 50000.0)//46656
            ,chgl->mol->asymm.at(i));
        break;
      case 3:
        atomSortMap.insert(
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1/999.0+
            sfac.indexOf(chgl->mol->asymm.at(i).an)*10+
            (r1 / 50000.0)//46656
            ,chgl->mol->asymm.at(i));
        break;
      case 4:
        atomSortMap.insert(
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1/50000.0+
            ((110-chgl->mol->asymm.at(i).an)/220)+
            (r1 )//46656
            ,chgl->mol->asymm.at(i));
        t2++;
        break;
      case 5:
        atomSortMap.insert(
            chgl->mol->asymm.at(i).molindex*9999*amax+
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1/999.0+
            ((110-chgl->mol->asymm.at(i).an))+
            (r1 / 50000.0)//46656
            ,chgl->mol->asymm.at(i));
/*        printf("%s %g\n", chgl->mol->asymm.at(i).Label.toStdString().c_str(),chgl->mol->asymm.at(i).molindex*9999*amax+
            chgl->mol->asymm.at(i).resiNr*99*amax+
            chgl->mol->asymm.at(i).part*amax+
            n1/999.0+
            ((110-chgl->mol->asymm.at(i).an))+
            (r1 / 50000.0));// */
        break;

    case 6:{
        long double lodo=0.0l;
        lodo=  chgl->mol->asymm.at(i).resiNr*99*amax+
                chgl->mol->asymm.at(i).part*amax+
                chgl->mol->ueq(chgl->mol->asymm.at(i).uf);
        atomSortMap.insert(lodo,chgl->mol->asymm.at(i));
    }
    break;
      default:
        atomSortMap.insert(i
            ,chgl->mol->asymm.at(i));
        break;
    }
  }
  CEnvironment asymm2=
    atomSortMap.values();

  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  wholeLine->setChecked(false);
  replace->setText("");
  searchLE->setText("^part.*$");
  replaceAll();
  replace->setText("");
  searchLE->setText("^resi.*$");
  replaceAll();
  cursor.beginEditBlock();
  cursor.movePosition(QTextCursor::Start);
  cursor = document->find("HKLF",cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Up,QTextCursor::KeepAnchor);
  if (parenthesis.at(cursor.blockNumber())){
    cursor.select(QTextCursor::WordUnderCursor);
    if ((cursor.selectedText().contains("RESI",Qt::CaseInsensitive))||(cursor.selectedText().contains("PART",Qt::CaseInsensitive)))
      cursor.movePosition(QTextCursor::Up,QTextCursor::KeepAnchor);
    cursor.select(QTextCursor::WordUnderCursor);
    if ((cursor.selectedText().contains("RESI",Qt::CaseInsensitive))||(cursor.selectedText().contains("PART",Qt::CaseInsensitive)))
      cursor.movePosition(QTextCursor::Up,QTextCursor::KeepAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.clearSelection();
    cursor.insertText("AFIX 0 \n");
  }

  /*QProgressDialog progress("Sorting atoms in Editor", QString(), 0, asymm2.size(), this);
  progress.setWindowModality(Qt::WindowModal);*/
  int ares=0, apart=0;
  for (int i=0; i < asymm2.size(); i++){
    //progress.setValue(i);
    QString  label = asymm2.at(i).orginalLine.left(80).trimmed();
    cursor.movePosition(QTextCursor::Start);
    cursor = document->find(label,cursor);
    //printf("find=>>%s {%d}\n",label.toStdString().c_str(),cursor.blockNumber());
    if (cursor.isNull()){
      cursor = textCursor();
      cursor.movePosition(QTextCursor::Start);
      label.chop(10);
      cursor = document->find(label,cursor);
      if (cursor.isNull()) {
        cursor = textCursor();
        printf("label not found #%d %s\n",i,label.toStdString().c_str());
        continue;
      }
    }

    if (parenthesis.at(cursor.blockNumber()))continue;//Afix not sorted here
    QString vorherig,neues;
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
    while (cursor.selectedText().endsWith("=")) {
      cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
      cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
    }
    while (parenthesis.at(cursor.blockNumber()+1)){
      cursor.movePosition(QTextCursor::Down,QTextCursor::KeepAnchor);
      cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
    }
    neues = vorherig= cursor.selectedText();
    cursor.deleteChar();
    cursor.deleteChar();
    cursor = textCursor();
    cursor.movePosition(QTextCursor::Start);
    cursor = document->find(hklfinst,cursor);
    cursor.clearSelection();
    cursor.movePosition(QTextCursor::StartOfLine);
    if ((asymm2.at(i).resiNr!=ares))
      cursor.insertText(QString("RESI %1 %2\n")
          .arg(asymm2.at(i).resiNr)
          .arg(asymm2.at(i).ResiClass));
    if ((asymm2.at(i).part!=apart))
      cursor.insertText(QString("PART %1\n")
          .arg(asymm2.at(i).part));
    //printf("=>%d\n",cursor.blockNumber());
    cursor.insertText(neues);
    cursor.insertText("\n");
    ares = asymm2.at(i).resiNr;
    apart = asymm2.at(i).part;
    updateAfix();
  }
  cursor = document->find("HKLF",cursor);
  cursor.clearSelection();
  cursor.movePosition(QTextCursor::StartOfLine);
  if ((0!=apart)) cursor.insertText(QString("PART 0\n"));
  if ((0!=ares)) cursor.insertText(QString("RESI 0\n"));
  cursor.endEditBlock ();
  emit updateLabel();

  chgl->disSelection();
  if (chgl->fuse->isVisible())chgl->mol->grow();
  else  chgl->mol->fuse();
  //chgl->=__LINE__;
  setUndoRedoEnabled ( true );
  chgl->update();
  searchLE->setText("");
  replace->setText("");
  wholeLine->setChecked(false);
  setTextCursor(cursor);

  //progress.setValue(asymm2.size());
}

void CodeEditor::sortSelectedRegion(){

  QTextCursor cursor = textCursor();
  int sta=cursor.selectionStart();
  int end=cursor.selectionEnd();
  cursor.setPosition(sta);    
  cursor.movePosition(QTextCursor::StartOfLine);
  cursor.setPosition(end, QTextCursor::KeepAnchor);    
  cursor.movePosition(QTextCursor::EndOfLine, QTextCursor::KeepAnchor);
  if (cursor.selectedText().endsWith("=")) cursor.movePosition(QTextCursor::Down, QTextCursor::KeepAnchor);
  //cursor.movePosition(QTextCursor::StartOfLine);
  QString sel=cursor.selectedText();
  CEnvironment toms;
  for (int i=0; i<chgl->mol->asymm.size(); i++){
    if (chgl->mol->asymm.at(i).afix!=0) continue;
    if (chgl->mol->asymm.at(i).orginalLine.size()<30) continue;
    if (sel.contains(chgl->mol->asymm.at(i).orginalLine,Qt::CaseInsensitive)){
      toms.append(chgl->mol->asymm[i]);
    }
  }
  int amax = toms.size();
  //int zeilen=sel.count(QChar::ParagraphSeparator);
  if (amax <3) {
    toms.clear();
    cursor.clearSelection ();
    setTextCursor(cursor);
    update();
    qDebug()<<"not enough atoms selected!";
    return;
  }
  int t1=0,t2=0;
  QMap<long double,MyAtom> atomSortMap;
  QMap<long double,int> atomSortMapi;
  for (int i=0; i < amax; i++){
    if (toms.at(i).an<0) continue;
    t1++;
    QString s1 = toms.at(i).Label;
    s1.remove(0,chgl->mol->pse(toms.at(i).an).size());
    int n1 = s1.section(nodigits,0,0).toInt();
    int r1 = 0 ;
    char cc[10];
    strncpy(cc,s1.section(digits,1,-1).toStdString().c_str(),4);
    for (size_t k=0; k<strlen(cc);k++) {r1*=256;r1+=(size_t)cc[k];}
    switch (sortierWeise){
      case 1:
        atomSortMap.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1+
            ((110-toms.at(i).an)/220.0)+
            (r1 / 50000.0)//46656
            ,toms.at(i));
        atomSortMapi.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1+
            ((110-toms.at(i).an)/220.0)+
            (r1 / 50000.0)//46656
            ,i);
        break;
      case 2:
        atomSortMap.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            ((110-toms.at(i).an))+
            (r1 / 50000.0)//46656
            ,toms.at(i));
        atomSortMapi.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            ((110-toms.at(i).an))+
            (r1 / 50000.0)//46656
            ,i);
        break;
      case 3:
        atomSortMap.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            sfac.indexOf(toms.at(i).an)*10+
            (r1 / 50000.0)//46656
            ,toms.at(i));
        atomSortMapi.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            sfac.indexOf(toms.at(i).an)*10+
            (r1 / 50000.0)//46656
            ,i);
        break;
      case 4:
        atomSortMap.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/50000.0+
            ((110-toms.at(i).an)/220)+
            (r1 )//46656
            ,toms.at(i));
        atomSortMapi.insert(
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/50000.0+
            ((110-toms.at(i).an)/220)+
            (r1 )//46656
            ,i);
        t2++;
        break;
      case 5:
        atomSortMap.insert(
            toms.at(i).molindex*9999*amax+
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            ((110-toms.at(i).an))+
            (r1 / 50000.0)//46656
            ,toms.at(i));
        atomSortMapi.insert(
            toms.at(i).molindex*9999*amax+
            toms.at(i).resiNr*99*amax+
            toms.at(i).part*amax+
            n1/999.0+
            ((110-toms.at(i).an))+
            (r1 / 50000.0)//46656
            ,i);
        /*		printf("%s %g\n", chgl->mol->asymm.at(i).Label.toStdString().c_str(),chgl->mol->asymm.at(i).molindex*9999*amax+
                        chgl->mol->asymm.at(i).resiNr*99*amax+
                        chgl->mol->asymm.at(i).part*amax+
                        n1/999.0+
                        ((110-chgl->mol->asymm.at(i).an))+
                        (r1 / 50000.0));*/
        break;
      default:
        atomSortMap.insert(i
            ,toms.at(i));
        atomSortMapi.insert(i
            ,i);
        break;
    }
  }
  CEnvironment asymm2=
    atomSortMap.values();
  QList<int> kk=atomSortMapi.values();
  cursor.beginEditBlock ();
  cursor.removeSelectedText ();

  QStringList neu,li= sel.split(QChar::ParagraphSeparator);

  QRegularExpression sep=spaces;
  QString neues;
  bool fix=false;
  for (int i=0; i<li.size(); i++){
    int cmd=Window::isacommand(li.at(i).section(sep,0,0));
    switch (cmd){
      case 1:fix=true;
             //printf("afix\n");
             // intentional fall-through !
      case -1: 
             if ((!fix)&&(cmd==-1)&&(!li.at(i).startsWith(" "))&&(!neues.isEmpty())){ 
               neu.append(neues);
               neues.clear();
             } 
             neues.append('\n');
             neues.append(li.at(i));
             if (li.at(i).contains (afix0inst)){
               neu.append(neues);
               neues.clear();
               fix=false;
             }
             break; 
      case 51:
      case 58:break;
      default:
              if (!neues.isEmpty()){ 
                neu.append(neues);
                neues.clear();
              } 
              cursor.insertText(li.at(i));
              cursor.insertText("\n");
    }

  }
  if (!neues.isEmpty()){ 
    neu.append(neues);
    neues.clear();
  } 
  //qDebug()<<neu<<neu.size()<<kk;
  int ares=0, apart=0;
  for (int i=0; i < asymm2.size(); i++){
    if ((asymm2.at(i).resiNr!=ares))
      cursor.insertText(QString("RESI %1 %2\n")
          .arg(asymm2.at(i).resiNr)
          .arg(asymm2.at(i).ResiClass));
    if ((asymm2.at(i).part!=apart))
      cursor.insertText(QString("PART %1\n")
          .arg(asymm2.at(i).part));
    cursor.insertText(neu.at(kk.at(i)));
    ares = asymm2.at(i).resiNr;
    apart = asymm2.at(i).part;
  }
  cursor.endEditBlock ();
  updateAfix();
  //todo editieren!!
}

void CodeEditor::insertEADP(QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("EADP%1 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertDELU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer = QString("DELU%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(esd1).arg(esd2);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertSIMU(double esd1, double esd2, double dmax, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("SIMU%1 %2 %3 %4 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(esd1).arg(esd2).arg(dmax);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertISOR(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("ISOR%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(esd1).arg(esd2);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertRIGU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("RIGU%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(esd1).arg(esd2);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::insertCHIV(double vol, double esd1, QList<MyAtom> selected, QString resiSpec){
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  cursor = document->find(unitinst,cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
  QString buffer =QString("CHIV%1 %2 %3 ").arg((resiSpec.isEmpty())?"":"_"+resiSpec).arg(vol).arg(esd1);
  buffer = selectedRestraintsAtoms(buffer, selected, resiSpec);
  cursor.insertText(DSRGui::textWrap(buffer));
}

void CodeEditor::omitsome(const QString &s){  
  QList<Omit> schonWeg;        
  Omit o;
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  QStringList sli;
  while (!cursor.isNull()){
    cursor = document->find(omithklinst,cursor);
    if (!cursor.isNull()){
      sli=cursor.selectedText().split(" ",skipEmptyParts);
      o.h=sli.at(1).toInt();
      o.k=sli.at(2).toInt();
      o.l=sli.at(3).toInt();
      schonWeg.append(o);
    }
  }
  QString sm=s;
  for (int i=0; i<schonWeg.size(); i++){
    sm.remove(QString("OMIT %1 %2 %3\n").arg(schonWeg.at(i).h).arg(schonWeg.at(i).k).arg(schonWeg.at(i).l)); 
  }
  cursor = textCursor();
  cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
  if (!sm.isEmpty()){
    cursor = document->find("UNIT",cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.insertText(sm);
    emit saveMe(true, true);    
  }
}

void CodeEditor::lineNumberAreaPaintEvent(QPaintEvent *event){
  QPainter painter(lineNumberArea);
  int current = textCursor().blockNumber();
  if (!dark){
      painter.fillRect(event->rect(), QColor("#eeeeee"));
        QTextBlock block = firstVisibleBlock();
       // printf("edidor Font: %s italic%d bold %d point %d pixel %d height %d\n",fontInfo().family().toStdString().c_str(),fontInfo().italic (),fontInfo().bold (),fontInfo().pointSize (),fontInfo().pixelSize (),fontMetrics().height());
      //   printf("lineNumberAreaPaintEvent\n");
        int blockNumber = block.blockNumber();
        int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
        int bottom = top + (int) blockBoundingRect(block).height();
        // printf ("line %d %d\n",top,bottom);
        int minbl=8888888,maxbl=0;
        while (block.isValid() && top <= event->rect().bottom()) {
          if (block.isVisible() && bottom >= event->rect().top()) {
            QString number = QString::number(blockNumber + 1);
            bool iscurrent=(blockNumber==current);
            if (m_cursors.hasMultipleCursors()){
                iscurrent=m_cursors.aCursorInThisBlock(blockNumber);
            }
            if (blockNumber%2) painter.fillRect(0, top,
                                            lineNumberArea->width(),
                                            fontMetrics().height(),QColor("#dddddd"));
            if (iscurrent) painter.fillRect(0, top,
                                            lineNumberArea->width(),
                                            fontMetrics().height(),QColor("#242424"));
            // /*
            QFont f=font();
            //printf("Font painter font %s %d\n", f.family().toStdString().c_str(),f.pointSize());
            if (errorInLine.contains(blockNumber)) {
          painter.fillRect(0, top,
                  lineNumberArea->width(),
                  fontMetrics().height(),QColor("#aa0000"));
          iscurrent=true;
            }
            if (comment.at(blockNumber)) {
          painter.fillRect(5, top+2,
                  3,//lineNumberArea->width()
                  fontMetrics().height()-4,(iscurrent)?QColor("#99aaff"):QColor("#0000aa"));
            }


            //printf("edidor Font: %s %d %d %d\n",f.family().toStdString().c_str(),f.pointSize(),fontMetrics().height(),fontMetrics().lineSpacing ());
            f.setWeight((iscurrent)?QFont::Black:QFont::Light);
            painter.setFont(f);
            // */
            painter.setPen((iscurrent)?Qt::white:Qt::darkGray);
            painter.drawText(0, top,
                    lineNumberArea->width(),
                            fontMetrics().lineSpacing () ,
                            Qt::AlignRight, number);
            minbl=qMin(minbl,blockNumber + 1);
            maxbl=qMax(maxbl,blockNumber + 1);
          }
          if (ListFile)
          midCursorpos=(minbl+maxbl)/2;
          block = block.next();
          top = bottom;
          bottom = top + (int) blockBoundingRect(block).height();
          ++blockNumber;
        }
  }else{
  painter.fillRect(event->rect(), QColor("#242424"));//"#eeeeee"));
  QTextBlock block = firstVisibleBlock();
 // printf("edidor Font: %s italic%d bold %d point %d pixel %d height %d\n",fontInfo().family().toStdString().c_str(),fontInfo().italic (),fontInfo().bold (),fontInfo().pointSize (),fontInfo().pixelSize (),fontMetrics().height());
//   printf("lineNumberAreaPaintEvent\n");
  int blockNumber = block.blockNumber();
  int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
  int bottom = top + (int) blockBoundingRect(block).height();
  // printf ("line %d %d\n",top,bottom);
  int minbl=8888888,maxbl=0;
  while (block.isValid() && top <= event->rect().bottom()) {
    if (block.isVisible() && bottom >= event->rect().top()) {
      QString number = QString::number(blockNumber + 1);
      bool iscurrent=(blockNumber==current);
      if (m_cursors.hasMultipleCursors()){
          iscurrent=m_cursors.aCursorInThisBlock(blockNumber);
      }
      if (blockNumber%2) painter.fillRect(0, top,
                                      lineNumberArea->width(),
                                      fontMetrics().height(),QColor("424242"));//"#dddddd"));
      if (iscurrent) painter.fillRect(0, top,
                                      lineNumberArea->width(),
                                      fontMetrics().height(),QColor("#eeeeee"));
      // /*
      QFont f=font();//painter.font();
      if (errorInLine.contains(blockNumber)) {
	painter.fillRect(0, top,
			lineNumberArea->width(),
			fontMetrics().height(),QColor("#aa0000"));
	iscurrent=true;
      }
      if (comment.at(blockNumber)) {
    painter.fillRect(5, top+2,
			3,//lineNumberArea->width()
            fontMetrics().height()-4,(!iscurrent)?QColor("#99aaff"):QColor("#0000aa"));
      }
      
      
      //printf("edidor Font: %s %d %d %d\n",f.family().toStdString().c_str(),f.pointSize(),fontMetrics().height(),fontMetrics().lineSpacing ());
      f.setWeight((iscurrent)?QFont::Black:QFont::Light);
      painter.setFont(f);
      // */
      painter.setPen((!iscurrent)?Qt::lightGray:Qt::black);
      painter.drawText(0, top,
		      lineNumberArea->width(), 
                      fontMetrics().lineSpacing () ,
                      Qt::AlignRight, number);
      minbl=qMin(minbl,blockNumber + 1);
      maxbl=qMax(maxbl,blockNumber + 1);
    }
    if (ListFile)
    midCursorpos=(minbl+maxbl)/2;
    block = block.next();
    top = bottom;
    bottom = top + (int) blockBoundingRect(block).height();
    ++blockNumber;
  }
  }


  //updateAfix();
  //afixHighlightArea->update();
  event->accept();
}

void CodeEditor::lineNumberToggled(QMouseEvent *event){
    QTextBlock block=firstVisibleBlock();
    int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
    int bn=firstVisibleBlock().blockNumber();
    int idx=(int)  (event->y()-top)/ ((int) blockBoundingRect(block).height()) + bn + 1;
//    printf("remark->  idx-1 %d  event.y %d top %d first %d height %g\n",idx-1,event->y(),top,bn,blockBoundingRect(block).height());
    remark(idx-1);
}

void CodeEditor::updateAfix(){
 // printf("updateAfix\n");
  blocks=toPlainText().split('\n');

  /*printf("test die Zeilenanzahl ist jetzt %d %d\n",  
		  blocks.size(),
		  blockCount()
		  );*/
  parenthesis.clear();
  parenthesis2.clear();
  comment.clear();
  int probe=0,aprobe=0,amn=0;
  bool kommentar=false;
  for (int i=0; i<blocks.size();i++){
    kommentar =  (blocks.at(i).contains(comments));
    comment.append(kommentar);
      if (blocks.at(i).contains(afix0inst)) {
          probe=0;
          amn=0;
      }
    else {
      if (blocks.at(i).contains(afixinst)) {
	probe++;
    int m=blocks.at(i).section(spaces,1,1,QString::SectionSkipEmpty).toInt()/10;
        int n=blocks.at(i).section(spaces,1,1,QString::SectionSkipEmpty).toInt()%10;
        if (amn==(m*10+n)) {
            probe--;
            parenthesis.last()=2;
        }
	if (n==5) {
//	  printf("%d be---\n",probe);
	  probe=(qMax(probe-2,0));
//	  printf("%d----\n",probe);
	}
        amn=m*10+n;
      }
    }
    if (blocks.at(i).contains(hklfinst)) {probe=aprobe=0;}
    parenthesis.append(qMax(probe,aprobe));
    aprobe=probe;
  }
  probe=0;
  for (int i=0; i<blocks.size();i++){
    if (blocks.at(i).contains(part0inst)) probe=0;
    else if (blocks.at(i).contains(partinst))
      probe=blocks.at(i).section(' ',1,1,QString::SectionSkipEmpty).toInt();
    if (blocks.at(i).contains(hklfinst)) {probe=0;}
    parenthesis2.append(probe);
  }
  afixHighlightArea->update();
}

void CodeEditor::remark(int line){
  if (isReadOnly ())return;
  if (blocks.size()<=line) return;
  QString zeile=blocks.at(line).simplified();
  bool cont= blocks.at(qMax(0,line-1)).contains(linecontinue);
  if (zeile.contains(comments)) {
    zeile=zeile.remove(0,4);
    if (cont) zeile.prepend(' ');
  }
  else zeile.prepend("REM ");  
  QTextCursor cu=textCursor ();
  cu.movePosition(QTextCursor::Start);
  cu.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor,line);
  cu.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cu.movePosition(QTextCursor::EndOfLine,QTextCursor::KeepAnchor);
  if (!cu.selectedText().isEmpty()) cu.deleteChar();
  cu.insertText(zeile);
  //qDebug()<<zeile;

}

void CodeEditor::toggleRemarks(){
QTextCursor cu=textCursor();
if (!cu.hasSelection())return;
cu.beginEditBlock();
int start=-1,end=-1,hilf=0;
start=cu.selectionStart();
end=cu.selectionEnd();
cu.setPosition(start);
start=cu.blockNumber();
cu.setPosition(end);
end=cu.blockNumber();
//printf("start %d end %d\n",start,end);
hilf=start;
start=qMin(start,end);
end=qMax(hilf,end);
if (end!=start) {
cu.clearSelection();
for (int i=start; i<=end; i++) remark(i);
//qDebug()<<cu.selectedText()<<"\n"<<start<<end;
}
cu.endEditBlock();
cu.clearSelection();
cu.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);

if (!cu.isNull()) setTextCursor(cu);
}

void CodeEditor::afixHighlightAreaPaintEvent(QPaintEvent *event){
//   printf("\nafixHighlightAreaPaintEvent\n");
  QPainter apainter(afixHighlightArea);
  apainter.fillRect(afixHighlightArea->rect(), (dark)?QColor(0xfff242424u):QColor(0xfffafafau));
  QTextBlock block = firstVisibleBlock();
  QColor color;
  QColor pcolor;
  int blockNumber = block.blockNumber();


  int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
  int bottom = top + (int) blockBoundingRect(block).height();
  //printf ("afix %d %d %d %d \n",top,bottom,block.isVisible(),event->rect().top());
  while (block.isValid() && top <= event->rect().bottom()) {
      switch (parenthesis.at(blockNumber)){
      case 0: color=(dark)?QColor(0xff242424u):QColor(0xfffafafau);
          //          Qt::white;
              break;
      case 1: color=Qt::darkGreen;break;
      default:
              color=QColor("blueviolet");
              break;
      }
      pcolor=PartColor::color(parenthesis2.at(blockNumber),dark);
    if (block.isVisible() && bottom >= event->rect().top()) {
    //  printf("%d %d %d %d %d %d\n",0,top, 4,fontMetrics().height(),parenthesis.at(blockNumber),blockNumber);
      apainter.fillRect(5,top, 4,fontMetrics().lineSpacing (),color);
      apainter.fillRect(0,top, 4,fontMetrics().lineSpacing (),pcolor);
     }
    block = block.next();
    blockNumber = block.blockNumber();
    top = bottom;
    bottom = top + (int) blockBoundingRect(block).height();
  } 
  event->accept();
}

void CodeEditor::hoverLineNumber(QMouseEvent *event){
    if (!isVisible()) {event->ignore(); return;}
    //fontMetrics().lineSpacing ()
    QTextBlock block=firstVisibleBlock();
    int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
    int bn=firstVisibleBlock().blockNumber();
    int idx=(int)  (event->y()-top)/ ((int) blockBoundingRect(block).height()) + bn;
    if (idx>=parenthesis.size()) {event->accept();return;}
    QString msg;
    if (parenthesis2.at(idx)){
        msg = QString("Line:%6%1 PART=%2 %3<br> Color:<font color=%5>%4 ## %5</font>")
                .arg((parenthesis.at(idx))?"<br>AFIXed<br>":"")
                .arg(parenthesis2.at(idx))
                .arg((comment.at(idx))?"<br>This line is a comment.":"")
                .arg(PartColor::name(parenthesis2.at(idx),dark))
                .arg(PartColor::color(parenthesis2.at(idx),dark).name())
                .arg(idx+1);
    }else{
        msg = QString("Line:%4%1 PART=%2 %3")
                .arg((parenthesis.at(idx))?"<br>AFIXed<br>":"")
                .arg(parenthesis2.at(idx))
                .arg((comment.at(idx))?"<br>This line is a comment.":"")
                .arg(idx+1);
    }
    QToolTip::showText(event->globalPos(),msg);
    event->accept();
}
bool CodeEditor::viewportEvent(QEvent *event){
//  printf("lala %d\n",event->type());
if (!isVisible()) {event->ignore(); return false;}
if (event->type() == QEvent::ToolTip) {
  QHelpEvent *helpEvent = static_cast<QHelpEvent *>(event);  
  QTextCursor cursor = cursorForPosition( helpEvent->pos());
  if(cursor.block().text().isEmpty()) return true;  
  QStringList block=shxToolTips.filter(cursor.block().text().left(4),Qt::CaseInsensitive);
  if (block.size())
    QToolTip::showText(helpEvent->globalPos(),block.first());
  int lnr=cursor.block().blockNumber()+1;
  QRegularExpression re=QRegularExpression("[-]*\\d{2,}\\.\\d+");
  double fvar=6666.6666;
  QString fvs;
  QString msg;

  //int pos=0,len=0;
  if ((block.isEmpty())&&(!highlighter->outputStyle())&&(cursor.block().blockNumber() > fvMinLine)){
      QRegularExpressionMatchIterator matchIterator = re.globalMatch(cursor.block().text());
    while (matchIterator.hasNext()){
      //fvs=re.cap(0);
      QRegularExpressionMatch match = matchIterator.next();
      fvs=match.captured();
      //len=fvs.size();
      fvar=fvs.toDouble();
      if (fvar!=6666.6666) {
        double av=qAbs(fvar),res=0.0,var=1.0;
        int m=0;
        while ((-10*m+av) > 5){m++;}
        if ((m>1)&&(m<=fv.size())) var = fv.at(m-1);
        if (!m) res = fvar;
        else if (fvar>0) res = (av-(10*m))*var;
        else res = (av-(10*m))*(1.0-var);
        //qDebug()<<v<<res<<m;
        // std::cout<< av <<"abs  v"<< v <<" m ="<< m << " var =" << var <<" res = "<<res<< std::endl ;
        //return res;
        if ((m)>fv.size()){
          if (m>1) msg+=QString("<font color=\"red\">Error in line %2!<br>Free Variable %1 is not defined yet!</font><hr>")
          .arg(m).arg(lnr);}
        else
          msg+=QString("Line <b>%3</b>: Free Variable <b>%1</b> gives <b> %2</b> here.<hr>")
               .arg(m).arg(res).arg(lnr);
      }
    }
    QToolTip::showText(helpEvent->globalPos(),msg);
    //  printf("shxToolTips size+%d %d %f\n", shxToolTips.size(),block.size(),fvar);
  }
  event->accept();
  return true;
}
return QAbstractScrollArea::viewportEvent ( event);
}

void  CodeEditor::contextMenuEvent(QContextMenuEvent *event) {
     //QMenu *menu = new QMenu();//createStandardContextMenu();
     QMenu *menu = createStandardContextMenu();
     QAction *a;
     QTextCursor cursor = cursorForPosition( event->pos());
     QTextBlock block=cursor.block();
     QString aname=block.text().section(" ",0,0);
     QStringList bfl=shxToolTips.filter(QRegularExpression(QString("^%1\\b").arg(aname)));
     if (bfl.isEmpty()){
        QString data=block.text().remove("=").trimmed();                                      // findInStructure
        if (data.startsWith("+")) a=menu->addAction(QString("+Open inluded file '%1'").arg(data) ,this,SLOT(openAnIncludeFile()));
        else a=menu->addAction(QString("locate %1 in structure").arg(aname) ,this,SLOT(searchInStructure()));
        a->setData(data);
     }//else {qDebug()<<bfl;}

     if (textCursor().hasSelection()){
         a=menu->addAction(QString("select atoms in structure found in selected text"),
                         this, SLOT(selectInStructure()));
         a->setData(textCursor().selectedText());
         a=menu->addAction(QString("sort atoms found in selected text"),
                         this, SLOT(sortSelectedRegion()));
         a->setData(textCursor().selectedText());
         menu->addAction(QString("toggle remarks states of selected text"),
			 this,SLOT(toggleRemarks()));
     }
     //...
     menu->exec(event->globalPos());
     delete menu;

     event->accept();
 }

void CodeEditor::diffTo(QString org){
    QList<QTextEdit::ExtraSelection> extraSelections;
    QTextEdit::ExtraSelection selection;
    QStringList orgZ = org.split('\n');
    QColor lineColor = QColor(0xffffddaau);
    setReadOnly(false);
    selection.cursor = textCursor();
    selection.cursor.clearSelection();
    selection.cursor.movePosition(QTextCursor::Start);

    selection.format.setBackground(lineColor);
    selection.format.setProperty(QTextFormat::FullWidthSelection, true);

    QTextBlock b = selection.cursor.block();
    int i=0;
    while (b.isValid()){
        if (b.text()!=orgZ.at(i)){
           /* printf(">>%s!\n<<%s!%d\n",
                   b.text().toStdString().c_str(),
                   orgZ.at(i).toStdString().c_str(),b.position()
                   );// */
            selection.cursor.clearSelection();
            selection.cursor.setPosition(b.position());
            selection.cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
            selection.cursor.movePosition(QTextCursor::EndOfLine,QTextCursor::MoveAnchor);

            extraSelections.append(selection);
        }
        b=b.next();
        int j=orgZ.indexOf(b.text(),i);
        i=(j<0)?i+1:j;
        i=qMin(i,orgZ.size()-1);
    }
    setExtraSelections(extraSelections);
    setReadOnly(true);
    update();
}

void CodeEditor::searchInStructure(){
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        emit findInStructure(action->data().toString());

}

void CodeEditor::openAnIncludeFile(){
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        emit openIncludeFile(action->data().toString());

}

void CodeEditor::selectInStructure(){
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        emit electInStructure(action->data().toString());

}

void CodeEditor::setCompleter(QCompleter *completer){
    //printf("setCompleter %p %p\n",c,completer);
    if (c)
        QObject::disconnect(c, 0, this, 0);

    c = completer;

    if (!c)
        return;

    c->setWidget(this);
    //c->setMaxVisibleItems(13);
    c->setCompletionMode(QCompleter::PopupCompletion);
    c->setCaseSensitivity(Qt::CaseInsensitive);
    QObject::connect(c, SIGNAL(activated(QString)),
                     this, SLOT(insertCompletion(QString)));
}

QCompleter *CodeEditor::completer() const{
    return c;
}

void CodeEditor::insertCompletion(const QString& completion){
    if (c->widget() != this)
        return;
    QTextCursor tc = textCursor();
    tc.joinPreviousEditBlock ();
    MultiTextCursor mc=multiTextCursor();
    //printf("compl:%s: %d %d\n",completion.toStdString().c_str(),tc.position(),mc.mainCursor().position());
    //int extra = completion.length() - c->completionPrefix().length();
    //tc.movePosition(QTextCursor::Left);
//    int p=tc.selectionStart()- tc.block().position();
    tc.movePosition(QTextCursor::EndOfWord,QTextCursor::MoveAnchor);
    tc.movePosition(QTextCursor::StartOfLine,QTextCursor::KeepAnchor);
    QString extra = tc.selectedText();
    //extra.remove(0,1);
    extra.remove(startsmall);
    if ((completion!="REM "))extra.clear();
    tc.deleteChar();
    tc.insertText(completion+" "+extra);
    tc.endEditBlock();
    setTextCursor(tc);
}

QString CodeEditor::textUnderCursor() const{
    QTextCursor tc = textCursor();
    tc.select(QTextCursor::WordUnderCursor);
    if (tc.selectedText().contains("_")) return "";
    int si=tc.selectedText().size();
    if (((tc.selectionStart () - tc.block().position())<4)&&(si>4)) return tc.selectedText().left(si-4);
    if ((tc.position() - tc.block().position())>2) return "";
    return tc.selectedText();
}



void CodeEditor::insertFree(){
  if (chgl->mol->selectedatoms.size()!=2) return;
  QAction *action = qobject_cast<QAction *>(sender());
  if (action){
    int index=  action->data().toInt();
    QString frei=QString("FREE %1 %2 !experimental does not work with EQIV AND PART\n")
      .arg(chgl->mol->selectedatoms.at(0).Label.section(QString::fromUtf8("»"),0,0),chgl->mol->selectedatoms.at(1).Label.section(QString::fromUtf8("»"),0,0));
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    cursor.beginEditBlock();
    cursor = document->find("HKLF",cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.insertText(frei);
    cursor.endEditBlock();
    chgl->disConnectSelection(index);
  }
}

void CodeEditor::insertBind(){
  if (chgl->mol->selectedatoms.size()!=2) return;
  QString binde=QString("BIND %1 %2 !experimental does not work with EQIV AND PART\n")
    .arg(chgl->mol->selectedatoms.at(0).Label.section(QString::fromUtf8("»"),0,0),chgl->mol->selectedatoms.at(1).Label.section(QString::fromUtf8("»"),0,0));
  QTextDocument *document = this->document();
  QTextCursor cursor = textCursor();
  cursor.beginEditBlock();
  cursor = document->find("HKLF",cursor);
  cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
  cursor.insertText(binde);
  cursor.endEditBlock();
  chgl->connectSelection();
}

void CodeEditor::keyPressEvent(QKeyEvent *e){
//    printf("kp\n");
//    if (!chgl->mol->selectedatoms.isEmpty()){

    if (c && c->popup()->isVisible()) {
        // The following keys are forwarded by the completer to the widget
       switch (e->key()) {
       case Qt::Key_Enter:
       case Qt::Key_Return:
       case Qt::Key_Escape:
       case Qt::Key_Tab:
      // case Qt::Key_Left:
      // case Qt::Key_Right:
       case Qt::Key_Backtab:
            e->ignore();
            return; // let the completer do default behavior
       default:
           break;
       }
    }
  MultiTextCursor mcursor = multiTextCursor();

  if (e->key() == Qt::Key_Escape ) {
      if (mcursor.hasMultipleCursors()) {
          QTextCursor c = mcursor.mainCursor();
          c.setPosition(c.position(), QTextCursor::MoveAnchor);
//          printf("%d\n",__LINE__);
          doSetTextCursor1(c);
          return;
      }
  }


  // Pressing F1 when the mouse cursor is over a SHELX command will
  // open the SHELXL help text:
  if (e->key() == Qt::Key_F1) {
    QTextCursor tc = textCursor();
    //tc.select(QTextCursor::WordUnderCursor);
    tc.select(QTextCursor::LineUnderCursor);
    QString txt = tc.selectedText().toUpper().left(4).trimmed();
    //printf("%s\n",txt.toStdString().c_str());
    if ( Window::isacommand(txt) >= 0 ) {
      QUrl help_url = QString("http://shelx.uni-goettingen.de/shelxl_html.php#%1").arg(txt);
      QDesktopServices::openUrl(help_url);
    }
  }
  const bool ro = isReadOnly();
  const bool inOverwriteMode = overwriteMode();
  const bool hasMultipleCursors = mcursor.hasMultipleCursors();
  if (!ro && e == QKeySequence::Paste){
//      printf("wanna pasta\n");
      mpaste();
      e->accept();
      return;
  } else if (!ro && e == QKeySequence::Cut){
      mcut();
      e->accept();
      return;
  } else
  if (!ro && (e == QKeySequence::MoveToStartOfBlock
              || e == QKeySequence::SelectStartOfBlock
              || e == QKeySequence::MoveToStartOfLine
              || e == QKeySequence::SelectStartOfLine)) {
      const bool blockOp = e == QKeySequence::MoveToStartOfBlock || e == QKeySequence::SelectStartOfBlock;
      const bool select = e == QKeySequence::SelectStartOfLine || e == QKeySequence::SelectStartOfBlock;
      handleHomeKey(select, blockOp);
      e->accept();
      return;
  } else if (!ro && e == QKeySequence::DeleteStartOfWord) {
      e->accept();
      if (!mcursor.hasSelection()) {
          mcursor.movePosition(QTextCursor::PreviousWord, QTextCursor::KeepAnchor);
      }
      mcursor.removeSelectedText();
      setMultiTextCursor(mcursor);
      return;
  } else if (!ro && e == QKeySequence::DeleteEndOfWord) {
      e->accept();
      if (!mcursor.hasSelection()) {
          mcursor.movePosition(QTextCursor::NextWord, QTextCursor::KeepAnchor);
      }
      mcursor.removeSelectedText();
      setMultiTextCursor(mcursor);
      return;
  } else if (!ro && e == QKeySequence::Undo){
      QPlainTextEdit::undo();
      e->accept();
      return;
  }

  /*else if (!ro && e == QKeySequence::DeleteCompleteLine) {
      e->accept();
      for (QTextCursor &c : cursor)
          c.select(QTextCursor::BlockUnderCursor);
      cursor.mergeCursors();
      cursor.removeSelectedText();
      setMultiTextCursor(cursor);
      return;
  } else*/

  switch (e->key()) {
  case Qt::Key_Backspace:
      if (ro) break;
      if ((e->modifiers() & (Qt::ControlModifier
                             | Qt::ShiftModifier
                             | Qt::AltModifier
                             | Qt::MetaModifier)) == Qt::NoModifier) {
          e->accept();
          if (mcursor.hasSelection()) {
              mcursor.removeSelectedText();
              setMultiTextCursor(mcursor);
              return;
          }
          handleBackspaceKey();
          return;
      }
      break;
  case Qt::Key_Insert:
      if (ro) break;
      if (e->modifiers() == Qt::NoModifier) {
//          printf("insert or overwirte %d\n",inOverwriteMode);
//          setOverwriteMode(!inOverwriteMode);
          e->accept();
          return;
      }
      break;
  case Qt::Key_Delete:
      if (hasMultipleCursors && !ro && e->modifiers() == Qt::NoModifier) {
          if (mcursor.hasSelection()) {
              mcursor.removeSelectedText();
          } else {
              mcursor.beginEditBlock();
              for (int i=0; i<mcursor.m_cursors.size(); i++) mcursor.m_cursors[i].deleteChar();
              mcursor.mergeCursors();
              mcursor.endEditBlock();
          }
          e->accept();
          return;
          }
          break;
      default:
          break;
  }

  if ((e->modifiers() & Qt::ControlModifier)&&(e->key()==Qt::Key_Delete)) {
      	e->ignore();
        emit deleteSelected();
    return;
    }

  const QString eventText = e->text();
  if (ro || !isPrintableText(eventText)) {
          QTextCursor::MoveOperation blockSelectionOperation = QTextCursor::NoMove;
          if (e->modifiers() & Qt::AltModifier) {
              if (MultiTextCursor::multiCursorAddEvent(e, QKeySequence::MoveToNextLine))
                  blockSelectionOperation = QTextCursor::Down;
              else if (MultiTextCursor::multiCursorAddEvent(e, QKeySequence::MoveToPreviousLine))
                  blockSelectionOperation = QTextCursor::Up;
              else if (MultiTextCursor::multiCursorAddEvent(e, QKeySequence::MoveToNextChar))
                  blockSelectionOperation = QTextCursor::NextCharacter;
              else if (MultiTextCursor::multiCursorAddEvent(e, QKeySequence::MoveToPreviousChar))
                  blockSelectionOperation = QTextCursor::PreviousCharacter;
          }


          if (blockSelectionOperation != QTextCursor::NoMove) {
              //auto doNothing = [](){};
              //[](){};(doNothing);
              //printf("about to handleMoveBlockSelection\n");
              handleMoveBlockSelection(blockSelectionOperation);
          } else if (!cursorMoveKeyEvent(e)) {
              QTextCursor cursor = textCursor();
              //printf("ro=%d %s\n",ro,eventText.toStdString().c_str());
              QPlainTextEdit::keyPressEvent(e);
          }
      } else if (hasMultipleCursors) {
      //printf("hasMultipleCursors\n");
          if (inOverwriteMode) {
              mcursor.beginEditBlock();
              for (int i=0; i<mcursor.m_cursors.size(); i++){
//              for (QTextCursor &c : cursor) {
                  QTextBlock block = mcursor.m_cursors[i].block();
                  int eolPos = block.position() + block.length() - 1;
                  int selEndPos = qMin(mcursor.m_cursors[i].position() + eventText.length(), eolPos);
                  mcursor.m_cursors[i].setPosition(selEndPos, QTextCursor::KeepAnchor);
                  mcursor.m_cursors[i].insertText(eventText);
              }
              mcursor.endEditBlock();
          } else {
              mcursor.insertText(eventText);
          }
          setMultiTextCursor(mcursor);
      } else if ((e->modifiers() & (Qt::ControlModifier|Qt::AltModifier)) != Qt::ControlModifier){
          // only go here if control is not pressed, except if also alt is pressed
          // because AltGr maps to Alt + Ctrl

          QTextCursor cursor = textCursor();

          if (inOverwriteMode) {
              QTextBlock block = cursor.block();
              int eolPos = block.position() + block.length() - 1;
              int selEndPos = qMin(cursor.position() + eventText.length(), eolPos);
              cursor.setPosition(selEndPos, QTextCursor::KeepAnchor);
              cursor.insertText(eventText);
          } else {
              cursor.insertText(eventText);
          }
          setTextCursor(cursor);
      }// */

    //}


   // bool isShortcut = ((e->modifiers() & Qt::ControlModifier) && e->key() == Qt::Key_E); // CTRL+E
   // if (!c) // do not process the shortcut when we have a completer
    //printf("here\n");
    //    QPlainTextEdit::keyPressEvent(e);

    const bool ctrlOrShift = e->modifiers() & (Qt::ControlModifier | Qt::ShiftModifier);
    if (!c || (ctrlOrShift && e->text().isEmpty()))
        return;

    static QString eow("!"); // end of word
    bool hasModifier = (e->modifiers() != Qt::NoModifier) && !ctrlOrShift;
    QString completionPrefix = textUnderCursor();
    if ((hasModifier || e->text().isEmpty()|| completionPrefix.length() < 1
                      || eow.contains(e->text().right(1)))) {
        c->popup()->hide();
        return;
    }

    if (completionPrefix != c->completionPrefix()) {
        c->setCompletionPrefix(completionPrefix);
        c->popup()->setCurrentIndex(c->completionModel()->index(0, 0));
    }
    QRect cr = cursorRect();
    cr.moveRight(lineNumberAreaWidth()+11);;
    cr.setWidth(c->popup()->sizeHintForColumn(0)
                + c->popup()->verticalScrollBar()->sizeHint().width());
    c->complete(cr); // popup it up!
}


void CodeEditor::insertCONF(){//!< inserts CONF instruction into the file...
    QTextDocument *document = this->document();
    QTextCursor cc,cursor = textCursor();
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);

    cc = document->find(confinst,cursor);
    if (cc.isNull()) {
      cursor = textCursor();
      cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    }else return;
    cursor = document->find(unitinst,cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.insertText("CONF \n");
}

void CodeEditor::insertEXTI(){//!< inserts a EXTI instruction into the file...
    QTextDocument *document = this->document();
    QTextCursor cc,cursor = textCursor();
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);

    cc = document->find(extiinst,cursor);
    if (cc.isNull()) {
      cursor = textCursor();
      cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    }else return;
    cursor = document->find(unitinst,cursor);
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    cursor.movePosition(QTextCursor::Down,QTextCursor::MoveAnchor);
    cursor.insertText("EXTI \n");
}



MultiTextCursor CodeEditor::multiTextCursor() const{
    const QTextCursor c=textCursor();
    if ((m_cursors.isNull())&&(!c.isNull())){
        MultiTextCursor mc(c);
        const_cast<MultiTextCursor &>(m_cursors) = mc;
//        printf("nun %d %d %d\n",m_cursors.isNull(), m_cursors.cursorCount(),m_cursors.mainCursor().isNull());
    }
    return m_cursors;
}

void CodeEditor::setMultiTextCursor(const MultiTextCursor &cursor){
    const MultiTextCursor oldCursor = m_cursors;
    const_cast<MultiTextCursor &>(m_cursors) = cursor;
    if (oldCursor == m_cursors)
        return;
//    printf("%d\n",__LINE__);
    doSetTextCursor(m_cursors.mainCursor(), /*keepMultiSelection*/ true);
    QRect updateRect = cursorUpdateRect(oldCursor);
    //if (d->m_highlightCurrentLine) updateRect = QRect(0, updateRect.y(), viewport()->rect().width(), updateRect.height());
    updateRect |= cursorUpdateRect(m_cursors);
    viewport()->update(updateRect);
    emit cursorPositionChanged();
}

QRect CodeEditor::cursorUpdateRect(const MultiTextCursor &cursor){
    QRect result(0, 0, 0, 0);
//    for (const QTextCursor &c : cursor)
    for (int i=0; i<cursor.m_cursors.size(); i++){
        result |= cursorRect(cursor.m_cursors[i]);
    }
    //printf("%d %d %d %d \n",result.x(),result.y(),result.width(),result.height());
    return result;
}

void CodeEditor::doSetTextCursor(const QTextCursor &cursor, bool keepMultiSelection){
    // workaround for QTextControl bug
    //bool selectionChange = cursor.hasSelection() || textCursor().hasSelection();
    //printf("doSetTextCursor\n");
    QTextCursor c = cursor;
    c.setVisualNavigation(true);
    const MultiTextCursor oldCursor = m_cursors;
    if (!keepMultiSelection){
        QList<QTextCursor> cs;
        cs.append(c);
        const_cast<MultiTextCursor &>(m_cursors).setCursors(cs); //{c}
        //printf("doSetTextCursor %d %d not keepMultiSelection\n",cs.size(),m_cursors.cursorCount());
    }
    else
        const_cast<MultiTextCursor &>(m_cursors).replaceMainCursor(c);
    updateCursorSelections();
    resetCursorFlashTimer();
    //printf("=>doSetTextCursor %d\n",m_cursors.cursorCount());
    //doSetTextCursor(c);
    setTextCursor(c);
    //QPlainTextEdit::doSetTextCursor(c);
    if (oldCursor != m_cursors) {
        //printf("must uptadte rect\n");
        QRect updateRect = cursorUpdateRect(oldCursor);
        //if (d->m_highlightCurrentLine) updateRect = QRect(0, updateRect.y(), viewport()->rect().width(), updateRect.height());
        updateRect |= cursorUpdateRect(m_cursors);
        viewport()->update(updateRect);
        //emit cursorPositionChanged();
    }
    //if (selectionChange)  d->slotSelectionChanged();
}


void CodeEditor::updateCursorSelections(){                 
    //const QTextCharFormat selectionFormat = TextEditorSettings::fontSettings().toTextCharFormat(C_SELECTION);
    QTextCharFormat selectionFormat;
    selectionFormat.setBackground((dark)?QColor("#346792"):QColor("#a5cbfa"));
    QList<QTextEdit::ExtraSelection> selections;
    //for (const QTextCursor &cursor : m_cursors) {
    for (int i=0; i<m_cursors.m_cursors.size(); i++) {
        if (m_cursors.m_cursors.at(i).hasSelection()){
            QTextEdit::ExtraSelection s;
            s.cursor=m_cursors.m_cursors[i];
            s.format=selectionFormat;
            selections << s;
        }
    }
    if (selections.isEmpty()) m_blockSelections.clear();
    setExtraSelections(selections);
}

void CodeEditor::startCursorFlashTimer()
{
    const int flashTime = QApplication::cursorFlashTime();
    //printf("cursorFlashTime %d\n",flashTime);
    if (flashTime > 0) {
        m_cursorFlashTimer.stop();
        m_cursorFlashTimer.start(flashTime / 2,this);
    }
    if (!m_cursorVisible) {
        m_cursorVisible = true;
        viewport()->update(cursorUpdateRect(m_cursors));
    }
}

void CodeEditor::resetCursorFlashTimer(){
    //return;
    if (!m_cursorFlashTimer.isActive())
        return;
    const int flashTime = QApplication::cursorFlashTime();
    if (flashTime > 0) {
        m_cursorFlashTimer.stop();
        m_cursorFlashTimer.start(flashTime / 2,this);
    }
    if (!m_cursorVisible) {
        m_cursorVisible = true;
        viewport()->update(cursorUpdateRect(m_cursors));
    }
}


void CodeEditor::focusInEvent(QFocusEvent *e){
    if (c)  c->setWidget(this);
    QPlainTextEdit::focusInEvent(e);
    startCursorFlashTimer();
    //d->updateHighlights();
}

void CodeEditor::focusOutEvent(QFocusEvent *e){
    QPlainTextEdit::focusOutEvent(e);
    if (viewport()->cursor().shape() == Qt::BlankCursor)
        viewport()->setCursor(Qt::IBeamCursor);
    m_cursorFlashTimer.stop();
    if (m_cursorVisible) {
        m_cursorVisible = false;
        viewport()->update(cursorUpdateRect(m_cursors));
    }
    //d->updateHighlights();
}


void CodeEditor::doSetTextCursor1(const QTextCursor &cursor){
//  const char* str = __builtin_FUNCTION();
//  printf("called by %s\n", str);
//  printf("%d\n",__LINE__);
  doSetTextCursor(cursor, false);
}


void CodeEditor::moveCursor(QTextCursor::MoveOperation operation, QTextCursor::MoveMode mode){
    MultiTextCursor cursor = m_cursors;
    cursor.movePosition(operation, mode);
    setMultiTextCursor(cursor);
}

bool CodeEditor::cursorMoveKeyEvent(QKeyEvent *e){
    MultiTextCursor cursor = m_cursors;
    if (cursor.handleMoveKeyEvent(e)) {
        //printf("handleMoveKeyEvent %d!!\n",cursor.cursorCount());
        resetCursorFlashTimer();
        setMultiTextCursor(cursor);
        ensureCursorVisible();
        //updateCurrentLineHighlight();
        return true;
    }
    return false;
}
void CodeEditor::handleHomeKey(bool anchor, bool block){
    const QTextCursor::MoveMode mode = anchor ? QTextCursor::KeepAnchor
                                              : QTextCursor::MoveAnchor;

    MultiTextCursor mcursor = multiTextCursor();
    //for (QTextCursor &c : cursor) {
    for (int i=0; i<mcursor.m_cursors.size(); i++){
        const int initpos = mcursor.m_cursors[i].position();
        int pos = mcursor.m_cursors[i].block().position();

        if (!block) {
            // only go to the first non space if we are in the first line of the layout
            //c++17...
            if (mcursor.m_cursors[i].block().layout()->lineForTextPosition(initpos - pos).lineNumber()!=0)
            /*if (QTextLayout *layout = mcursor.m_cursors[i].block().layout();
                layout->lineForTextPosition(initpos - pos).lineNumber() != 0)*/ {
                mcursor.m_cursors[i].movePosition(QTextCursor::StartOfLine, mode);
            }
        }

        QChar character = document()->characterAt(pos);
        const QLatin1Char tab = QLatin1Char('\t');

        while (character == tab || character.category() == QChar::Separator_Space) {
            ++pos;
            if (pos == initpos)
                break;
            character = document()->characterAt(pos);
        }

        // Go to the start of the block when we're already at the start of the text
        if (pos == initpos)
            pos = mcursor.m_cursors[i].block().position();

        mcursor.m_cursors[i].setPosition(pos, mode);
    }
    setMultiTextCursor(mcursor);
}

void CodeEditor::handleBackspaceKey(){
    //if (!multiTextCursor().hasSelection()) return;
    MultiTextCursor mcursor = m_cursors;
    if (mcursor.cursorCount()<2) {
        QTextCursor c=textCursor();
        c.deletePreviousChar();
        setTextCursor(c);
        return;
    }
    mcursor.beginEditBlock();
    //for (QTextCursor &c : cursor) {
    for (int i=0; i<mcursor.m_cursors.size(); i++){
        const int pos = mcursor.m_cursors[i].position();
        if (!pos)
            continue;
        mcursor.m_cursors[i].deletePreviousChar();
    }
    mcursor.endEditBlock();
    setMultiTextCursor(mcursor);
}

void CodeEditor::mouseMoveEvent(QMouseEvent *e){

    static MultiTextCursor startMouseMoveCursor;
    if (e->buttons() == Qt::LeftButton && e->modifiers() & Qt::AltModifier) {
        if (!startMouseMoveCursor1) {
            startMouseMoveCursor1=true;
            startMouseMoveCursor = multiTextCursor();
            QTextCursor c = startMouseMoveCursor.takeMainCursor();
            if (!startMouseMoveCursor.hasMultipleCursors()
                && !startMouseMoveCursor.hasSelection()) {
                startMouseMoveCursor.emplace(MultiTextCursor());
            }

            c.setPosition(c.anchor());
            startMouseMoveCursor.addCursor(c);
        }
        MultiTextCursor cursor = startMouseMoveCursor;
        const QTextCursor anchorCursor = cursor.takeMainCursor();
        const QTextCursor eventCursor = cursorForPosition(e->pos());
        int eventColumn = eventCursor.columnNumber();
        int anchorColumn = anchorCursor.columnNumber();
        const BlockSelection blockSelection =
        {eventCursor.blockNumber(),  eventColumn,  anchorCursor.blockNumber(),    anchorColumn};

        cursor.setCursors(generateCursorsForBlockSelection(blockSelection));

        if (!cursor.isNull()) setMultiTextCursor(cursor);
    } else {
        if (startMouseMoveCursor1)
            startMouseMoveCursor1=false;
        if (e->buttons() == Qt::NoButton) {
            //printf("Kick ma mama keine knoepfe\n");
            /*
            const QTextBlock collapsedBlock = d->foldedBlockAt(e->pos());
            const int blockNumber = collapsedBlock.next().blockNumber();
            if (blockNumber < 0) {
                d->clearVisibleFoldedBlock();
            } else if (blockNumber != d->visibleFoldedBlockNumber) {
                d->suggestedVisibleFoldedBlockNumber = blockNumber;
                d->foldedBlockTimer.start(40, this);
            }

            const RefactorMarker refactorMarker = d->m_refactorOverlay->markerAt(e->pos());

            // Update the mouse cursor
            if ((collapsedBlock.isValid() || refactorMarker.isValid())
                && !d->m_mouseOnFoldedMarker) {
                d->m_mouseOnFoldedMarker = true;
                viewport()->setCursor(Qt::PointingHandCursor);
            } else if (!collapsedBlock.isValid() && !refactorMarker.isValid()
                       && d->m_mouseOnFoldedMarker) {
                d->m_mouseOnFoldedMarker = false;
                viewport()->setCursor(Qt::IBeamCursor);
            }
            */
        } else {
            QPlainTextEdit::mouseMoveEvent(e);
        }
    }

    if (viewport()->cursor().shape() == Qt::BlankCursor)
        viewport()->setCursor(Qt::IBeamCursor);
}
/*
static bool handleForwardBackwardMouseButtons(QMouseEvent *e)
{
    if (e->button() == Qt::XButton1) {
        EditorManager::goBackInNavigationHistory();
        return true;
    }
    if (e->button() == Qt::XButton2) {
        EditorManager::goForwardInNavigationHistory();
        return true;
    }

    return false;
}
*/
void CodeEditor::mousePressEvent(QMouseEvent *e){
    if (e->button() == Qt::LeftButton) {
        MultiTextCursor multiCursor = multiTextCursor();
        const QTextCursor &cursor = cursorForPosition(e->pos());
        if (e->modifiers() & Qt::AltModifier && !(e->modifiers() & Qt::ControlModifier)) {
            if (e->modifiers() & Qt::ShiftModifier) {
                QTextCursor c = multiCursor.mainCursor();
                c.setPosition(cursor.position(), QTextCursor::KeepAnchor);
                multiCursor.replaceMainCursor(c);
                //printf("replaceMainCursor\n");
            } else {
                multiCursor.addCursor(cursor);
                //printf("addCursor %d %d %d %d\n",cursor.isNull(),m_cursors.isNull(), m_cursors.hasMultipleCursors(),m_cursors.cursorCount());
            }
            setMultiTextCursor(multiCursor);
            return;
        } else {
            //printf("was multi? %d\n",m_cursors.hasMultipleCursors());
            if (multiCursor.hasMultipleCursors()) setMultiTextCursor(MultiTextCursor(cursor));
            //printf(" is multi? %d\n",m_cursors.hasMultipleCursors());
/*
            RefactorMarker refactorMarker = d->m_refactorOverlay->markerAt(e->pos());
            if (refactorMarker.isValid()) {
                if (refactorMarker.callback)
                    refactorMarker.callback(this);
            } else {
                d->m_linkPressed = d->isMouseNavigationEvent(e);
            }*/
        }
    } else if (e->button() == Qt::RightButton) {
        int eventCursorPosition = cursorForPosition(e->pos()).position();
        if (eventCursorPosition < textCursor().selectionStart()
                || eventCursorPosition > textCursor().selectionEnd()) {
            setTextCursor(cursorForPosition(e->pos()));
        }
    }

    /*if (HostOsInfo::isLinuxHost() && handleForwardBackwardMouseButtons(e))
        return;*/

    QPlainTextEdit::mousePressEvent(e);
}

QList<QTextCursor> CodeEditor::generateCursorsForBlockSelection(const BlockSelection &blockSelection){
    //const TabSettings tabSettings = m_document->tabSettings();
/*printf("%d %d %d %d\n",
       blockSelection.column,
       blockSelection.blockNumber,
       blockSelection.anchorColumn,
       blockSelection.anchorBlockNumber);*/
    QList<QTextCursor> result;
    QTextBlock block = document()->findBlockByNumber(blockSelection.anchorBlockNumber);
    QTextCursor cursor(block);
    cursor.setPosition(block.position()+blockSelection.anchorColumn);//check this?

    const bool forward = blockSelection.blockNumber > blockSelection.anchorBlockNumber
                         || (blockSelection.blockNumber == blockSelection.anchorBlockNumber
                             && blockSelection.column == blockSelection.anchorColumn);

    while (block.isValid()) {
        const QString &blockText = block.text();
        const int columnCount = blockText.length();
        if (blockSelection.anchorColumn <= columnCount || blockSelection.column <= columnCount) {             
            const int anchor =  blockSelection.anchorColumn;
            const int position =  blockSelection.column;
            cursor.setPosition(block.position() + anchor);
            cursor.setPosition(block.position() + position, QTextCursor::KeepAnchor);
            result.append(cursor);
        }
        /*else {
            const int anchor =  blockSelection.anchorColumn;
            const int position =  blockSelection.column;
            cursor.setPosition(block.position() + columnCount);
            int ee=qMax(anchor,position)-columnCount-1;
            for (int j=0; j<ee; j++)cursor.insertText(" ");
            cursor.setPosition(block.position() + anchor);
            cursor.setPosition(block.position() + position, QTextCursor::KeepAnchor);
//            printf("eng %d %d %d null?%d %d %d\n",columnCount,blockSelection.anchorColumn,blockSelection.column,
                   cursor.isNull(),cursor.blockNumber(),cursor.columnNumber());

            result.append(cursor);
        }*/
        if (block.blockNumber() == blockSelection.blockNumber)
            break;
        block = forward ? block.next() : block.previous();

    }
    return result;
}

void CodeEditor::initBlockSelection(){
    //const TabSettings tabSettings = m_document->tabSettings();
    //for (const QTextCursor &cursor : m_cursors) {
    //printf("initBlockSelection %d %d\n",m_cursors.m_cursors.size(),m_cursors.cursorCount());
    for (int i=0;  i<m_cursors.m_cursors.size(); i++){
        const int column = m_cursors.m_cursors[i].columnNumber();
        QTextCursor anchor = m_cursors.m_cursors[i];
        anchor.setPosition(anchor.anchor());
        const int anchorColumn = anchor.columnNumber();
        BlockSelection bs;
        bs.column=column;
        bs.blockNumber=m_cursors.m_cursors[i].blockNumber();
        bs.anchorColumn=anchorColumn;
        bs.anchorBlockNumber=anchor.blockNumber();
        m_blockSelections.append(bs);
    }
}

void CodeEditor::clearBlockSelection(){
    m_blockSelections.clear();
}

void CodeEditor::handleMoveBlockSelection(QTextCursor::MoveOperation op){
    //printf("!!handleMoveBlockSelection leer?%d size=%d\n",m_blockSelections.isEmpty(),m_blockSelections.size());
    if (m_blockSelections.isEmpty())
        initBlockSelection();
    QList<QTextCursor> cursors;
    for (int i=0; i<m_blockSelections.size(); i++) {    //m_blockSelections[i]
        switch (op) {
        case QTextCursor::Up:
            m_blockSelections[i].blockNumber = qMax(0, m_blockSelections[i].blockNumber - 1);
            break;
        case QTextCursor::Down:
            m_blockSelections[i].blockNumber = qMin(document()->blockCount() - 1,  m_blockSelections[i].blockNumber + 1);
            break;
        case QTextCursor::NextCharacter:
            ++m_blockSelections[i].column;
            break;
        case QTextCursor::PreviousCharacter:
            m_blockSelections[i].column = qMax(0, m_blockSelections[i].column - 1);
            break;
        default:
            return;
        }
        cursors.append(generateCursorsForBlockSelection(m_blockSelections[i]));
    }
    setMultiTextCursor(MultiTextCursor(cursors));
}

void CodeEditor::timerEvent(QTimerEvent *e){
    if (m_cursors.m_cursors.size()<2)return;
    if (e->timerId() == m_cursorFlashTimer.timerId()) {
        m_cursorVisible = !m_cursorVisible;
        QRect updateRect = cursorUpdateRect(m_cursors);
        //printf("updateRect %d %d %d %d\n",updateRect.topLeft().x(),updateRect.topLeft().y(),updateRect.bottomRight().x(),updateRect.bottomRight().y());
        viewport()->update(updateRect);
    }    
   else {
        printf("other event? %d\n",e->timerId());
        QPlainTextEdit::timerEvent(e);
    }
}


void CodeEditor::paintCursor(const PaintEventData &data, QPainter &painter) const{    
    bool multi=data.cursors.size()>1;
    if (!multi) return;
    int cw = QPlainTextEdit::cursorWidth();    
    for (int i=0; i< data.cursors.size();i++) {
        QPen pen(QColor("#4284ff"));//Qt::red);//data.cursors.at(i).pen);
        pen.setStyle(Qt::SolidLine);
        painter.setPen(pen);
        QBrush brush(QColor("#4284ff"));
        painter.setBrush(brush);        
        data.cursors.at(i).layout->drawCursor(&painter, data.cursors.at(i).offset, data.cursors.at(i).pos, cw);
    }    
}

bool CodeEditor::blockContainsCursor(const PaintEventBlockData &blockData, const QTextCursor &cursor){
    const int pos = cursor.position();
    return pos >= blockData.position && pos < blockData.position + blockData.length;
}

CodeEditor::CursorData CodeEditor::generateCursorData(const int cursorPos,
                                     const PaintEventData &data,
                                     const PaintEventBlockData &blockData,
                                     QPainter &painter){
    CursorData cursorData;
    cursorData.layout = blockData.layout;
    cursorData.offset = data.offset;
    cursorData.pos = cursorPos;
    cursorData.pen = painter.pen();
    return cursorData;
}

void CodeEditor::addCursorsPosition(PaintEventData &data,
                                                 QPainter &painter,
                                                 const PaintEventBlockData &blockData) const{
    for (int i=0; i<m_cursors.m_cursors.size(); i++){
            if (blockContainsCursor(blockData, m_cursors.m_cursors[i])) {
                data.cursors.append(
                    generateCursorData(m_cursors.m_cursors[i].positionInBlock(), data, blockData, painter));
            }
        }

}

void CodeEditor::paintEvent(QPaintEvent *e){
    //if ((m_cursors.m_cursors.size()>1)&&((e->rect().width() - fontMetrics().width('9'))<6)&&((e->rect().height() - fontMetrics().height())<3)) {e->accept();return;}
    /*printf("i need to paint %d %d \n",
           e->rect().width() - fontMetrics().width('_'),
           e->rect().height() - fontMetrics().height());*/
    PaintEventData data(this, e, contentOffset());
    //QTC_ASSERT(data.documentLayout, return);


    QPlainTextEdit::paintEvent(e);

    QPainter painter(viewport());
    // Set a brush origin so that the WaveUnderline knows where the wave started
    painter.setBrushOrigin(data.offset);

    data.block = firstVisibleBlock();
    data.context = getPaintContext();
    //const QTextCharFormat textFormat = textDocument()->fontSettings().toTextCharFormat(C_TEXT);
    //data.context.palette.setBrush(QPalette::Text, textFormat.foreground());
    //data.context.palette.setBrush(QPalette::Base, textFormat.background());

    while (data.block.isValid()) {

        PaintEventBlockData blockData;
        blockData.boundingRect = blockBoundingRect(data.block).translated(data.offset);

        if (blockData.boundingRect.bottom() >= data.eventRect.top()
                && blockData.boundingRect.top() <= data.eventRect.bottom()) {

            setupBlockLayout(data, painter, blockData);
            blockData.position = data.block.position();
            blockData.length = data.block.length();
            setupSelections(data, blockData);

            //d->paintCurrentLineHighlight(data, painter);

            bool drawCursor = false;
            bool drawCursorAsBlock = false;
            //if (d->m_dndCursor.isNull()) {
            bool anyof=false;
            for (int i=0; i<m_cursors.m_cursors.size(); i++){
                if (blockContainsCursor(blockData,m_cursors.m_cursors[i])) {anyof=true;break;}
            }
                drawCursor = m_cursorVisible && anyof;
                drawCursorAsBlock = drawCursor && overwriteMode();
            /*} else {
                drawCursor = blockContainsCursor(blockData, d->m_dndCursor);
            }*/
/*
            if (drawCursorAsBlock) {
                MultiTextCursor mc= multiTextCursor();
                for (int i=0; i<mc.m_cursors.size(); i++){
                    if (blockContainsCursor(blockData, mc.m_cursors[i]))
                        paintCursorAsBlock(data, painter, blockData, mc.m_cursors.at(i).position());
                }
            }*/

            //paintBlock(&painter, data.block, data.offset, blockData.selections, data.eventRect);

            if (data.isEditable && data.context.cursorPosition < -1
                && !blockData.layout->preeditAreaText().isEmpty()) {
                const int cursorPos = blockData.layout->preeditAreaPosition()
                                           - (data.context.cursorPosition + 2);
                data.cursors.append(generateCursorData(cursorPos, data, blockData, painter));
            }

            if (drawCursor && !drawCursorAsBlock) addCursorsPosition(data, painter, blockData);

            //d->paintAdditionalVisualWhitespaces(data, painter, blockData.boundingRect.top());
            //d->paintReplacement(data, painter, blockData.boundingRect.top());
        }
        //d->updateLineAnnotation(data, blockData, painter);

        data.offset.ry() += blockData.boundingRect.height();

        if (data.offset.y() > data.viewportRect.height())
            break;

        data.block = data.block.next();

        /*if (!data.block.isVisible()) {
            if (data.block.blockNumber() == d->visibleFoldedBlockNumber) {
                data.visibleCollapsedBlock = data.block;
                data.visibleCollapsedBlockOffset = data.offset;
            }

            // invisible blocks do have zero line count
            data.block = data.doc->findBlockByLineNumber(data.block.firstLineNumber());
        }*/
    }

    //d->cleanupAnnotationCache();

    painter.setPen(data.context.palette.text().color());


    // draw the cursor last, on top of everything
    paintCursor(data, painter);
    //printf("paintEvent font size: %dpt\n",font().pointSize());

}

void CodeEditor::setupBlockLayout(const PaintEventData &data,
                                               QPainter &painter,
                                               PaintEventBlockData &blockData) const

{
    blockData.layout = data.block.layout();

    QTextOption option = blockData.layout->textOption();
    option.setFlags(option.flags() & ~QTextOption::SuppressColors);
    painter.setPen(data.context.palette.text().color());
    blockData.layout->setTextOption(option);
    blockData.layout->setFont(data.doc->defaultFont());
}

void CodeEditor::setupSelections(const PaintEventData &data,
                                              PaintEventBlockData &blockData) const
{
    QVector<QTextLayout::FormatRange> prioritySelections;
    for (int i = 0; i < data.context.selections.size(); ++i) {
        const QAbstractTextDocumentLayout::Selection &range = data.context.selections.at(i);
        const int selStart = range.cursor.selectionStart() - blockData.position;
        const int selEnd = range.cursor.selectionEnd() - blockData.position;
        if (selStart < blockData.length && selEnd >= 0
            && selEnd >= selStart) {
            QTextLayout::FormatRange o;
            o.start = selStart;
            o.length = selEnd - selStart;
            o.format = range.format;
            if (data.textCursor.hasSelection() && data.textCursor == range.cursor
                && data.textCursor.anchor() == range.cursor.anchor()) {
                /*const QTextCharFormat selectionFormat = data.fontSettings.toTextCharFormat(C_SELECTION);
                if (selectionFormat.background().style() != Qt::NoBrush)
                    o.format.setBackground(selectionFormat.background());
                o.format.setForeground(selectionFormat.foreground());
                */
            }
            if ((data.textCursor.hasSelection() && i == data.context.selections.size() - 1)
                || (o.format.foreground().style() == Qt::NoBrush
                && o.format.underlineStyle() != QTextCharFormat::NoUnderline
                && o.format.background() == Qt::NoBrush)) {
                //if (q->selectionVisible(data.block.blockNumber())) prioritySelections.append(o);
            } else {
                blockData.selections.append(o);
            }
        }
    }
    //blockData.selections.append(prioritySelections);
}

void CodeEditor::slotCursorPositionChanged(){
#if 0
    qDebug() << "block" << textCursor().blockNumber()+1
            << "brace depth:" << BaseTextDocumentLayout::braceDepth(textCursor().block())
            << "indent:" << BaseTextDocumentLayout::userData(textCursor().block())->foldingIndent();
#endif
    /*if (!d->m_contentsChanged && d->m_lastCursorChangeWasInteresting) {
        if (EditorManager::currentEditor() && EditorManager::currentEditor()->widget() == this)
            EditorManager::addCurrentPositionToNavigationHistory(d->m_tempNavigationState);
        d->m_lastCursorChangeWasInteresting = false;
    } else if (d->m_contentsChanged) {
        d->saveCurrentCursorPositionForNavigation();
        if (EditorManager::currentEditor() && EditorManager::currentEditor()->widget() == this)
            EditorManager::setLastEditLocation(EditorManager::currentEditor());
    }*/
    MultiTextCursor cursor = multiTextCursor();
    cursor.replaceMainCursor(textCursor());
    setMultiTextCursor(cursor);
    updateCursorSelections();
    //d->updateHighlights();
}


void CodeEditor::updateCursorPosition(){
    if (!textCursor().block().isVisible()) ensureCursorVisible();
}

void CodeEditor::mpaste(){
    if (m_cursors.hasMultipleCursors()){
        QClipboard *clipboard = QApplication::clipboard();
        m_cursors.insertText(clipboard->text());
    }else QPlainTextEdit::paste();
}

void CodeEditor::mcut(){
    MultiTextCursor cursor = multiTextCursor();
    QString str=cursor.selectedText();
    cursor.removeSelectedText();
    setMultiTextCursor(cursor);
    QClipboard *clipboard = QApplication::clipboard();
    clipboard->setText(str);
    QPlainTextEdit::copy();
/*    if (m_cursors.hasMultipleCursors()){

    }*/
}

void CodeEditor::testCpd(){
	/*
    QClipboard *clipboard = QApplication::clipboard();
	const QMimeData *mmd=clipboard->mimeData();
	printf("MIMEDATA:%d %d\n",mmd->hasText(),mmd->hasUrls());
	qDebug()<<mmd->formats();
    printf(" %d %d            CLIP: \n%s\n :BOARD\n",
	m_cursors.hasSelection(),
	textCursor().hasSelection(),
	clipboard->text().toStdString().c_str());*/
    if ((m_cursors.hasMultipleCursors())&&(m_cursors.hasSelection())){
        QClipboard *clipboard = QApplication::clipboard();
//        printf("Clip: \n%s=>\n",clipboard->text().toStdString().c_str());
        QString str=m_cursors.selectedText();
        m_cursors.clearSelection();
        printf("   MCOPY\n");
        clipboard->setText(str);
        printf("!%s!\n",clipboard->text().toLatin1().data());

    }
}

void CodeEditor::insertElectronSFACs(){
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    cursor.beginEditBlock ();
    replace->setText("");
    searchLE->setText("^SFAC");
    bool wl=wholeLine->isChecked();
    wholeLine->setChecked(true);
    replaceAll();
    replace->setText("");
    searchLE->setText("");
    wholeLine->setChecked(wl);
    //for (int i=0; i<easf.size(); i++){printf("%s",easf.at(i).toStdString().c_str());}//\n are already in the strings
    if (cursor.isNull()){
        cursor = textCursor();
        //printf("war null\n");
    }
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    cursor = document->find(unitinst,cursor);
    if (cursor.isNull()){
        cursor = textCursor();
        //printf("war schon wieder null\n");
        cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    }
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    for (int i=0; i<sfacsmbl.size(); i++){
        int idx= easf.indexOf(QRegularExpression(QString("^SFAC %1 .*\n").arg(sfacsmbl.at(i)), QRegularExpression::CaseInsensitiveOption));
        //printf("searching %d %s\n",idx,QString("SFAC %1 .*").arg(sfacsmbl.at(i)).toStdString().c_str());
        if (idx!=-1) cursor.insertText(DSRGui::textWrap(easf.at(idx)));
    }
    cursor.insertText(
    "REM source:\nREM for neutral atoms:\nREM Electron atomic scattering factors and scattering potentials of crystals\n"
    "REM L.-M. Peng, Micron 30 (1999) 625–648.\n"
    "REM for ions:\nREM International Tables for Crystallography Vol C Table 4.3.1.2\n"
    "REM (gnuplot fit of Cromer-Mann parameters inspired by Tim Gruene))\n");
    cursor.endEditBlock();
}

void CodeEditor::handleCBstates(int state){
    QCheckBox *cb = qobject_cast<QCheckBox *>(sender());
    if ((cb)&&(cbhandled)) {
        printf("%s ->%d\n",cb->objectName().toStdString().c_str(),state);
        QStringList anl = cb->objectName().split(' ');
        QList<QCheckBox *> cbs = cb->parent()->findChildren<QCheckBox *>();
        cbhandled=false;
        for (int i=0; i<cbs.size(); i++){
            if (cbs.at(i)->objectName().startsWith(anl.at(0)+" "))
                cbs[i]->setCheckState(static_cast<Qt::CheckState>((cbs.at(i)!=cb)?Qt::Checked-state:state));
        }
        cbhandled=true;
    }
}

double CodeEditor::cromerMann(double sintl, double a1, double b1,  double a2,  double b2, double a3, double b3, double a4, double b4, double c){
    double stl2=sintl*sintl;
    return a1 * exp(-b1 * stl2) +a2 * exp(-b2 * stl2) +a3 * exp(-b3 * stl2) + a4 * exp(-b4 * stl2) + c;
}

void CodeEditor::plotSFAC(){
    QGraphicsScene *scene = new QGraphicsScene(-25,-25,870,650);
    scene->setBackgroundBrush(QBrush(QColor("#e9f7d6")));
    QDialog *dlg = new QDialog();
    dlg->setObjectName("plotSFAC()");
    QGraphicsView *gv = new QGraphicsView(scene,dlg);
    QGridLayout *glo = new QGridLayout(dlg);
    int maxan=0;
    for (int k=0;k<sfac.size(); k++){
        int an = sfac.at(k)+1;
        maxan = qMax(maxan,an);
    }
    maxan++;
    int l=0;
    int pan=-1;
    printf("sintl min %f max %f %f %f\n",smin,smax,0.5/smin,0.5/smax);
    double maxsintl=(smax)?smax:2.0;
    for (int j=0; j<xasf.size(); j++){
        for (int k=0;k<sfac.size(); k++){
            int an = sfac.at(k)+1;
            maxan =qMax(maxan,an);
            QStringList tok = xasf.at(j).split(" ",skipEmptyParts);
            if (tok.size()<12) continue;
            if (tok.at(0).toInt()!=an) continue;
            CheckBox *cb = new CheckBox(scene, xasf.at(j).section('!',1), dlg);
            cb->setChecked(an!=pan);
            QString on=QString("%1 %2").arg(an).arg(j);
            cb->setObjectName(on);
            connect(cb,SIGNAL(stateChanged(int)),this,SLOT(handleCBstates(int)));
            glo->addWidget(cb, l, 1, Qt::AlignBottom);
            pan=an;

            QGraphicsSimpleTextItem *t = scene->addSimpleText(xasf.at(j).section('!',1));
            t->moveBy(750,l*QFontMetrics(t->font()).height());
            t->setPen(QPen(chgl->mol->atomColor(an-1,true)));
            double a1 = tok.at(3).toDouble() ;
            double b1 = tok.at(4).toDouble() ;
            double a2 = tok.at(5).toDouble() ;
            double b2 = tok.at(6).toDouble() ;
            double a3 = tok.at(7).toDouble() ;
            double b3 = tok.at(8).toDouble() ;
            double a4 = tok.at(9).toDouble() ;
            double b4 = tok.at(10).toDouble() ;
            double c  = tok.at(11).toDouble() ;
            //printf("%f %f %f %f %f %f %f %f %f\n",a1,b1,a2,b2,a3,b3,a4,b4,c);

            for (int i=0; i<80; i++){
                double s1=i/80.0*maxsintl;
                double s2=(i+1)/80.0*maxsintl;
                double y1=600.0-600.0/maxan*cromerMann(s1,a1,b1,a2,b2,a3,b3,a4,b4,c);
                double y2=600.0-600.0/maxan*cromerMann(s2,a1,b1,a2,b2,a3,b3,a4,b4,c);
                QGraphicsLineItem *lit = scene->addLine(i*10,y1,(i+1)*10,y2,QPen(chgl->mol->atomColor(an-1,true)));
                lit->setData(0,on);
            }

            l++;
        }
    }
    for (int i=0; i<=maxan; i++)scene->addLine(-7.0,600.0-600.0/maxan*i,0.0,600.0-600.0/maxan*i,QPen(Qt::black));
    for (int i=0; i<=maxan; i++){
        QGraphicsSimpleTextItem *t = scene->addSimpleText(QString::number(i));
        t->moveBy(-15.0,600.0-600.0/maxan*i);
        //t->setPen(QPen(chgl->mol->atomColor(an-1,true)));
    }
    for (int i=0; i<=10; i++)scene->addLine(80*i,607.0,80*i,600.0,QPen(Qt::black));
    for (int i=0; i<=10; i++){
        double s1=i/10.0*maxsintl;
        double d1=0.5/s1;
        QGraphicsSimpleTextItem *t = scene->addSimpleText(QString("%1Å").arg(d1,0,'g',3));
        t->moveBy(80*i,610);
    }
    scene->addLine(0.0,600.0,800.0,600.0,QPen(Qt::black));
    scene->addLine(0.0,0.0,0.0,600.0,QPen(Qt::black));
    scene->addLine(smin*800.0/maxsintl,-20.0,smin*800.0/maxsintl,620.0,QPen(Qt::blue));
    QGraphicsSimpleTextItem *t = scene->addSimpleText(QString("%1Å").arg(0.5/smin,0,'g',3));
    t->moveBy(smin*800.0/maxsintl,625);
    t->setPen(QPen(Qt::blue));
    QDialogButtonBox *bb = new QDialogButtonBox(QDialogButtonBox::Cancel,Qt::Vertical);
    bb->addButton(new QPushButton("Replace SFAC instructions",dlg),QDialogButtonBox::AcceptRole);
    glo->addWidget(gv,0,0,l,1);
    glo->addWidget(bb,0,3,1,1);
    connect(bb, SIGNAL(accepted()), dlg, SLOT(accept()));
    connect(bb, SIGNAL(rejected()), dlg, SLOT(reject()));
    connect(dlg,SIGNAL(accepted ()),this,SLOT(insertXRaySFACs()));
    dlg->exec();

}

void CodeEditor::insertXRaySFACs(){
    QString sdr=sender()->objectName();
    QList<QCheckBox *> cbs = sender()->findChildren<QCheckBox *>();
    //printf("insertXRaySFACs {%s}%lld\n",sdr.toStdString().c_str(),cbs.size());
    QTextDocument *document = this->document();
    QTextCursor cursor = textCursor();
    cursor.beginEditBlock ();
    replace->setText("");
    searchLE->setText("^SFAC");
    bool wl=wholeLine->isChecked();
    wholeLine->setChecked(true);
    replaceAll();
    replace->setText("");
    searchLE->setText("");
    wholeLine->setChecked(wl);
    /*for (int i=0; i<easf.size(); i++){
        printf("%s\n",easf.at(i).toStdString().c_str());
    }*/
    if (cursor.isNull()){
        cursor = textCursor();
        //printf("war null\n");
    }
    cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    cursor = document->find(unitinst,cursor);
    if (cursor.isNull()){
        cursor = textCursor();
        //printf("war schon wieder null\n");
        cursor.movePosition(QTextCursor::Start,QTextCursor::MoveAnchor);
    }
    cursor.movePosition(QTextCursor::StartOfLine,QTextCursor::MoveAnchor);
    for (int k=0; k<sfac.size();k++){
    for (int i=0; i<cbs.size(); i++){
        if (cbs.at(i)->isChecked()){
            QStringList anl = cbs.at(i)->objectName().split(' ');
            if (anl.at(0).toInt()-1 != sfac.at(k)) continue;
            //printf("%d <> %lld \n",anl.at(0).toInt(),anl.size());
            if (anl.size()==2){
                int idx = anl.at(1).toInt();
                //printf("searching %d %s\n",idx,QString("SFAC %1 .*").arg(sfacsmbl.at(i)).toStdString().c_str());
                QString sfacstr=xasf.at(idx).section(' ',1).simplified();
                sfacstr=sfacstr.replace("fp fdp mu",dispFromWave(anl.at(0).toInt()-1)).simplified();
                sfacstr=DSRGui::textWrap(sfacstr);
                sfacstr.append("\n");
                cursor.insertText(sfacstr);
            }
    }
        /*
    cursor.insertText(
    "REM source:\nREM for neutral atoms:\nREM Electron atomic scattering factors and scattering potentials of crystals\n"
    "REM L.-M. Peng, Micron 30 (1999) 625–648.\n"
    "REM for ions:\nREM International Tables for Crystallography Vol C Table 4.3.1.2\n"
    "REM (gnuplot fit of Cromer-Mann parameters inspired by Tim Gruene))\n");
    */
    }//i
    }//k
    cursor.endEditBlock();
}

void CheckBox::hoverEnter(QHoverEvent *event){
    event->accept();
    QList<QGraphicsItem *> itms =  scene->items();
    for (int i=0; i<itms.size(); i++){
        if (itms.at(i)->data(0)==objectName()){
            QPen p=static_cast<QGraphicsLineItem*>(itms[i])->pen();
            p.setWidth(2);
            static_cast<QGraphicsLineItem*>(itms[i])->setPen(p);
        } else if (itms.at(i)->data(0).isValid()){
            QPen p=static_cast<QGraphicsLineItem*>(itms[i])->pen();
            p.setWidth(1);
            static_cast<QGraphicsLineItem*>(itms[i])->setPen(p);
        }
    }
}

void CheckBox::hoverLeave(QHoverEvent *event){
    event->accept();
    QList<QGraphicsItem *> itms =  scene->items();
    for (int i=0; i<itms.size(); i++){

        if (itms.at(i)->data(0)==objectName()){
            QPen p=static_cast<QGraphicsLineItem*>(itms[i])->pen();
            p.setWidth(1);
            static_cast<QGraphicsLineItem*>(itms[i])->setPen(p);
        }else  if (itms.at(i)->data(0).isValid()){
            QPen p=static_cast<QGraphicsLineItem*>(itms[i])->pen();
            p.setWidth(1);
            static_cast<QGraphicsLineItem*>(itms[i])->setPen(p);
        }
    }

}

void CheckBox::hoverMove(QHoverEvent *event){
event->ignore();
}

CheckBox::CheckBox(QGraphicsScene * _scene, const QString & _text, QWidget * _parent ) : QCheckBox(_text,_parent), scene(_scene){
}
