/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsplittabledelegate.h"

#include <KSqueezedTextLabel>

#include <QPainter>

#include "skgcombobox.h"
#include "skgcalculatoredit.h"
#include "skgmainpanel.h"
#include "skgdateedit.h"

SKGSplitTableDelegate::SKGSplitTableDelegate(QObject* iParent, SKGDocument* iDoc, const QStringList& iListAttribut) : QItemDelegate(iParent), m_document(iDoc), m_listAttributes(iListAttribut) {}

SKGSplitTableDelegate::~SKGSplitTableDelegate()
{
    m_document = NULL;
}

QWidget* SKGSplitTableDelegate::createEditor(QWidget* iParent,
        const QStyleOptionViewItem& option ,
        const QModelIndex& index) const
{
    if (index.column() == m_listAttributes.indexOf("t_category")) {
        SKGComboBox* editor = new SKGComboBox(iParent);
        editor->setEditable(true);
        if (m_document) {
            SKGMainPanel::fillWithDistinctValue(editor, m_document, "category", "t_fullname", "");
        }

        return editor;
    } else if (index.column() == m_listAttributes.indexOf("t_comment")) {
        SKGComboBox* editor = new SKGComboBox(iParent);
        editor->setEditable(true);
        if (m_document) {
            SKGMainPanel::fillWithDistinctValue(editor, m_document, "v_operation_all_comment", "t_comment", "");
        }

        return editor;
    } else if (index.column() == m_listAttributes.indexOf("f_value")) {
        SKGCalculatorEdit* editor = new SKGCalculatorEdit(iParent);
        editor->setMode(SKGCalculatorEdit::EXPRESSION);
        QMapIterator<QString, double> i(m_parameters);
        while (i.hasNext()) {
            i.next();
            editor->addParameterValue(i.key(), i.value());
        }

        return editor;
    } else if (index.column() == m_listAttributes.indexOf("t_refund")) {
        SKGComboBox* editor = new SKGComboBox(iParent);
        editor->setEditable(true);
        if (m_document) {
            SKGMainPanel::fillWithDistinctValue(editor, m_document, "refund", "t_name", "t_close='N'");
        }

        return editor;
    }  else if (index.column() == m_listAttributes.indexOf("d_date")) {
        SKGDateEdit* editor = new SKGDateEdit(iParent);

        return editor;
    }

    return QItemDelegate::createEditor(iParent, option , index);
}

void SKGSplitTableDelegate::setEditorData(QWidget* editor, const QModelIndex& index) const
{
    if (index.column() == m_listAttributes.indexOf("f_value")) {
        SKGCalculatorEdit* calculator = static_cast<SKGCalculatorEdit*>(editor);
        if (calculator) {
            calculator->setText(index.model()->data(index, Qt::ToolTipRole).toString());
        }
    } else if (index.column() == m_listAttributes.indexOf("d_date")) {
        SKGDateEdit* date = static_cast<SKGDateEdit*>(editor);
        if (date) {
            date->setDate(SKGServices::stringToTime(index.model()->data(index, Qt::ToolTipRole).toString()).date());
        }
    } else {
        QItemDelegate::setEditorData(editor, index);
    }
}

void SKGSplitTableDelegate::setModelData(QWidget* editor, QAbstractItemModel* model, const QModelIndex& index) const
{
    if (index.column() == m_listAttributes.indexOf("f_value")) {
        SKGCalculatorEdit* calculator = static_cast<SKGCalculatorEdit*>(editor);
        if (calculator && model) {
            QString f = calculator->formula();
            QString t = SKGServices::doubleToString(calculator->value());
            if (f.isEmpty()) {
                f = t;
            }
            model->setData(index, f, Qt::ToolTipRole);
            model->setData(index, t, Qt::DisplayRole);
        }
    } else if (index.column() == m_listAttributes.indexOf("d_date")) {
        SKGDateEdit* date = static_cast<SKGDateEdit*>(editor);
        if (date && model) {
            QString d = SKGServices::dateToSqlString(date->date());
            model->setData(index, d, Qt::ToolTipRole);
            model->setData(index, d, Qt::DisplayRole);
        }
    } else {
        QItemDelegate::setModelData(editor, model, index);
    }
}

void SKGSplitTableDelegate::addParameterValue(const QString& iParameter, double iValue)
{
    m_parameters.insert(iParameter, iValue);
}
#include "skgsplittabledelegate.moc"
