/*
 * Oidsec.C: implementaiton of the OID sequence class
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later 
 * version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 */

#include <stdarg.h>
#include <string.h>
#include <stdio.h>

#include "snmpkit"

#include "oidseq.h"

/* its4: ignore */
void OidSeq::remove(const std::string &oidstr)
  throw(OidSeqRemoveNotFoundException,OidSeqBadLayoutException){
  BerOid standard(oidstr);
  for(BerSequence::ElementContainer::iterator i=seq->begin();
      i!=seq->end();i++){
    BerSequence *s=dynamic_cast<BerSequence*>(*i);
    if(s==NULL) throw OidSeqBadLayoutException();
    BerOid *testcase=dynamic_cast<BerOid*>(*s->begin()); 
    if(testcase==NULL) throw OidSeqBadLayoutException();
    if(*testcase==standard){
      delete(seq->extract(i));
      return;
    }
  }
  throw OidSeqRemoveNotFoundException();
}

void OidSeq::append(const std::string &oidstr)
  throw(std::bad_alloc,BerOidBadSubOidException,BerNoOidsException){
  BerSequence *newone=new BerSequence(SEQUENCE_TAG);
  newone->append(new BerOid(oidstr));
  newone->append(new BerNull());
  seq->append(newone);
}

void OidSeq::append(const std::string &oidstr, Tags type, void *data,
		    unsigned int len)
  throw(std::bad_alloc,BerOidBadSubOidException,BerNoOidsException,
	BerIPAddrLengthExecption){
  BerSequence *newone=new BerSequence(SEQUENCE_TAG);
  newone->append(new BerOid(oidstr));
  switch(type){
  case STRING_TAG:
    newone->append(new BerString(reinterpret_cast<char*>(data),len));
    break;
  case OID_TAG:
    newone->append(new BerOid(std::string(reinterpret_cast<char*>(data),len)));
    break;
  case IPADDR_TAG:
    newone->append(new BerIPAddr(reinterpret_cast<unsigned char*>(data),
				 len));
    break;
  default:
    throw OidSeqTagException(); //bad type passed into append
  }
  seq->append(newone);
}

void OidSeq::append(const std::string &oidstr,long data)
  throw(std::bad_alloc,BerOidBadSubOidException,BerNoOidsException){
  BerSequence *newone=new BerSequence(SEQUENCE_TAG);
  newone->append(new BerOid(oidstr));
  newone->append(new BerInt(data));
  seq->append(newone);
}


void OidSeq::append(const std::string &oidstr,unsigned long data)
  throw(std::bad_alloc,BerOidBadSubOidException,BerNoOidsException){
  BerSequence *newone=new BerSequence(SEQUENCE_TAG);
  newone->append(new BerOid(oidstr));
  newone->append(new BerCounter(data));
  seq->append(newone);
}

BerBase *OidSeq::value(const std::string &oid)throw(OidSeqBadLayoutException){
  for(BerSequence::ElementContainer::iterator i=seq->begin();i!=seq->end();
      i++){
    BerSequence *s=dynamic_cast<BerSequence*>(*i);
    if(s==NULL) throw OidSeqBadLayoutException();
    BerSequence::ElementContainer::iterator curseqit=s->begin();
    BerOid *o=dynamic_cast<BerOid*>(*curseqit);
    if(o==NULL) throw OidSeqBadLayoutException();
    if(*o==BerOid(oid))
      return *(curseqit+1);
  }
  return NULL; // didn't find it.
}


BerBase *OidSeq::child(const std::string &oid) 
  throw(OidSeqBadLayoutException){ 
  for(BerSequence::ElementContainer::iterator i=seq->begin();i!=seq->end();
      i++){
    BerSequence *s=dynamic_cast<BerSequence*>(*i);
    if(s==NULL)
      throw OidSeqBadLayoutException();
    BerSequence::ElementContainer::iterator curseqit=s->begin();
    BerOid *test=dynamic_cast<BerOid*>(*curseqit);
    if(test==NULL)
      throw OidSeqBadLayoutException();
    std::string d1;
    test->ascii_print(d1);
    if(d1==oid)
      return *(curseqit+1);
  }
  return NULL;
}

OidSeq::OidSeq(BerSequence *valseq) throw(OidSeqBadLayoutException):
  seq(valseq){
  for(BerSequence::ElementContainer::iterator i=seq->begin();i!=seq->end();
      i++){
    BerSequence *s=dynamic_cast<BerSequence*>(*i);
    if(s==NULL || s->size()!=2 || dynamic_cast<BerOid*>(*s->begin())==NULL) 
      throw OidSeqBadLayoutException();
  }
}
