3.7 Paquets de samples

# Paquets de samples

**Note: cette section du tutoriel couvre le sujet avancé de
travailler avec des grands dossiers de vos propres samples. Ce sera le
cas si vous avez téléchargé ou acheté vos propre paquets de samples et
souhaitez les utiliser dans Sonic Pi.**

**N'hésitez pas à sauter cette section si vous vous contentez des
samples fournis dans Sonic Pi.**

Quand on travaille avec de grands dossiers de samples externes il
peut être ennuyeux de taper le chemin entier chaque fois qu'on veut
déclencher un sample particulier.

Par exemple, imaginons que vous avez le dossier suivant sur votre
machine :

```
/path/to/my/samples/
```

Quand on regarde dans ce dossier on voit les samples suivants :

* `100_A#_melody1.wav`
* `100_A#_melody2.wav`
* `100_A#_melody3.wav`
* `120_A#_melody4.wav`
* `120_Bb_guit1.wav`
* `120_Bb_piano1.wav`

Typiquement pour jouer le sample de piano on peut utiliser le chemin
complet :

```
sample "/path/to/my/samples/120_Bb_piano1.wav"
```

Si on veut jouer le sample de guitare on peut aussi utiliser son
chemin complet :

```
sample "/path/to/my/samples/120_Bb_guit.wav"
```

Cependant ces deux appels de samples nous forcent à *connaître* le nom
de chacun des samples de notre dossier. Et si on voulait juste écouter
chaque sample à son tour rapidement ?

## Indexer les paquets de samples

Si on veut jouer le premier sample d'un dossier on peut juste passer
le nom du dossier à `sample` et l'index `0` comme suit :

```
sample "/path/to/my/samples/", 0
```

On peut même construire un raccourci vers notre chemin de dossier en
utilisant une variable :

```
samps = "/path/to/my/samples/"
sample samps, 0
```

Maintenant, si on veut jouer le deuxième sample de notre dossier, on
peut juste incrémenter notre index :

```
samps = "/path/to/my/samples/"
sample samps, 1
```

Remarquez qu'on n'a plus besoin de connaître le nom des samples du
dossier : on doit juste connaître le dossier lui-même (ou avoir un
raccourci vers lui). Si on demande un index qui est plus grand que le
nombre de samples, il va juste boucler comme pour les anneaux. Ainsi,
quel que soit le nombre qu'on utilise on a la garantie de récupérer un
des samples de ce dossier.

## Filtrer des paquets de samples

D'habitude indexer suffit, mais parfois on a besoin de plus de
puissance pour trier et organiser nos samples. Heureusement de nombreux
paquets de samples ajoutent des informations utiles dans les noms de
fichiers.  Jetons un autre oeil aux noms de fichier des samples de
notre dossier :

* `100_A#_melody1.wav`
* `100_A#_melody2.wav`
* `100_A#_melody3.wav`
* `120_A#_melody4.wav`
* `120_Bb_guit1.wav`
* `120_Bb_piano1.wav`

Remarquez que dans ces noms de fichier nous avons pas mal
d'informations. On a le BPM du sample (nombre de battements par
minute) au début. Donc le sample de piano est à 120 BPM et nos trois
premières mélodies sont à 100 BPM. Nos noms de samples contiennent
aussi la clef. Donc le sample de guitare est en Bb (si bémol) et les
mélodies sont en A# (la dièse). Cette information est très utile pour
mélanger ces samples avec le reste de notre code. Par exemple, on sait
qu'on ne peut jouer le sample de piano que dans du code qui est à 120
BPM et dans la clef de Bb.

Il se trouve qu'on peut utiliser cette convention de nommage
particulière de nos ensembles de samples dans le code pour nous aider
à ne garder que ceux qu'on veut. Par exemple, si nous travaillons à
120 BPM, on peut ne garder que les samples qui contiennent la chaîne
`"120"` avec le code suivant :

```
samps = "/path/to/my/samples/"
sample samps, "120"
```

Cela jouera le premier sample qui correspond. Si on veut le deuxième,
on n'a qu'à utiliser l'index :

```
samps = "/path/to/my/samples/"
sample samps, "120", 1
```

On peut même utiliser de multiples filtres en même temps. Par exemple,
si on veut un sample dont le nom de fichier contient à la fois les
sous-chaînes "120" et "A#", on peut le trouver facilement avec le code
suivant :

```
samps = "/path/to/my/samples/"
sample samps, "120", "A#"
```

Enfin, on a toujours la possibilité d'ajouter nos options habituelles
lors de l'appel à `sample`:

```
samps = "/path/to/my/samples/"
sample samps, "120", "Bb", 1, lpf: 70, amp: 2
```

## Sources

Le système de pré-argument de filtre de samples comprend deux types
d'information : les sources et les filtres. Les sources sont des
informations utilisées pour créer la liste des candidats potentiels.
Une source peut prendre deux formes :

1. "/path/to/samples" : une chaîne représentant un chemin valide vers un dossier
2. "/path/to/samples/foo.wav" : une chaîne représentant un chemin valide vers un sample

La fonction `sample` va d'abord rassembler toutes les sources et les
utiliser pour créer une grande liste de candidats. Cette liste est
construite en ajoutant d'abord tous les chemins valides et puis en
ajoutant tous les fichiers valides `.flac`, `.aif`, `.aiff`, `.wav`,
et `.wave` contenus dans les dossiers.

Par exemple, regardez le code suivant :

```
samps = "/path/to/my/samples/"
samps2 = "/path/to/my/samples2/"
path = "/path/to/my/samples3/foo.wav"

sample samps, samps2, path, 0
```

Ici nous combinons les contenus des samples de deux dossiers en y
ajoutant un sample en particulier. Si `"/path/to/my/samples/"` contient
trois samples et `"/path/to/my/samples2/"` en contient douze, on
aurait seize samples potentiels à indexer et filtrer (3 + 12 + 1).

Par défaut, seuls les fichiers de samples d'un dossier sont rassemblés
dans la liste de candidats. Parfois vous pourriez avoir un certain
nombre de dossiers imbriqués dans lesquels vous aimeriez chercher et
filtrer. Vous pouvez faire une recherche récursive dans tous les
samples de tous les sous-dossiers d'un dossier en particulier en
ajoutant `**` à la fin du chemin :

```
samps = "/path/to/nested/samples/**"
sample samps, 0
```

Attention parce que chercher dans un très grand ensemble de dossiers
peut prendre beaucoup de temps. Cela dit, le contenu des dossiers
sources est mis en cache, donc le retard n'arrivera que la première
fois.


## Filtres

Une fois qu'on a une liste de candidats on peut utiliser les types de
filtres suivants pour réduire la sélection :

* `"foo"` : les chaînes vont filtrer sur les occurrences de sous-chaîne dans le nom du fichier (moins le chemin du dossier et l'extension)
* `/fo[oO]/` : les expressions régulières filtrent sur des motifs du nom du fichier (moins le chemin du dossier et l'extension)
* `:foo` : les mots-clefs filtrent les candidats si le mot-clef correspond exactement au nom du fichier (moins le chemin du dossier et l'extension)
* `lambda{ "foo" }` : les procédures sans argument seront appelées automatiquement et leur résultat sera traité comme une source ou un filtre
* `lambda{|a| ... }` : les procédures avec un argument seront traitées comme un filtre de candidat ou une fonction génératrice. On lui passera la liste des candidats actuels et elle doit retourner une nouvelle liste de candidats (une liste de chemins valides vers des fichiers de samples)
* `1` : Les nombres sélectionnent le candidat avec cet index (en bouclant comme un anneau si nécessaire)

## Composites

Enfin vous pouvez utiliser des listes partout où on peut placer une
source ou un filtre. La liste sera automatiquement aplatie et son
contenu sera traité comme des sources et filtres. Ainsi les appels
suivants à `sample` sont sémantiquement équivalents :

```
sample "/path/to/dir", "100", "C#"
sample ["/path/to/dir", "100", "C#"]
sample "/path/to/dir", ["100", "C#"]
sample ["/path/to/dir", ["100", ["C#"]]]
```

## Résumé

C'était une section avancée pour les gens qui ont besoin de vraie
puissance pour manipuler et utiliser des paquets de samples. Si la
plupart de cette section n'avait pas trop de sens pour vous, ne vous
inquiétez pas. Vous n'avez probablement pas encore besoin de cette
fonctionnalité. Mais vous vous rendrez compte quand vous en aurez
besoin et vous pourrez revenir et relire ceci quand vous commencerez à
travailler avec de grands dossiers de samples.



