-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Strings.Maps;
with SPARK.Ada.Strings.Not_SPARK;

package body SPARK.Ada.Strings.Unbounded.Not_SPARK is
   --# hide SPARK.Ada.Strings.Unbounded.Not_SPARK;

   pragma Warnings ("Y"); -- Turn off warnings for Ada 2005 features

   procedure Free (X : in out String_Access) is
   begin
      Standard.Ada.Strings.Unbounded.Free
        (X => Standard.Ada.Strings.Unbounded.String_Access (X));
   end Free;

   function To_String (Source : Unbounded_String) return String is
   begin
      return Standard.Ada.Strings.Unbounded.To_String
        (Source => Standard.Ada.Strings.Unbounded.Unbounded_String (Source));
   end To_String;

   function Slice
     (Source : Unbounded_String;
      Low    : Positive;
      High   : Natural) return String is
   begin
      return Standard.Ada.Strings.Unbounded.Slice
        (Source => Standard.Ada.Strings.Unbounded.Unbounded_String (Source),
         Low    => Low,
         High   => High);
   end Slice;

   function Index
     (Source  : Unbounded_String;
      Pattern : String;
      Going   : Direction := Direction_Forward;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural is
   begin
      return Standard.Ada.Strings.Unbounded.Index
        (Source  => Standard.Ada.Strings.Unbounded.Unbounded_String (Source),
         Pattern => Pattern,
         Going   => Strings.Not_SPARK.To_Direction (From => Going),
         Mapping => Standard.Ada.Strings.Maps.Character_Mapping_Function
           (Mapping));
   end Index;

   --  Index is only defined in Ada 2005
   function Index
     (Source  : Unbounded_String;
      Pattern : String;
      From    : Positive;
      Going   : Direction := Direction_Forward;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural is
   begin
      return Standard.Ada.Strings.Unbounded.Index
        (Source  => Standard.Ada.Strings.Unbounded.Unbounded_String (Source),
         Pattern => Pattern,
         From    => From,
         Going   => Strings.Not_SPARK.To_Direction (From => Going),
         Mapping => Standard.Ada.Strings.Maps.Character_Mapping_Function
           (Mapping));
   end Index;

   function Count
     (Source  : Unbounded_String;
      Pattern : String;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural is
   begin
      return Standard.Ada.Strings.Unbounded.Count
        (Source  => Standard.Ada.Strings.Unbounded.Unbounded_String (Source),
         Pattern => Pattern,
         Mapping => Standard.Ada.Strings.Maps.Character_Mapping_Function
           (Mapping));
   end Count;

   function Translate
     (Source  : Unbounded_String;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function)
     return Unbounded_String is
   begin
      return Unbounded_String
        (Standard.Ada.Strings.Unbounded.Translate
           (Source  => Standard.Ada.Strings.Unbounded.Unbounded_String
              (Source),
            Mapping => Standard.Ada.Strings.Maps.Character_Mapping_Function
              (Mapping)));
   end Translate;

   procedure Translate
     (Source  : in out Unbounded_String;
      Mapping : in     Maps.Not_SPARK.Character_Mapping_Function) is
   begin
      Standard.Ada.Strings.Unbounded.Translate
        (Source  => Standard.Ada.Strings.Unbounded.Unbounded_String (Source),
         Mapping => Standard.Ada.Strings.Maps.Character_Mapping_Function
           (Mapping));
   end Translate;

end SPARK.Ada.Strings.Unbounded.Not_SPARK;
