/*
 * $Id: IllegalStreamStateException.java,v 1.1 2004-07-12 17:27:21 cniles Exp $
 *
 * Copyright (c) 2004, Christian Niles, Unit12
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *              *   Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 * 
 *          *   Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 * 
 *      *   Neither the name of Christian Niles, Unit12, nor the names of its
 *          contributors may be used to endorse or promote products derived from
 *          this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package javanet.staxutils.error;

import javax.xml.stream.Location;

/**
 * {@link IllegalStateException} that includes a StAX {@link Location} identifying
 * the point where the error occured.
 * 
 * @author Christian Niles
 * @version $Revision: 1.1 $
 */
public class IllegalStreamStateException extends IllegalStateException {

    /** The location in the stream where the error occured. */
    private Location location;

    public IllegalStreamStateException() {

    }

    public IllegalStreamStateException(Location location) {

        this.location = location;

    }

    public IllegalStreamStateException(String s) {

        super(s);

    }

    public IllegalStreamStateException(String s, Location location) {

        super(s);
        this.location = location;

    }

    /**
     * Returns the {@link Location} where the error occured.
     * 
     * @return The {@link Location} where the error occured.
     */
    public Location getLocation() {

        return this.location;

    }

    /**
     * Sets the {@link Location} where the error occured.
     * 
     * @param location The {@link Location} where the error occured.
     */
    public void setLocation(Location location) {

        this.location = location;

    }

}
