#!/usr/bin/env python
#Copyright (c) 2012 Walter Bender

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# You should have received a copy of the GNU General Public License
# along with this library; if not, write to the Free Software
# Foundation, 51 Franklin Street, Suite 500 Boston, MA 02110-1335 USA

# Albert Munsell-inspired class library
# Chromas at values 2-9 by hue

MUN = [
        [ # Neutral
        [52, 52, 52], [73, 73, 73], [97, 97, 97], [122, 122, 122],
	 [147, 147, 147], [173, 173, 173], [200, 200, 200], [228, 228, 228]],
        [ # Chroma low
	# 5R
	[[66, 44, 49], [90, 69, 66], [115, 93, 90], [140, 117, 115],
	 [165, 142, 140], [189, 170, 165], [214, 199, 198], [247, 227, 222]],
	# 5YR
	[[66, 48, 41], [90, 69, 57], [115, 93, 82], [140, 117, 107],
	 [165, 142, 132], [189, 170, 156], [222, 199, 181], [247, 227, 214]],
	# 5Y
	[[57, 52, 33], [82, 73, 49], [107, 97, 74], [132, 121, 99],
	 [156, 146, 123], [181, 174, 148], [214, 203, 173], [239, 231, 198]],
	# 5GY
	[[49, 52, 41], [66, 77, 57], [90, 97, 74], [115, 125, 99],
	 [140, 150, 123], [173, 178, 148], [198, 207, 173], [231, 235, 198]],
	# 5G
	[[41, 52, 49], [57, 77, 66], [82, 101, 90], [107, 125, 115],
	 [132, 154, 140], [156, 182, 165], [181, 207, 189], [206, 239, 222]],
	# 5BG
	[[33, 52, 49], [57, 77, 74], [74, 101, 99], [99, 125, 123],
	 [123, 154, 148], [148, 178, 173], [181, 207, 206], [206, 235, 231]],
	# 5B
	[[41, 52, 57], [57, 77, 82], [82, 101, 107], [107, 125, 132],
	 [132, 150, 156], [156, 178, 181], [181, 207, 214], [214, 235, 239]],
	# 5PB
	[[41, 52, 66], [66, 73, 90], [90, 97, 107], [115, 121, 132],
	 [140, 150, 156], [165, 174, 189], [198, 203, 214], [222, 231, 239]],
	# 5P
	[[57, 48, 57], [82, 69, 82], [99, 93, 107], [123, 117, 132],
	 [156, 146, 156], [181, 170, 181], [206, 199, 214], [231, 227, 239]], 
	# 5RP
	[[66, 44, 57], [90, 69, 74], [107, 93, 99], [132, 117, 123],
	 [165, 142, 148], [189, 170, 173], [214, 199, 206], [239, 227, 231]]],
	[# Chroma moderate
	# 5R
	[[82, 32, 41], [115, 52, 57], [140, 81, 74], [173, 105, 99],
	 [198, 130, 123], [222, 158, 156], [239, 190, 189], [-1, -1, -1]],
	# 5YR
	[[82, 40, 8], [107, 60, 24], [132, 85, 49], [165, 109, 66],
	 [189, 137, 90], [222, 162, 115], [247, 190, 140], [-1, -1, -1]],
	# 5Y
	[[57, 48, 8], [82, 73, 33], [115, 93, 24], [140, 121, 41],
	 [165, 146, 66], [198, 174, 90], [222, 203, 115], [247, 231, 173]],
	# 5GY
	[[41, 56, 24], [57, 81, 16], [82, 105, 33], [107, 130, 57],
	 [132, 154, 82], [165, 182, 107], [189, 211, 123], [222, 239, 148]],
	# 5G
	[[24, 56, 41], [41, 81, 66], [33, 109, 82], [57, 134, 107],
	 [82, 162, 123], [115, 190, 156], [140, 219, 181], [156, 247, 206]],
	# 5BG
	[[8, 56, 57], [24, 81, 82], [49, 105, 99], [41, 134, 132],
	 [66, 162, 156], [99, 190, 181], [123, 219, 206], [140, 247, 231]], 
	# 5B
	[[16, 56, 74], [33, 77, 99], [16, 105, 132], [49, 130, 156],
	 [82, 158, 181], [107, 186, 206], [132, 215, 239], [-1, -1, -1]],
	# 5PB V2-V9
	[[24, 52, 90], [49, 73, 115], [74, 97, 140], [99, 121, 165],
	 [123, 150, 189], [148, 174, 214], [173, 203, 247], [-1, -1, -1]],
	# 5P V2-V9
	[[66, 40, 74], [90, 60, 107], [115, 85, 132], [140, 113, 156],
	 [165, 138, 181], [189, 166, 206], [214, 195, 239], [-1, -1,-1]],
	# 5RP V2-V9
	[[82, 36, 57], [107, 56, 82], [132, 81, 99], [165, 105, 123],
	 [189, 134, 148], [214, 158, 181], [247, 186, 206], [-1, -1, -1]]],
	[# max chroma
	# 5R
	[[99, 24, 41], [140, 32, 41], [189, 36, 49], [239, 32, 57],
	 [247, 101, 99], [239, 150, 148], [-1, -1, -1], [-1, -1, -1]],
	# 5YR
	[[-1, -1, -1], [-1, -1, -1], [140, 81, 33], [181, 101, 24],
	 [222, 125, 24], [247, 154, 82], [-1, -1, -1], [-1, -1, -1]],
	# 5Y
	[[-1, -1, -1], [-1, -1, -1], [-1, -1, -1], [-1, -1, -1],
	 [173, 146, 41], [206, 174, 16], [231, 199, 57], [-1, -1, -1]],
	# 5GY
	[[-1, -1, -1], [-1, -1, -1], [-1, -1, -1], [107, 130, 24],
	 [132, 158, 49], [156, 186, 41], [181, 215, 8], [206, 247, 41]],
	# 5G
	[[-1, -1, -1], [-1, -1, -1], [-1, -1, -1], [8, 138, 99],
	 [57, 166, 123], [41, 199, 140], [74, 227, 165], [-1, -1, -1]],
	# 5BG
	[[-1, -1, -1], [-1, -1, -1], [-1, -1, -1], [-1, -1, -1],
	 [-1,-1, -1], [57, 195, 181], [82, 223, 206], [-1, -1, -1]], 
	# 5B
	[[-1, -1, -1], [-1, -1, -1], [-1, -1, -1], [-1, -1, -1],
	 [24,162, 198], [74, 190, 222], [-1, -1, -1], [-1, -1, -1]], 
	# 5PB
	[[-1, -1, -1], [33, 73, 123], [41, 97, 165], [49, 121, 206],
	 [82,150, 239], [140, 178, 231], [-1, -1, -1], [-1, -1, -1]], 
	# 5P
	[[82, 20, 99], [115, 20, 148], [165, 16, 198], [198, 48, 239],
	 [198, 109, 247], [206, 154, 247], [-1, -1, -1], [-1, -1, -1]],
	# 5RP
	[[99, 8, 66], [140, 16, 90], [189, 20, 115], [231, 40, 140],
	 [247, 93, 165], [247, 146, 181], [-1, -1, -1], [-1, -1, -1]]]]

from random import uniform

class MunColor():

    def __init__(self):
        self.hue = 0
        self.value = 5
        self.chroma = 1

    def set_hue(self, hue):
        self.hue = hue % 10

    def set_value(self, value):
        self.value = max(min(value, 9), 2)

    def set_chroma(self, chroma):
        self.chroma = max(min(chroma, 3), 0)

    def random(self):
        self.hue = int(uniform(0, 10))
        self.value = int(uniform(2, 10))
        self.chroma = int(uniform(0, 4))
        return self.get_color()

    def random_chroma(self, c1, c2):
        self.hue = int(uniform(0, 10))
        self.value = int(uniform(2, 10))
        self.chroma = int(uniform(c1, c2)) % 4
        return self.get_color()

    def random_value(self, v1, v2):
        self.hue = int(uniform(0, 10))
        self.value = max(min(int(uniform(v1, v2)), 9), 2)
        self.chroma = int(uniform(0, 4))
        return self.get_color()

    def random_hue(self, h1, h2):
        self.hue = int(uniform(h1, h2)) % 10
        self.value = int(uniform(2, 10))
        self.chroma = int(uniform(0, 4))
        return self.get_color()

    def random_hvc(self, h1, h2, v1, v2, c1, c2):
        self.hue = int(uniform(h1, h2)) % 10
        self.value = max(min(int(uniform(v1, v2)), 9), 2)
        self.chroma = int(uniform(c1, c2)) % 4
        return self.get_color()

    def hvc(self, hue, value, chroma):
        self.set_hue(hue)
        self.set_value(value)
        self.set_chroma(chroma)
        return self.get_color()

    def get_color(self):
        c = self.chroma
        rgb = [-1, -1, -1]
        while -1 in rgb:
            if c == 0:
                rgb = MUN[0][self.value - 2]
            else:
                rgb = MUN[c][self.hue][self.value - 2]
            if -1 in rgb:
                c -= 1
        return '#%02x%02x%02x' % (rgb[0], rgb[1], rgb[2])
