# -*- coding: utf-8 -*-
#Copyright (c) 2012 Walter Bender

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# You should have received a copy of the GNU General Public License
# along with this library; if not, write to the Free Software
# Foundation, 51 Franklin Street, Suite 500 Boston, MA 02110-1335 
def svg_header(colors):
    return '<?xml version="1.0" ?>\n\
<!DOCTYPE svg  PUBLIC "-//W3C//DTD SVG 1.1//EN"\
   "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd" [\n\
	<!ENTITY stroke_color "%s">\n\
	<!ENTITY fill_color "%s">\n\
]>\n\
<svg height="55px" viewBox="0 0 55 55" width="55px"\n\
     stroke-linecap="round" stroke-linejoin="round" stroke-width="3.5"\n\
      stroke="&stroke_color;" fill="&fill_color;">\n' % (colors[0], colors[1])

def svg_king(color):
  return '  <g\n\
     transform="matrix(1.2485077,0,0,0.99922675,-6.8339601,0.02333855)"\n\
     style="stroke-width:2.23826957;stroke-miterlimit:4;stroke-dasharray:none">\n\
    <g\n\
       transform="matrix(1,0,0,0.97905135,0,0.06306419)"\n\
       style="stroke:none">\n\
      <path\n\
         d="m 12.658106,53.827716 0,-4.778709 c 0,0 5.063754,-0.304895 6.717542,-1.158219 4.975737,-2.567387 4.646094,-18.853499 4.646094,-18.853499 l -5.439705,0 c -0.839477,-2.324197 5.401947,-2.284496 5.702394,-4.73732 0.701484,-5.726849 -10.250727,-13.947133 -10.250727,-13.947133 0,0 2.295963,-2.1630403 5.649622,-1.5533182 1.484507,0.2698953 3.142244,2.6896822 3.142244,2.6896822 0,0 0.547396,-2.1096036 1.524534,-2.7788088 1.380114,-0.9451903 1.18343,-3.8839179 1.18343,-3.8839179 l -2.015598,0.1262271 0,-1.758755 2.015598,0.023776 0,-1.8895174 2.226832,-0.1559196 0,52.6554316 z"\n\
         style="fill:%s;fill-opacity:1;stroke:none" />\n\
      <path\n\
         d="m 42.341894,53.827712 0,-4.77871 c 0,0 -5.063754,-0.304894 -6.717542,-1.158218 -4.975737,-2.567388 -4.646094,-18.853499 -4.646094,-18.853499 l 5.439705,0 c 0.839477,-2.324197 -5.401947,-2.284496 -5.702394,-4.73732 -0.701484,-5.726849 10.250727,-13.947133 10.250727,-13.947133 0,0 -2.295963,-2.1630405 -5.649622,-1.5533175 -1.484507,0.269895 -3.142244,2.6896815 -3.142244,2.6896815 0,0 -0.547396,-2.1096035 -1.524534,-2.7788085 -1.380114,-0.94519 -1.18343,-3.883918 -1.18343,-3.883918 l 2.015598,0.126227 0,-1.758755 -2.015598,0.02378 0,-1.889517 -2.226832,-0.15592 0,52.6554305 z"\n\
         style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
    </g>\n\
    <path\n\
       d="m 27.34375,1.2319123 0,0.03125 -1.9375,0.125 0,1.84375 -2.03125,-0.03125 0,1.71875 2.03125,-0.125 c 0,0 0.192614,2.8871101 -1.1875,3.8125 -0.977138,0.6551862 -1.53125,2.7187497 -1.53125,2.7187497 0,0 -1.671743,-2.3607584 -3.15625,-2.6249997 -3.353659,-0.5969493 -5.625,1.4999997 -5.625,1.4999997 0,0 10.951484,8.04937 10.25,13.65625 -0.300447,2.40144 -6.558227,2.380742 -5.71875,4.65625 l 5.4375,0 c 0,0 0.350737,15.923896 -4.625,18.4375 -1.653788,0.835448 -6.71875,1.15625 -6.71875,1.15625 l 0,4.65625 14.8125,0 0.28125,0 14.84375,0 0,-4.65625 c 0,0 -5.064962,-0.320802 -6.71875,-1.15625 -4.975737,-2.513605 -4.65625,-18.4375 -4.65625,-18.4375 l 5.4375,0 c 0.839477,-2.275508 -5.387053,-2.25481 -5.6875,-4.65625 -0.701484,-5.60688 10.25,-13.65625 10.25,-13.65625 0,0 -2.302591,-2.0969498 -5.65625,-1.4999997 -1.484507,0.2642411 -3.15625,2.6249997 -3.15625,2.6249997 0,0 -0.522862,-2.0635636 -1.5,-2.7187497 -1.380114,-0.9253895 -1.1875,-3.8125 -1.1875,-3.8125 l 2,0.125 0,-1.71875 -2,0.03125 0,-1.84375 -1.96875,-0.125 0,-0.03125 -0.125,0 -0.15625,0 z"\n\
       style="fill:none;stroke:&stroke_color;;stroke-width:2.23826957;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />\n\
  </g>' % (color)

def svg_queen(color):
  return '  <g\n\
     transform="matrix(1.2400925,0,0,0.99217787,-6.6025437,0.41261734)"\n\
     id="g3825"\n\
     style="stroke-width:2.2538147;stroke-miterlimit:4;stroke-dasharray:none">\n\
    <g\n\
       transform="translate(0.1849045,0.0026902)"\n\
       style="stroke:none">\n\
      <path\n\
         d="m 12.248804,52.75 0,-3.468899 c 0,0 5.063754,-0.304895 6.717542,-1.158219 4.975737,-2.567387 4.646094,-22.853499 4.646094,-22.853499 l -5.439705,0 4.722002,-3.500243 -9.270335,-11.18421 c 0,0 2.295963,-2.1630399 5.649622,-1.5533178 1.484507,0.2698953 3.142244,2.6896818 3.142244,2.6896818 0,0 0.547396,-2.1096031 1.524534,-2.7788083 1.380114,-0.9451903 3.499389,-1.5274117 3.499389,-1.5274117 0,0 -2.500849,-0.5555543 -2.47113,-2.1910634 0.03351,-1.8439287 2.47113,-2.354391 2.47113,-2.354391 L 27.44,52.75 z"\n\
         style="fill:%s;fill-opacity:1;stroke:none" />\n\
      <path\n\
         d="m 42.381387,52.75 0,-3.468899 c 0,0 -5.063754,-0.304895 -6.717542,-1.158219 -4.975737,-2.567387 -4.646094,-22.853499 -4.646094,-22.853499 l 5.439705,0 -4.722002,-3.500243 9.270335,-11.18421 c 0,0 -2.295963,-2.1630403 -5.649622,-1.5533178 -1.484507,0.2698947 -3.142244,2.6896818 -3.142244,2.6896818 0,0 -0.547396,-2.1096029 -1.524534,-2.7788086 C 29.309275,7.9972953 27.19,7.415074 27.19,7.415074 c 0,0 2.500849,-0.5555538 2.47113,-2.1910633 C 29.62762,3.3800813 27.19,2.8696196 27.19,2.8696196 L 27.19,52.75 z"\n\
         style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
    </g>\n\
    <path\n\
       d="m 27.375,2.875 0,0.0625 c -0.56504,0.1608461 -2.190825,0.7446427 -2.21875,2.28125 -0.02477,1.3629242 1.640538,1.9585405 2.21875,2.125 l 0,0.0625 c 0,0 0.09747,-0.024378 0.125,-0.03125 0.03182,0.00802 0.125,0.03125 0.125,0.03125 l 0,-0.0625 C 28.176812,7.1880277 29.868878,6.6015825 29.84375,5.21875 29.815825,3.6821422 28.19004,3.098346 27.625,2.9375 l 0,-0.0625 c 0,0 -0.09395,0.023684 -0.125,0.03125 C 27.468946,2.898684 27.375,2.875 27.375,2.875 z m 0.25,4.53125 c 0,0 -0.114761,0.028366 -0.125,0.03125 C 27.4902,7.43474 27.375,7.40625 27.375,7.40625 l 0,0.09375 c -0.366824,0.1062466 -2.013206,0.5904641 -3.25,1.4375 -0.977138,0.669206 -1.53125,2.78125 -1.53125,2.78125 0,0 -1.640493,-2.417605 -3.125,-2.6875 -3.353659,-0.6097222 -5.65625,1.5625 -5.65625,1.5625 l 9.28125,11.1875 -4.71875,3.5 5.4375,0 c 0,0 0.319487,20.276363 -4.65625,22.84375 -1.653788,0.853324 -6.71875,1.15625 -6.71875,1.15625 l 0,3.46875 14.9375,0 0.25,0 14.9375,0 0,-3.46875 c 0,0 -5.064962,-0.302926 -6.71875,-1.15625 -4.975737,-2.567387 -4.625,-22.84375 -4.625,-22.84375 l 5.4375,0 -4.71875,-3.5 9.25,-11.1875 c 0,0 -2.302591,-2.1722226 -5.65625,-1.5625 -1.484507,0.269895 -3.125,2.6875 -3.125,2.6875 0,0 -0.554112,-2.112044 -1.53125,-2.78125 C 29.634926,8.0882181 27.985,7.6041381 27.625,7.5 l 0,-0.09375 z"\n\
       style="fill:none;stroke:&stroke_color;;stroke-width:2.2538147;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />\n\
  </g>' % (color)

def svg_bishop(color):
    return '  <g\n\
     transform="matrix(1.26334,0,0,0.99082261,-7.24185,0.27159352)"\n\
     style="stroke-width:2.23450804;stroke-miterlimit:4;stroke-dasharray:none">\n\
    <g\n\
       transform="translate(0.4616785,2.0932)"\n\
       style="stroke:none">\n\
      <path\n\
         d="m 12.248804,50.6568 0,-3.468899 c 0,0 5.063754,-0.304895 6.717542,-1.158219 4.975737,-2.567387 4.646094,-20.853499 4.646094,-20.853499 l -5.439705,0 6.402656,-4.099698 C 21.514596,19.079162 20.71868,16.327441 20.737297,14.776585 20.761162,12.788552 21.912462,9.5577976 26.19901,8.2427944 27.429282,7.8653785 25.047978,7.8003211 25.245401,6.0629633 25.380926,4.8703258 26.007324,4.4256454 27.184411,4.3432 l 0,46.3136 z"\n\
         style="fill:%s;fill-opacity:1;stroke:none" />\n\
      <path\n\
         d="m 41.827839,50.6568 0,-3.468899 c 0,0 -5.063754,-0.304895 -6.717542,-1.158219 C 30.13456,43.462295 30.464203,25.176183 30.464203,25.176183 l 5.439705,0 -6.402656,-4.099698 c 3.060795,-1.997323 3.856711,-4.749044 3.838094,-6.2999 -0.02387,-1.988033 -1.175165,-5.2187876 -5.461713,-6.5337906 -1.230272,-0.3774161 1.151032,-0.442473 0.953609,-2.179831 -0.135525,-1.1926381 -0.761923,-1.6373181 -1.93901,-1.7197631 l 0,46.3135997 z"\n\
         style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
    </g>\n\
    <path\n\
       d="m 27.34375,6.4375002 0,0.03125 c -0.97538,0.1388598 -1.533316,0.6056649 -1.65625,1.6875 -0.197423,1.7373577 2.199022,1.8100837 0.96875,2.1874998 -4.286548,1.315004 -5.44488,4.543217 -5.46875,6.53125 -0.01862,1.550856 0.782955,4.283927 3.84375,6.28125 l -6.40625,4.125 5.4375,0 c 0,0 0.350737,18.276363 -4.625,20.84375 -1.653788,0.853324 -6.71875,1.15625 -6.71875,1.15625 l 0,3.46875 14.625,0 0.28125,0 14.65625,0 0,-3.46875 c 0,0 -5.064962,-0.302926 -6.71875,-1.15625 -4.975737,-2.567387 -4.65625,-20.84375 -4.65625,-20.84375 l 5.46875,0 -6.40625,-4.125 c 3.060795,-1.997323 3.831117,-4.730394 3.8125,-6.28125 -0.02387,-1.988033 -1.150952,-5.216247 -5.4375,-6.53125 -1.230272,-0.3774161 1.134923,-0.4501421 0.9375,-2.1874998 -0.123421,-1.0861193 -0.673441,-1.5506904 -1.65625,-1.6875 l 0,-0.03125 c -0.04971,0.00348 -0.07725,0.026447 -0.125,0.03125 -0.05644,-0.00603 -0.09703,-0.027102 -0.15625,-0.03125 z"\n\
       style="fill:none;stroke:&stroke_color;;stroke-width:2.23450804;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />\n\
  </g>' % (color)

def svg_knight(color):
    return '  <g\n\
     transform="matrix(1.2165491,0,0,0.99238691,-5.9551002,0.27813261)"\n\
     id="g3783">\n\
    <g\n\
       transform="translate(0,2.049694)"\n\
       style="stroke:none">\n\
      <path\n\
         d="m 13.440724,50.700306 0,-3.468899 c 0,0 5.063754,-0.304895 6.717542,-1.158219 4.975737,-2.567387 4.646094,-10.853499 4.646094,-10.853499 l -7.439705,0 7.880585,-14.18671 c -2.076635,2.536817 -3.046328,3.17778 -6.378201,2.538586 -1.396898,1.237102 -2.0977,2.300181 -3.494598,3.537283 l -3.3922,-2.758489 c 0,0 8.204406,-12.235256 9.67669,-13.481023 2.148801,-1.8182 1.472289,-1.604605 3.699373,-1.809071 1.298661,-0.119228 0.02196,-2.889384 2.758991,-4.7605709 l 0.261036,46.4006119 z"\n\
         style="fill:%s;fill-opacity:1;stroke:none" />\n\
      <path\n\
         d="m 43.019759,50.700306 0,-3.468899 c 0,0 -5.063754,-0.304895 -6.717542,-1.158219 C 31.32648,43.505801 31.656123,35.219689 31.656123,35.219689 l 8.050058,-0.08701 -0.65988,-12.620498 C 38.657902,15.083854 33.876641,10.24922 32.550024,9.852512 29.898553,10.265591 31.437562,6.752643 28.258176,4.3867061 L 28.084152,50.700306 z"\n\
         style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
    </g>\n\
    <path\n\
       d="m 28.015625,6.34375 0,0.1875 c -2.402227,1.8632619 -1.243572,4.447149 -2.5,4.5625 -2.227084,0.204466 -1.569949,-0.0057 -3.71875,1.8125 -1.472284,1.245767 -9.65625,13.5 -9.65625,13.5 l 3.375,2.75 c 1.396898,-1.237102 2.103102,-2.294148 3.5,-3.53125 3.331873,0.639194 4.298365,-0.02568 6.375,-2.5625 l -7.875,14.1875 7.4375,0 c 0,0 0.350737,8.307613 -4.625,10.875 -1.653788,0.853324 -6.71875,1.15625 -6.71875,1.15625 l 0,3.46875 14.40625,0 0.5,0 14.34375,0 0,-3.46875 c 0,0 -5.064962,-0.302926 -6.71875,-1.15625 -4.975737,-2.567387 -4.625,-10.875 -4.625,-10.875 l 8.03125,-0.0625 -0.65625,-12.625 c -0.388399,-7.428327 -5.173383,-12.259542 -6.5,-12.65625 -2.57631,0.401369 -1.284049,-2.9810068 -4.125,-5.34375 l 0,-0.21875 c -0.04451,0.030426 -0.08259,0.062864 -0.125,0.09375 -0.04073,-0.031939 -0.08265,-0.062237 -0.125,-0.09375 z"\n\
       style="fill:none;stroke:&stroke_color;;stroke-width:2.5;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />\n\
  </g>' % (color)

def svg_rook(color):
    return '  <g\n\
     transform="matrix(1.2556041,0,0,0.98957446,-7.0291127,5.9926068)"\n\
     id="g3789"\n\
     style="stroke-width:2.24279404;stroke-miterlimit:4;stroke-dasharray:none">\n\
    <g\n\
       transform="translate(0.25,-5.4906)"\n\
       style="stroke:none">\n\
      <path\n\
         d="m 12.375,52.75 0,-3.468899 c 0,0 4.955557,-0.304895 6.609345,-1.158219 4.975736,-2.567387 4.719281,-20.853499 4.719281,-20.853499 l -4,0 0,-3.240246 -2.828626,0 0,-10.797937 3.171374,0 0,4.142269 4,0 0,-4.142269 3.328626,0 0,39.5188 z"\n\
         style="fill:%s;fill-opacity:1;stroke:none" />\n\
      <path\n\
         d="m 42.125,52.749999 0,-3.468899 c 0,0 -4.955557,-0.304895 -6.609345,-1.158219 -4.975736,-2.567387 -4.719281,-20.853498 -4.719281,-20.853498 l 4,0 0,-3.240246 2.828626,0 0,-10.797936 -3.171374,0 0,4.142268 -4,0 0,-4.142268 -3.328626,0 0,39.518798 z"\n\
         style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
    </g>\n\
    <path\n\
       d="m 17.125,7.75 0,10.78125 2.84375,0 0,3.25 4,0 c 0,0 0.256986,18.276363 -4.71875,20.84375 -1.653788,0.853324 -6.625,1.15625 -6.625,1.15625 l 0,3.46875 14.75,0 0.25,0 14.75,0 0,-3.46875 c 0,0 -4.939962,-0.302926 -6.59375,-1.15625 C 30.805514,40.057613 31.0625,21.78125 31.0625,21.78125 l 4,0 0,-3.25 2.8125,0 0,-10.78125 -3.15625,0 0,4.125 -4,0 0,-4.125 -3.09375,0 -0.25,0 -3.0625,0 0,4.125 -4,0 0,-4.125 -3.1875,0 z"\n\
       style="fill:none;stroke:&stroke_color;;stroke-width:2.24279404;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />\n\
  </g>' % (color)

def svg_pawn(color):
    return '  <g\n\
     transform="translate(0,2.80808)"\n\
     style="stroke:none">\n\
    <path\n\
       d="m 12.491825,49.94192 13.88066,-7.25995 c 0,0 -11.69178,-1.56637 -11.68897,-11.59766 0.003,-10.03129 11.41501,-12.05425 11.41501,-12.05425 0,0 -5.93421,-1.84586 -5.93581,-7.12297 -0.002,-5.23359 7.21429,-6.84901 7.21429,-6.84901 l 0,44.88384 z"\n\
       style="fill:%s;fill-opacity:1;stroke:none" />\n\
    <path\n\
       d="m 42.508175,49.94192 -13.88066,-7.25995 c 0,0 11.69178,-1.56637 11.68897,-11.59766 -0.003,-10.03129 -11.41501,-12.05425 -11.41501,-12.05425 0,0 5.93421,-1.84586 5.93581,-7.12297 0.002,-5.23359 -7.21429,-6.84901 -7.21429,-6.84901 l 0,44.88384 z"\n\
       style="fill:&fill_color;;fill-opacity:1;stroke:none" />\n\
  </g>\n\
  <path\n\
     d="m 27.375,7.875 0,0.0625 c -0.710664,0.174133 -6.97064,1.8363323 -6.96875,6.78125 0.0016,5.27711 5.9375,7.125 5.9375,7.125 0,0 -11.40325,1.99996 -11.40625,12.03125 C 14.9347,43.90629 26.625,45.5 26.625,45.5 l -13.875,7.25 14.625,0 0.25,0 14.625,0 -13.875,-7.25 c 0,0 11.69031,-1.59371 11.6875,-11.625 -0.003,-10.03129 -11.40625,-12.03125 -11.40625,-12.03125 0,0 5.9359,-1.84789 5.9375,-7.125 C 34.59564,9.7738323 28.335664,8.111633 27.625,7.9375 l 0,-0.0625 c 0,0 -0.114037,0.03125 -0.125,0.03125 -0.01096,0 -0.125,-0.03125 -0.125,-0.03125 z"\n\
     style="fill:none;stroke:&stroke_color;;stroke-width:2.5;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none" />' % (color)

def svg_footer():
    return '</svg>\n'
