/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

"use strict";

const path = require("path");
const fs = require("fs");

function readFile(path) {
  return fs
    .readFileSync(path, { encoding: "utf-8" })
    .split("\n")
    .filter(p => p && !p.startsWith("#"))
    .map(p => p.replace(/^comm\//, "../"));
}

const ignorePatterns = [
  ...readFile(
    path.join(__dirname, "..", "tools", "lint", "ThirdPartyPaths.txt")
  ),
  ...readFile(path.join(__dirname, "..", "tools", "lint", "Generated.txt")),
];

module.exports = {
  plugins: [],
  recurseDepth: 10,
  source: {
    exclude: [
      "../calendar/base/calendar.js",
      "../calendar/base/content/calendar-base-view.js",
      "../calendar/base/content/calendar-task-tree-view.js",
      "../calendar/base/content/dialogs/calendar-event-dialog-attendees.js",
      "../calendar/base/content/dialogs/calendar-event-dialog-recurrence.js",
      "../calendar/base/content/widgets/calendar-filter.js",
      "../calendar/base/content/widgets/calendar-invitation-panel.js",
      "../calendar/base/content/widgets/calendar-notifications-setting.js",
      "../calendar/base/content/widgets/datetimepickers.js",
      "../calendar/base/modules/utils/calDateTimeFormatter.sys.mjs",
      "../calendar/base/modules/utils/calIteratorUtils.sys.mjs",
      "../calendar/extract/CalExtractParser.sys.mjs",
      "../calendar/providers/caldav/modules/CalDavRequest.sys.mjs",
      "../calendar/providers/caldav/modules/CalDavSession.sys.mjs",
      "../calendar/providers/storage/CalStorageCachedItemModel.sys.mjs",
      "../calendar/providers/storage/CalStorageDatabase.sys.mjs",
      "../calendar/providers/storage/CalStorageItemModel.sys.mjs",
      "../calendar/providers/storage/CalStorageStatements.sys.mjs",
      "../calendar/test/browser/browser_eventUndoRedo.js",
      "../calendar/test/browser/browser_taskUndoRedo.js",
      "../calendar/test/browser/browser_todayPane.js",
      "../calendar/test/unit/test_calreadablestreamfactory.js",

      "../chat/chat-prefs.js",
      "../chat/components/src/imCommands.sys.mjs",
      "../chat/components/src/logger.sys.mjs",
      "../chat/modules/OTR.sys.mjs",
      "../chat/modules/imContentSink.sys.mjs",
      "../chat/modules/jsProtoHelper.sys.mjs",
      "../chat/protocols/matrix/matrixAccount.sys.mjs",
      "../chat/protocols/matrix/matrixAccountLogger.sys.mjs",
      "../chat/protocols/matrix/matrixCommands.sys.mjs",
      "../chat/protocols/matrix/matrixMessageContent.sys.mjs",
      "../chat/protocols/matrix/test/head.js",

      "../mail/app/profile/all-icedove.js",
      "../mail/base/content/FilterListDialog.js",
      "../mail/base/content/about3Pane.js",
      "../mail/base/content/sanitize.js",
      "../mail/base/content/sync.js",
      "../mail/base/content/widgets/customizable-toolbar.js",
      "../mail/base/content/widgets/tree-view.mjs",
      "../mail/base/test/browser/browser_cardsView.js",
      "../mail/base/test/browser/browser_editMenu.js",
      "../mail/base/test/browser/browser_spacesToolbar.js",
      "../mail/branding/tb_beta/pref/icedove-branding.js",
      "../mail/branding/icedove/pref/icedove-branding.js",
      "../mail/components/accountcreation/content/accountSetup.js",
      "../mail/components/accountcreation/modules/AccountCreationUtils.sys.mjs",
      "../mail/components/accountcreation/modules/ExchangeAutoDiscover.sys.mjs",
      "../mail/components/accountcreation/modules/FetchConfig.sys.mjs",
      "../mail/components/accountcreation/modules/FetchHTTP.sys.mjs",
      "../mail/components/accountcreation/modules/GuessConfig.sys.mjs",
      "../mail/components/activity/content/activity-widgets.js",
      "../mail/components/addrbook/content/vcard-edit/edit.mjs",
      "../mail/components/compose/composer.js",
      "../mail/components/compose/content/addressingWidgetOverlay.js",
      "../mail/components/customizableui/CustomizableUI.sys.mjs",
      "../mail/components/enterprisepolicies/Policies.sys.mjs",
      "../mail/components/enterprisepolicies/schemas/schema.sys.mjs",
      "../mail/components/extensions/parent/ext-mail.js",
      "../mail/components/extensions/test/browser/browser_ext_compose_details_body.js",
      "../mail/components/extensions/test/browser/browser_ext_menus_context_tools_main_menu.js",
      "../mail/components/extensions/test/browser/head.js",
      "../mail/components/im/test/TestProtocol.sys.mjs",
      "../mail/components/preferences/messengerLanguages.js",
      "../mail/components/search/SearchSupport.sys.mjs",
      "../mail/components/storybook/node_modules",
      "../mail/components/unifiedtoolbar/content/items/mail-go-button.mjs",
      "../mail/components/unifiedtoolbar/content/mail-tab-button.mjs",
      "../mail/components/unifiedtoolbar/modules/CustomizableItems.sys.mjs",
      "../mail/components/unifiedtoolbar/modules/ToolbarMigration.sys.mjs",
      "../mail/extensions/am-e2e/prefs/e2e-prefs.js",
      "../mail/extensions/openpgp/content/modules/cryptoAPI/GnuPGCryptoAPI.sys.mjs",
      "../mail/extensions/openpgp/content/modules/cryptoAPI/RNPCryptoAPI.sys.mjs",
      "../mail/extensions/openpgp/content/modules/cryptoAPI/interface.js",
      "../mail/extensions/openpgp/content/modules/keyRing.sys.mjs",
      "../mail/extensions/openpgp/content/modules/keyserver.sys.mjs",
      "../mail/locales/en-US/all-l10n.js",
      "../mail/modules/CommandController.mjs",
      "../mail/modules/DBViewWrapper.sys.mjs",
      "../mail/modules/GlobalPopupNotifications.sys.mjs",
      "../mail/modules/SearchSpec.sys.mjs",
      "../mail/modules/UIFontSize.sys.mjs",
      "../mail/test/browser/attachment/browser_openAttachment.js",
      "../mail/test/browser/cloudfile/browser_attachmentErrors.js",
      "../mail/test/browser/composition/browser_attachmentReminder.js",
      "../mail/test/browser/composition/browser_drafts.js",
      "../mail/test/browser/composition/browser_multipartRelated.js",
      "../mail/test/browser/composition/browser_sendFormat.js",
      "../mail/test/browser/folder-display/browser_messageCommands.js",
      "../mail/test/browser/folder-display/browser_messageCommandsArchive.js",
      "../mail/test/browser/folder-display/browser_watchIgnoreThread.js",
      "../mail/test/browser/folder-widget/browser_messageFilters.js",
      "../mail/test/browser/message-header/browser_messageHeader.js",
      "../mail/test/browser/shared-modules/ComposeHelpers.sys.mjs",

      "../mailnews/addrbook/modules/LDAPMessage.sys.mjs",
      "../mailnews/base/src/MailChannel.sys.mjs",
      "../mailnews/base/src/VirtualFolderWrapper.sys.mjs",
      "../mailnews/compose/src/MessageSend.sys.mjs",
      "../mailnews/compose/src/MimeMessageUtils.sys.mjs",
      "../mailnews/compose/src/MimePart.sys.mjs",
      "../mailnews/db/gloda/modules/Collection.sys.mjs",
      "../mailnews/db/gloda/modules/Gloda.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaConstants.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaDataModel.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaDatabind.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaDatastore.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaExplicitAttr.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaFundAttr.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaIndexer.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaMsgIndexer.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaMsgSearcher.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaQueryClassFactory.sys.mjs",
      "../mailnews/db/gloda/modules/GlodaUtils.sys.mjs",
      "../mailnews/db/gloda/modules/IndexMsg.sys.mjs",
      "../mailnews/db/gloda/modules/MimeMessage.sys.mjs",
      "../mailnews/db/gloda/modules/NounFreetag.sys.mjs",
      "../mailnews/db/gloda/modules/NounMimetype.sys.mjs",
      "../mailnews/db/gloda/modules/NounTag.sys.mjs",
      "../mailnews/db/gloda/modules/SuffixTree.sys.mjs",
      "../mailnews/db/gloda/test/unit/resources/GlodaTestHelper.sys.mjs",
      "../mailnews/db/gloda/test/unit/resources/GlodaTestHelperFunctions.sys.mjs",
      "../mailnews/extensions/mdn/mdn.js",
      "../mailnews/imap/src/ImapClient.sys.mjs",
      "../mailnews/imap/src/ImapIncomingServer.sys.mjs",
      "../mailnews/imap/src/ImapMessageService.sys.mjs",
      "../mailnews/import/content/csv-field-map.js",
      "../mailnews/import/modules/BaseProfileImporter.sys.mjs",
      "../mailnews/import/modules/ThunderbirdProfileImporter.sys.mjs",
      "../mailnews/import/test/unit/test_ThunderbirdProfileImporter.js",
      "../mailnews/jsaccount/modules/JSAccountUtils.sys.mjs",
      "../mailnews/mailnews.js",
      "../mailnews/mime/jsmime/jsmime.mjs",
      "../mailnews/news/src/NntpClient.sys.mjs",
      "../mailnews/news/src/NntpMessageService.sys.mjs",
      "../mailnews/news/src/NntpNewsGroup.sys.mjs",
      "../mailnews/news/src/NntpService.sys.mjs",
      "../mailnews/test/fakeserver/Auth.sys.mjs",
      "../mailnews/test/resources/MailTestUtils.sys.mjs",
      "../mailnews/test/resources/MessageGenerator.sys.mjs",
      "../mailnews/test/resources/ServerTestUtils.sys.mjs",

      "../suite",

      "../node_modules",

      ...ignorePatterns,
    ],
    includePattern: ".+\\.m?js(doc)?$",
    excludePattern: "(^|\\/|\\\\|browser|test)_",
  },
  opts: {
    recurse: true,
  },
};
